package freenetmessageboard.core;

/**
 * Title:
 * Description:
 * Copyright:    Copyright (c) 2002
 * Company:
 * @author
 * @version 1.0
 */

public class MessageArchive {

  private byte[] compressedBytes;

  private String description;
  private String messageListing;

  public MessageArchive(Message[] messages, String description) throws java.io.IOException {
    try {
      this.description=description;
      this.insertMessages(messages);
      if (this.verifyArchive(messages)==false) {
        throw new java.io.IOException("the message archive was created but didn't pass the verifciation!");
      }
    }
    catch (java.io.IOException ex) {
      CoreLogger.log("Exception while creating archive: "+ex.getClass().getName()+": "+ex.getMessage(), CoreLogger.LOG_ERROR);
      throw ex;
    }
  }

  public String getDescription() {
    return this.description;
  }

  public MessageArchive(byte[] bytes) {
    this.compressedBytes=bytes;
  }

  private boolean verifyArchive(Message[] messages) throws java.io.IOException {
    try {
      CoreLogger.log("verifying the new archive...", CoreLogger.LOG_NORMAL);
      StringBuffer buf = new StringBuffer();
      Message[] decompressed = this.getMessages();
      for (int i=0; i<messages.length; i++) {
        if (buf.toString().length()+messages[i].getUniqueId().length()+500>MessageGateway.maxInsertSize) {
          break;
        }
        buf.append(messages[i].getUniqueId());
        buf.append('\n');
      }
      this.messageListing=buf.toString();
      CoreLogger.log("the new message archive is verified, the message listing is "+this.messageListing.length()+" chars long", CoreLogger.LOG_NORMAL);
      return true;
    } catch (java.io.IOException ex) {
      CoreLogger.log("Exception while verifying archive: "+ex.getClass().getName()+": "+ex.getMessage(), CoreLogger.LOG_ERROR);
      throw ex;
    }
  }

  public String getMessageListing() {
    return this.messageListing;
  }

  byte[] getBytes() {
    return this.compressedBytes;
  }

  Message[] getMessages() throws java.io.IOException {
    try {
      CoreLogger.log("decompressing archive with "+this.compressedBytes.length+" bytes size", CoreLogger.LOG_NORMAL);
      java.io.ByteArrayInputStream bais = new java.io.ByteArrayInputStream(this.compressedBytes);
      java.util.zip.ZipInputStream zipInputStream = new java.util.zip.ZipInputStream(bais);
      zipInputStream.getNextEntry();

      java.io.InputStreamReader isr = new java.io.InputStreamReader(zipInputStream);
      java.io.LineNumberReader lnr = new java.io.LineNumberReader(isr);
      StringBuffer msgBuf = new StringBuffer();
      java.util.List messages = new java.util.LinkedList();

      while(true) {
        String nextLine = lnr.readLine();
        if (nextLine==null) break;
        msgBuf.append(nextLine);
        msgBuf.append("\n");
        if (nextLine.equals("</message>")) {
          try {
            Message message = Message.parseString(msgBuf.toString());
            messages.add(message);
          } catch (MessageFormatException ex) {
            CoreLogger.log("failed to parse message from archive: "+ex.getMessage(), CoreLogger.LOG_ERROR);
          }
          msgBuf=new StringBuffer();
        }
      }
      CoreLogger.log("finished decompressing, "+messages.size()+" messages were found.", CoreLogger.LOG_NORMAL);
 //     java.util.Collections.sort(messages, Message.getUsefulorBroadcoastingComparator());
      return (Message[])messages.toArray(new Message[messages.size()]);
    } catch (java.io.IOException ex) {
      CoreLogger.log("Exception while creating archive: "+ex.getClass().getName()+": "+ex.getMessage(), CoreLogger.LOG_ERROR);
      ex.printStackTrace();
      throw ex;
    }
  }

  private void insertMessages(Message[] messages) throws java.io.IOException {
    try {
      CoreLogger.log("compressing "+messages.length+" messages...", CoreLogger.LOG_NORMAL);
      java.io.ByteArrayOutputStream compressedBytesOutputStream = new java.io.ByteArrayOutputStream();
      java.util.zip.ZipOutputStream zipOs = new java.util.zip.ZipOutputStream(compressedBytesOutputStream);
      zipOs.putNextEntry(new java.util.zip.ZipEntry("messages"));
      for (int i=0; i<messages.length; i++) {
        zipOs.write(Message.getBytesFromString(messages[i].getString()));
        zipOs.write(Message.getBytesFromString("\n"));
      }
      zipOs.flush();
      zipOs.closeEntry();
      zipOs.finish();
      this.compressedBytes=compressedBytesOutputStream.toByteArray();
      CoreLogger.log("finished compressing, archive size is "+this.compressedBytes.length+" bytes.", CoreLogger.LOG_NORMAL);
    } catch (java.io.IOException e) {
      CoreLogger.log("cannot write to archive: "+e.getClass().getName()+": "+e.getMessage(), CoreLogger.LOG_ERROR);
      throw e;
    }
  }


  public static void main(String[] args) {
    try {
      String strangeCharString = "'$";
      Message post = Message.parseString("<message type=\"post\" version=\"1.0\" originalUri=\"SSK@Y3mg8BkVZbh43ru0u4SVOHU866EPAgM/fmb/2002.03.19/0\" date=\"2002.03.19 13:37:34\" uniqueId=\"Y3mg8BkVZbh43ru0u4SVOHU866EPAgM10165450544120.37397355469723936\" source=\"SSK@Y3mg8BkVZbh43ru0u4SVOHU866EPAgM/fmb/2002.03.19/0\">\n\t<keywords></keywords>\n\t<replyTo></replyTo>\n\t<subject>$</subject>\n\t<text></text>\n</message>");
      Message[] msgs = new Message[1];
      msgs[0]=post;
      MessageArchive archive = new MessageArchive(msgs, "test archive");
      Message[] archivedMsgs = archive.getMessages();
      if (post.equals(archivedMsgs[0])==false) {

      }
      System.err.println(archivedMsgs[0].getString());

    } catch (Throwable t) {
      t.printStackTrace();
    }
  }

}