package freenetmessageboard.core;

/**
 * Title:
 * Description:
 * Copyright:    Copyright (c) 2002
 * Company:
 * @author
 * @version 1.0
 */

public class Message implements java.lang.Comparable {

  private String messageType;
  private String version = "1.0";
  private String originalUri = "n/a";
  private String date;
  private String uniqueId;
  private String sourceUri = "not succesfully inserted yet";

  protected final static int MSG_TYPE_USER = 0;
  protected final static int MSG_TYPE_USER_COMMENT = 1;
  protected final static int MSG_TYPE_POST = 2;
  protected final static int MSG_TYPE_POST_COMMENT = 3;
  protected final static int MSG_TYPE_ARCHIVE = 4;
  protected final static int MSG_TYPE_CHESS = 5;

  private int retrievedCounter;
  private int sentCounter;


  protected static String[] MSG_TYPE_TAGS = { "user", "userComment", "post", "postComment", "archive", "chess" };

  private  static int nextId=0;

  public static java.text.DateFormat messageDateFormat;

  private java.util.Map fields;

  private static java.util.Comparator dateComparator;
  private static java.util.Comparator reverseDateComparator;
  private static java.util.Comparator usefullForBroadcoastingComparator;

  static {
    Message.messageDateFormat=new java.text.SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
    Message.messageDateFormat.setTimeZone(java.util.TimeZone.getTimeZone("GMT"));
    Message.dateComparator = new java.util.Comparator() {
      public int compare(Object o1, Object o2) {
        Message m1 = (Message)o1;
        Message m2 = (Message)o2;
        return (m1.date.compareTo(m2.date));
      }
    };
    Message.reverseDateComparator=new java.util.Comparator() {
      public int compare(Object o1, Object o2) {
        Message m1 = (Message)o1;
        Message m2 = (Message)o2;
        return (-m1.date.compareTo(m2.date));
      }
    };
    Message.usefullForBroadcoastingComparator=new java.util.Comparator() {
      public int compare(Object o1, Object o2) {
        try {
          Message m1 = (Message)o1;
          Message m2 = (Message)o2;
          long time1 = Message.messageDateFormat.parse(m1.getDate()).getTime();
          long time2 = Message.messageDateFormat.parse(m2.getDate()).getTime();
          long oneHour=60*60*1000;
          long usefullNess1 = time1-(m1.getRetrievedCounter()*oneHour)-(m1.getSentCounter()*oneHour*3);
          long usefullNess2 = time2-(m2.getRetrievedCounter()*oneHour)-(m2.getSentCounter()*oneHour*3);
          if (usefullNess1>usefullNess2) {
            return -1;
          } else {
            return 1;
          }
        } catch (Exception ex) {
          CoreLogger.log("Exception while comparing messages: "+ex.getClass().getName()+": "+ex.getMessage(), CoreLogger.LOG_ERROR);
          ex.printStackTrace();
          return 0;
        }
      }
    };
  }

  void increaseRetrievedCounter() {
    this.retrievedCounter++;
  }

  void increaseSentCounter() {
    this.sentCounter++;
  }

  int getRetrievedCounter() {
    return this.retrievedCounter;
  }

  int getSentCounter() {
    return this.sentCounter;
  }

  protected Message(int messageType) {
    this.messageType=Message.MSG_TYPE_TAGS[messageType];
    this.date=Message.messageDateFormat.format(new java.util.Date());
    this.uniqueId=Message.generateUniqueID();
  }

  static String generateUniqueID() {
    String publicKey = PersonalInfo.instance().getPublicKey();
    long time = System.currentTimeMillis();
    return publicKey+time+Message.nextId++;
  }

  public int compareTo(java.lang.Object o) {
    Message otherMsg = (Message)o;
    return (-this.date.compareTo(otherMsg.date));
  }

  protected Message(String messageString) throws MessageFormatException{
   if (messageString.startsWith("<")==false) {
      throw new MessageFormatException("message doesn't start with <, no valid message");
    }
    try {
      String messageTag = messageString.substring(1, messageString.indexOf('>'));
      this.messageType=Message.getProperty(messageTag, "type");
      this.version=Message.getProperty(messageTag, "version");
      this.originalUri=Message.getProperty(messageTag, "originalUri");
      this.date=Message.getProperty(messageTag, "date");
      this.uniqueId=Message.getProperty(messageTag, "uniqueId");
      this.sourceUri=Message.getProperty(messageTag, "source");
      this.fields=Message.getFields(messageString, "message");
      if (Message.isUriFromKey(this.originalUri, this.uniqueId.substring(0, 31))==false) {
        throw new MessageFormatException("the original uri doesn't contain the same public key as the msg id");
      }
    } catch (MessageFormatException er) {
      throw er;
    } catch (Exception ex) {
      ex.printStackTrace();
      throw new MessageFormatException(ex.getMessage());
    }
  }

  static boolean isUriFromKey(String uri, String key) {
    return (uri.startsWith("SSK@"+key));
  }

  protected String getField(String fieldName) throws NoSuchFieldException {
    String value = (String)this.fields.get(fieldName);
    if (value==null) {
      throw new NoSuchFieldException(fieldName);
    }
    return value;
  }

  static private String filterStringForStrangeChars(String string) {
    try {
      StringBuffer buf = new StringBuffer(string.length());
      boolean isEOL=false;
      boolean received10=false;
      boolean received13=false;
      for (int i=0; i<string.length(); i++) {
        char c = string.charAt(i);
        if (c=='<') {
          buf.append(" lt ");
          continue;
        }
        if (c=='>') {
          buf.append(" gt ");
          continue;
        }
        if (c==13) {
          received13=true;
          received10=false;
          buf.append('\n');
          continue;
        }
        if (c==10) {
          if (received10==false) {
            if (received13) {
              received13=false;
              continue;
            } else {
              received10=true;
              buf.append('\n');
              continue;
            }
          }
        }
        received13=false;
        received10=false;
         buf.append(c);
      }
      return buf.toString();
    } catch (Throwable t) {
      CoreLogger.log("An exception occured "+t.getClass()+": "+t.getMessage()+":\n"+string+"\n", CoreLogger.LOG_ERROR);
      t.printStackTrace();
      return new String();
    }
  }

  protected void setField(String fieldName, String fieldValue) {
    if (this.fields==null) {
      this.fields=new java.util.HashMap();
    }
    this.fields.put(fieldName, Message.filterStringForStrangeChars(fieldValue));
  }

  public String getMessageType() {
    return this.messageType;
  }

  public String getOriginalUri() {
    return this.originalUri;
  }

  public String getSourceUri() {
    return this.sourceUri;
  }

  public String getSourceKey() {
    String sourceUri = this.getSourceUri();
    if (sourceUri.startsWith("KSK@")) return sourceUri;
    if (sourceUri.startsWith("SSK@")==false) return sourceUri;
    return sourceUri.substring(4,35);
  }

  public String getOriginalPublicKey() {
    CoreLogger.log("parsing "+this.uniqueId+" for the public key... ", CoreLogger.LOG_INFO);
    String publicKey = this.uniqueId.substring(0, 31);
    CoreLogger.log("the public key of the message is "+publicKey, CoreLogger.LOG_INFO);
    return publicKey;
  }

  static java.util.Comparator getReverseDateComparator() {
    return Message.reverseDateComparator;
  }

  static java.util.Comparator getDateComparator() {
    return Message.dateComparator;
  }

  static java.util.Comparator getUsefulorBroadcoastingComparator() {
    return Message.usefullForBroadcoastingComparator;
  }

  public void setOriginalUri(String uri) {
    this.originalUri=uri;
  }

  public java.util.Map getFields() {
    return this.fields;
  }

  public String getDate() {
    return this.date;
  }

  public String getUniqueId() {
    return this.uniqueId;
  }

  public String getVersion() {
    return this.version;
  }

  public boolean isFromCurrentDay() {
    try {
      String msgDateString = MessageGateway.instance().uriDateFormat.format(Message.messageDateFormat.parse(this.date));
      String requestString = MessageGateway.uriDateFormat.format(MessageGateway.getCurrentDate());
      return (msgDateString.equals(requestString));
    } catch (Exception ex) {
      CoreLogger.log("Error while comparing the date of the message "+this.getUniqueId()+" to the current requesting day", CoreLogger.LOG_ERROR);
      return false;
    }
  }

  public static String getStringFromBytes(byte[] bytes) {
    return new String(bytes);
  /*  try {
      String newString = new String(bytes, "UTF-8");
   //   System.err.println(newString);
      return newString;
    } catch (java.io.IOException ex) {
      CoreLogger.log("exception while converting bytes to string: "+ex.getClass().getName()+": "+ex.getMessage(), CoreLogger.LOG_ERROR);
      return new String();
    }*/
  }

  public static byte[] getBytesFromString(String string) {

    return string.getBytes();

  /*  try {
      return string.getBytes("UTF-8");
    } catch (java.io.IOException ex) {
      CoreLogger.log("exception while converting string to bytes: "+ex.getClass().getName()+": "+ex.getMessage(), CoreLogger.LOG_ERROR);
      ex.printStackTrace();
      return new byte[0];
    }*/
  }

  public String getString() {
    StringBuffer buf = new StringBuffer(400);
    try {
      buf.append(this.constructMessageTag());
      buf.append("\n");
      buf.append(this.constructFieldTags(this.fields));
      buf.append("</message>");
      return buf.toString();
    } catch (Exception e) {
      CoreLogger.log("exception while generating message string: "+e.getClass().getName()+": "+e.getMessage(), CoreLogger.LOG_ERROR);
      e.printStackTrace();
      return new String();
    }
  }

  public boolean equals(Object o) {
    try {
      Message otherMsg = (Message)o;
      if (this.headerEquals(otherMsg)==false) {
        return false;
      }
      return this.contentEquals(otherMsg);
    } catch (Exception ex) {
      return false;
    }
  }

  boolean contentEquals(Message otherMsg) {
    return this.fields.equals(otherMsg.fields);
  }

  boolean headerEquals(Message otherMsg) {
    if (this.messageType.equals(otherMsg.messageType)==false) return false;
    if (this.originalUri.equals(otherMsg.originalUri)==false) return false;
    if (this.uniqueId.equals(otherMsg.uniqueId)==false) return false;
    if (this.date.equals(otherMsg.date)==false) return false;
    return true;
  }

  public static Message[] parseMultipleMessageString(String multipleMessageString) {
    CoreLogger.log("parsing multiple message string of "+multipleMessageString.length()+" bytes length" , CoreLogger.LOG_INFO);
    try {
      StringBuffer buf = new StringBuffer(multipleMessageString);
      int beginTagIndex=0;
      int endTagIndex=0;
      java.util.List messagesList = new java.util.ArrayList();

      while (true) {
        beginTagIndex=multipleMessageString.indexOf("<message", endTagIndex);
        if (beginTagIndex==-1) {
          break;
        }
        endTagIndex=multipleMessageString.indexOf("</message>", beginTagIndex)+"</message".length()+1;
        try {
          String messageString = multipleMessageString.substring(beginTagIndex, endTagIndex);
          Message message = Message.parseString(messageString);
          messagesList.add(message);
        } catch (MessageFormatException ex) {
          CoreLogger.log("message format error while parsing a message: "+ex.getMessage(), CoreLogger.LOG_ERROR);
          throw ex;
        } catch (Throwable t) {
          CoreLogger.log("exception while parsing a message: "+t.getClass().getName()+": "+t.getMessage(), CoreLogger.LOG_ERROR);
          throw t;
        }
      }
      CoreLogger.log("found "+messagesList.size()+" messages in the multiple message string", CoreLogger.LOG_INFO);
      return (Message[])messagesList.toArray(new Message[messagesList.size()])   ;
    } catch (Throwable t) {
      CoreLogger.log("exception while parsing a multiple message-string: "+t.getClass().getName()+": "+t.getMessage(), CoreLogger.LOG_ERROR);
      return new Message[0];
    }
  }

  public static Message parseString(String messageString) throws MessageFormatException {
    try {

      if (messageString.startsWith("<")==false) {
        throw new MessageFormatException("message doesn't start with <, no valid message");
      }

      String messageTag = messageString.substring(1, messageString.indexOf('>'));
      try {
        String messageType=Message.getProperty(messageTag, "type");
        Message message;
        if (messageType.equals(Message.MSG_TYPE_TAGS[Message.MSG_TYPE_USER])) {
          return new UserMessage(messageString);
        }
        if (messageType.equals(Message.MSG_TYPE_TAGS[Message.MSG_TYPE_USER_COMMENT])) {
          return new UserCommentMessage(messageString);
        }
        if (messageType.equals(Message.MSG_TYPE_TAGS[Message.MSG_TYPE_POST])) {
          return new PostMessage(messageString);
        }
        if (messageType.equals(Message.MSG_TYPE_TAGS[Message.MSG_TYPE_POST_COMMENT])) {
          return new PostCommentMessage(messageString);
        }
        if (messageType.equals(Message.MSG_TYPE_TAGS[Message.MSG_TYPE_ARCHIVE])) {
          return new ArchiveMessage(messageString);
        }
        if (messageType.equals(Message.MSG_TYPE_TAGS[Message.MSG_TYPE_CHESS])) {
          return new ChessMessage(messageString);
        }
        return new Message(messageString);
      } catch (Throwable t) {
        CoreLogger.log("There was an exception while parsing the message with the following header:\n"+messageTag, CoreLogger.LOG_ERROR);
        CoreLogger.log("printing stack trace: ", CoreLogger.LOG_ERROR);
        t.printStackTrace();
        throw new MessageFormatException(t.getMessage());
      }
    } catch (MessageFormatException er) {
      throw er;
    } catch (Throwable t) {
      CoreLogger.log("Unexpected exception while parsing message: "+t.getClass()+": "+t.getMessage(), CoreLogger.LOG_ERROR);
      t.printStackTrace();
      throw new MessageFormatException(t.getMessage());
    }
  }

  static java.util.Map getFields(String messageString, String messageType) throws MessageFormatException{
    try {
      String messageContent=Message.getContentOfTag(messageString, messageType);
      java.io.StringReader stringReader = new java.io.StringReader(messageContent);
      java.util.Map map = new java.util.HashMap();
      boolean finishedParsingTagContent=false;
      int openTagBeginIndex=-1;
      int openTagEndIndex=-1;
      int closeTagBeginIndex=-1;
      int closeTagEndIndex=-1;
      int currentIndex=-1;
      while (finishedParsingTagContent==false) {
        currentIndex++;
        int i = stringReader.read();
        if (i==-1) break;
        char c = (char)i;
        if (openTagBeginIndex==-1 && c=='<') {
          openTagBeginIndex=currentIndex;
          continue;
        }
        if (openTagEndIndex==-1 && c=='>') {
          openTagEndIndex=currentIndex;
          continue;
        }
        if (closeTagBeginIndex==-1 && c=='<') {
          closeTagBeginIndex=currentIndex;
          continue;
        }
        if (closeTagEndIndex==-1 && c=='>') {
          closeTagEndIndex=currentIndex;
          String propertyName = messageContent.substring(openTagBeginIndex+1, openTagEndIndex);
          String propertyValue = Message.filterStringForStrangeChars(messageContent.substring(openTagEndIndex+1, closeTagBeginIndex));
          map.put(propertyName, propertyValue);
          openTagBeginIndex=-1;
          openTagEndIndex=-1;
          closeTagBeginIndex=-1;
          closeTagEndIndex=-1;
          continue;
        }
      }
      return map;
    }
    catch (MessageFormatException e) {
      throw e;
    }
    catch (Exception ex) {
      ex.printStackTrace();
      throw new MessageFormatException(ex.getClass().getName()+": "+ex.getMessage());
    }
  }

  private static String getContentOfTag(String contentString, String tagName) throws MessageFormatException {
    try {
      int tagStartIndex = contentString.indexOf("<"+tagName);
      int contentStartIndex = contentString.indexOf('>', tagStartIndex)+1;
      int contentEndIndex = contentString.indexOf("</"+tagName+">", contentStartIndex);
      String content = contentString.substring(contentStartIndex, contentEndIndex).trim();
      return content;
    } catch (Exception ex) {
      ex.printStackTrace();
      throw new MessageFormatException(ex.getClass().getName()+": "+ex.getMessage());
    }
  }

  public void setSource(String newSource) {
    this.sourceUri=newSource;
  }

  private String constructMessageTag() {
    StringBuffer buf = new StringBuffer(150);
    buf.append("<message type=\"");
    buf.append(this.messageType);
    buf.append("\" ");
    buf.append("version=\"");
    buf.append(this.version);
    buf.append("\" originalUri=\"");
    buf.append(this.originalUri);
    buf.append("\" date=\"");
    buf.append(this.date);
    buf.append("\" uniqueId=\"");
    buf.append(this.uniqueId);
    buf.append("\" source=\"");
    buf.append(this.sourceUri);
    buf.append("\">");
    return buf.toString();
  }

  static String constructFieldTags(java.util.Map fieldsMap) {
    StringBuffer buf = new StringBuffer(200);
    java.util.List list = new java.util.ArrayList(fieldsMap.keySet());
    java.util.Collections.sort(list);
    java.util.Iterator it = list.iterator();
    while(it.hasNext()) {
      String fieldName = (String)(it.next());
      String fieldValue = (String)fieldsMap.get(fieldName);
      buf.append("\t<");
      buf.append(fieldName);
      buf.append('>');
      buf.append(fieldValue);
      buf.append("</");
      buf.append(fieldName);
      buf.append(">\n");
    }
    return buf.toString();
  }

  private static String getProperty(String messageTag, String propertyName) throws MessageFormatException {
    try {
      int beginIndex = messageTag.indexOf(propertyName+"=");
      int beginValueIndex = messageTag.indexOf('"', beginIndex)+1;
      int endValueIndex = messageTag.indexOf('"', beginValueIndex);
      String value = messageTag.substring(beginValueIndex, endValueIndex);
      return value;
    } catch (Exception ex) {
      ex.printStackTrace();
      throw new MessageFormatException(ex.getMessage());
    }
  }

  public static void main(String[] args) {
    PersonalInfo.instance();
  }

  public String toShortString() {
    return this.getClass().getName().substring(this.getClass().getName().lastIndexOf('.')+1);
  }

  private static String readStringFromFile(String fileName) {
    try {
      java.io.FileReader fileReader = new java.io.FileReader(fileName);
      StringBuffer buf = new StringBuffer(400);
      while(true) {
        char[] charBuffer = new char[100];
        int charsRead = fileReader.read(charBuffer);
        if (charsRead==-1) break;
        buf.append(charBuffer,0, charsRead);
      }
      return buf.toString();
    } catch (java.lang.Exception ex) {
      System.err.println(fileName+": failed to read: "+ex.getMessage());
      return new String();
    }
  }
}

class NoSuchFieldException extends java.lang.Exception {

  private String fieldName;

  NoSuchFieldException(String field) {
    this.fieldName=field;
  }

  public String getMessage() {
    return "The message doesn't contain the field "+fieldName;
  }
}

class MessageFormatException extends java.lang.Exception {

  private String reason;

  MessageFormatException(String reason) {
    this.reason=reason;
  }

  public String getMessage() {
    return this.reason;
  }
}