package freenetmessageboard.core;

/**
 * Title:
 * Description:
 * Copyright:    Copyright (c) 2002
 * Company:
 * @author
 * @version 1.0
 */

public class HTLTest implements freenetmessageboard.fcpinterface.FCPInsertCallback, freenetmessageboard.fcpinterface.FCPRequestCallback{

  int numberOfInserts=10;

  private int htl=15;

  private String[] uris = new String[this.numberOfInserts];
  private boolean[] succesfull = new boolean[this.numberOfInserts];

  private int successCount = 0;
  private int routeNotFounds = 0;
  private int keyCollisions = 0;
  private int dataNotFound = 0;
  private int failedBadly = 0;

  public HTLTest(boolean insertMode, String baseName, int htl) {
    this.htl=htl;
    synchronized (this) {

      for (int i=0; i<numberOfInserts; i++) {
        this.uris[i]=baseName+i;
        if (insertMode) {
          freenetmessageboard.fcpinterface.FCPFacade.instance().startFreenetInsert(this, this.uris[i], new byte[100], new byte[100], htl, false);
        } else {
          freenetmessageboard.fcpinterface.FCPFacade.instance().startFreenetRequest(this, this.uris[i], htl, false);
        }
      }
    }
  }

  public synchronized void insertSuccesfull(String uri, freenetmessageboard.fcpinterface.InsertInfo insertInfo) {
    System.err.println("the insert of "+uri+" was succesfull.");
    for (int i=0; i<numberOfInserts; i++) {
       if (this.uris[i].equals(uri)) {
        this.succesfull[i]=true;
        this.successCount++;
      }
    }
    this.printInsertStats();
  }

  private synchronized void printInsertStats() {
    int running = numberOfInserts-this.successCount-this.keyCollisions-this.failedBadly;
    System.err.println(running+" inserts active, "+this.successCount+" succesfull, "+this.routeNotFounds+" routenotfounds, "+this.keyCollisions+" key collisions, "+this.failedBadly+" failed badly");
    if (running==0) {
      System.exit(0);
    }
  }

  private synchronized void printRequestStats() {
    int running = numberOfInserts-this.successCount-this.dataNotFound-this.failedBadly;
    System.err.println(running+" requests active, "+this.successCount+" succesfull, "+this.routeNotFounds+" routenotfounds, "+this.dataNotFound+" data not found, "+this.failedBadly+" failed badly");
    if (running==0) {
      System.exit(0);
    }
  }

  public synchronized void requestSuccesfull(String uri, freenetmessageboard.fcpinterface.RequestedData data) {
    System.err.println("the request for "+uri+" was succesfull.");
    for (int i=0; i<numberOfInserts; i++) {
      if (this.uris[i].equals(uri)) {
        this.succesfull[i]=true;
        this.successCount++;
      }
    }
    this.printRequestStats();
  }

  public synchronized void requestFailedWithRouteNotFound(String uri) {
    System.err.println("the request for "+uri+" failed with RouteNotFound.");
    freenetmessageboard.fcpinterface.FCPFacade.instance().startFreenetRequest(this, uri, this.htl, false);
    this.routeNotFounds++;
    this.printRequestStats();
  }

  public synchronized void requestFailedWithDataNotFound(String uri) {
    System.err.println("the request for "+uri+" failed with DataNotFound.");
    this.dataNotFound++;
    this.printRequestStats();
  }
  public synchronized void requestFailedBadly(String uri, String info) {
    System.err.println("the request for "+uri+" failed badly");
    this.failedBadly++;
    this.printRequestStats();
  }

  public synchronized void requestStarted(String uri) {

  }


  public synchronized void insertFailedWithRouteNotFound(String uri) {
    System.err.println("the insert of "+uri+" failed with route not found, restarting...");
    freenetmessageboard.fcpinterface.FCPFacade.instance().startFreenetInsert(this, uri, new byte[100], new byte[100], htl ,false);
    this.routeNotFounds++;
    this.printInsertStats();
  }
  public synchronized void insertFailedWithKeyCollision(String uri) {
    System.err.println("the insert of "+uri+" failed with key collision.");
    this.keyCollisions++;
    this.printInsertStats();
  }
  public synchronized void insertFailedBadly(String uri, String info) {
    System.err.println("the insert of "+uri+" failed way bad.");
    this.failedBadly++;
    this.printInsertStats();
  }

  public static void main(String[] args) {
    if (args.length!=3) {
      System.err.println("usage: HTLTest put|get KSK@yourkey/ htl");
      System.exit(-1);
    }
    if (args[0].equals("put")) {
      new HTLTest(true, args[1], Integer.parseInt(args[2]));
    } else {
      new HTLTest(false, args[1], Integer.parseInt(args[2]));
    }

  }
}