package freenetmessageboard.core;

/**
 * Title:
 * Description:
 * Copyright:    Copyright (c) 2002
 * Company:
 * @author
 * @version 1.0
 */

public class FreenetNetworkSettings {

  int regularRequestHTL;
  int regularRequestHTLIncrease;
  int regularInsertHTL;
  int regularRequestRetries;

  int channelRequestHTL;
  int channelRequestHTLIncrease;

  int archiveInsertHtl;
  int archiveRequestHtl;

  private static FreenetNetworkSettings localDebuggingSettings;
  private static FreenetNetworkSettings regularSettings;
  private static FreenetNetworkSettings smallSettings;

  private FreenetNetworkSettings() {
  }

  static {
    FreenetNetworkSettings.localDebuggingSettings=new FreenetNetworkSettings();
    FreenetNetworkSettings.localDebuggingSettings.regularRequestHTL=0;
    FreenetNetworkSettings.localDebuggingSettings.regularRequestHTLIncrease=1;
    FreenetNetworkSettings.localDebuggingSettings.regularInsertHTL=2;
    FreenetNetworkSettings.localDebuggingSettings.regularRequestRetries=3;
    FreenetNetworkSettings.localDebuggingSettings.channelRequestHTL=0;
    FreenetNetworkSettings.localDebuggingSettings.channelRequestHTLIncrease=0;
    FreenetNetworkSettings.localDebuggingSettings.archiveInsertHtl=2;
    FreenetNetworkSettings.localDebuggingSettings.archiveRequestHtl=2;

    FreenetNetworkSettings.smallSettings=new FreenetNetworkSettings();
    FreenetNetworkSettings.smallSettings.regularRequestHTL=4;
    FreenetNetworkSettings.smallSettings.regularRequestHTLIncrease=3;
    FreenetNetworkSettings.smallSettings.regularInsertHTL=20;
    FreenetNetworkSettings.smallSettings.regularRequestRetries=5;
    FreenetNetworkSettings.smallSettings.channelRequestHTL=5;
    FreenetNetworkSettings.smallSettings.channelRequestHTLIncrease=5;
    FreenetNetworkSettings.smallSettings.archiveInsertHtl=20;
    FreenetNetworkSettings.smallSettings.archiveRequestHtl=40;

    FreenetNetworkSettings.regularSettings=new FreenetNetworkSettings();
    FreenetNetworkSettings.regularSettings.regularRequestHTL=10;
    FreenetNetworkSettings.regularSettings.regularRequestHTLIncrease=10;
    FreenetNetworkSettings.regularSettings.regularInsertHTL=20;
    FreenetNetworkSettings.regularSettings.regularRequestRetries=4;
    FreenetNetworkSettings.regularSettings.channelRequestHTL=10;
    FreenetNetworkSettings.regularSettings.channelRequestHTLIncrease=10;
    FreenetNetworkSettings.regularSettings.archiveInsertHtl=20;
    FreenetNetworkSettings.regularSettings.archiveRequestHtl=50;
  }

  public static synchronized FreenetNetworkSettings instance() {
    return FreenetNetworkSettings.smallSettings;
  }
}