package freenetmessageboard.core;

/**
 * Title:
 * Description:
 * Copyright:    Copyright (c) 2002
 * Company:
 * @author
 * @version 1.0
 */

public class ForwardDemon extends Thread implements MessageArrivedListener {

  private java.util.HashSet requestedChannels = new java.util.HashSet();

  private java.util.List newMessagesList = new java.util.LinkedList();

  private java.util.HashMap forwardedMessages = new java.util.HashMap();

  public ForwardDemon() {
    MessagePool.instance().addMessageArrivedListener(this, MessageFilter.getAcceptAllMessageFilter());
  }

  public void messageArrived(Message msg) {
    CoreLogger.log("received "+msg.toShortString()+" from "+msg.getSourceUri(), CoreLogger.LOG_WARNING);
    if (msg.getSourceKey().equals(PersonalInfo.instance().getPublicKey())) return;
    synchronized(this.newMessagesList) {
      this.newMessagesList.add(msg);
    }
  }

  private void processNewMessages() {
    synchronized(this.newMessagesList) {
      java.util.Iterator it = this.newMessagesList.iterator();
      while(it.hasNext()) {
        Message msg = (Message)it.next();
        it.remove();
        if (this.requestedChannels.contains(msg.getOriginalPublicKey())==false) {
          try {
            java.util.Date msgDate = Message.messageDateFormat.parse(msg.getDate());
            if (MessageGateway.uriDateFormat.format(msgDate).equals(MessageGateway.uriDateFormat.format(MessageGateway.getCurrentDate()))) {
              CoreLogger.log("received first recent message from user "+msg.getOriginalPublicKey()+", start requesting channel...", CoreLogger.LOG_WARNING);
              MessageGateway.instance().startListeningOnPersonalChannel(msg.getOriginalPublicKey());
              this.requestedChannels.add(msg.getOriginalPublicKey());
            }
          } catch (Exception ex) {
            CoreLogger.log("failed to parse the date from message "+msg.toShortString(), CoreLogger.LOG_ERROR);
          }
        }
        if (this.forwardedMessages.containsKey(msg.getUniqueId())==false) {
          this.forwardedMessages.put(msg.getUniqueId(), msg);
          CoreLogger.log("fowarding "+msg.toShortString()+" from "+msg.getOriginalPublicKey()+"...", CoreLogger.LOG_WARNING);
          MessageGateway.instance().sendMessageOnPersonalChannel(msg);
        } else {
          Message existingMsg = (Message)this.forwardedMessages.get(msg.getUniqueId());
          if (existingMsg.equals(msg)==false) {
            if (msg.getOriginalPublicKey().equals(msg.getSourceKey())) {
              CoreLogger.log("fowarding "+msg.toShortString()+" from "+msg.getOriginalPublicKey()+"...", CoreLogger.LOG_WARNING);
              MessageGateway.instance().sendMessageOnPersonalChannel(msg);
            }
          }
        }
      }
    }
  }

  public void run() {
    Message[] messages = MessagePool.instance().getUsefulMessages();
    for (int i=0; i<messages.length; i++) {
      CoreLogger.log("fowarding "+messages[i].toShortString()+" from local message pool, because I think it is useful...", CoreLogger.LOG_WARNING);
      MessageGateway.instance().sendMessageOnPersonalChannel(messages[i]);
    }
    MessageGateway.instance().startListeningOnPublicAnnouncementChannel();
    int minuteCount=0;
    while(true) {
      this.processNewMessages();

      if (minuteCount%5==0 || CoreLogger.logLevel>=CoreLogger.LOG_NORMAL) {
        CoreLogger.log("the forward demon is listening to "+this.requestedChannels.size()+" channels, has "+MessageGateway.instance().getActiveInsertCount()+" active inserts and "+MessageGateway.instance().getSendBufferSize()+" bytes buffered, next slot is "+MessageGateway.instance().getSlotInfoStringForMyPersonalChannel().length(), CoreLogger.LOG_WARNING);
      }
      minuteCount++;
      try {
        Thread.sleep(60000);
      }
      catch (InterruptedException ex) {
      }
      minuteCount++;

    }
  }

  class ForwardInfo {
    int sentCount;
    int receivedCount;
  }
}