package freenetmessageboard.core;

/**
 * Title:
 * Description:
 * Copyright:    Copyright (c) 2002
 * Company:
 * @author
 * @version 1.0
 */

public class ContactList implements MessageArrivedListener {

  private static ContactList instance;

  private java.util.Map contactInformations = new java.util.HashMap();

  private ContactList() {
    MessagePool.instance().addMessageArrivedListener(this, MessageFilter.getUserMessagesAndCommentsOnlyFilter());
  }

  public static synchronized ContactList instance() {
    if (ContactList.instance==null) {
      ContactList.instance=new ContactList();
    }
    return ContactList.instance;
  }

  private void userMessageArrived(final UserMessage newUser) {
    CoreLogger.log("the contact list received an announcement from "+newUser.getNickName(), CoreLogger.LOG_NORMAL);
    if (newUser.isFromCurrentDay() && FMBSettings.instance().autoListen) {
      if (MessageGateway.instance().isListeningOnPersonalChannel(newUser.getPublicKey())==false) {
        Thread helperThread = new Thread("auto listener thread") {
          public void run() {
            CoreLogger.log("automatic listening for "+newUser.getNickName()+"'s channel is starting...", CoreLogger.LOG_WARNING);
            MessageGateway.instance().startListeningOnPersonalChannel(newUser.getPublicKey());
          }
        };
        helperThread.start();
      }
    }
    String sourceKey = newUser.getSourceKey();
    if (sourceKey.equals(newUser.getPublicKey())) {
      CoreLogger.log("this announcement is an original version because was received from "+sourceKey, CoreLogger.LOG_NORMAL);
    } else {
      CoreLogger.log("this announcement is only a copy from "+sourceKey, CoreLogger.LOG_NORMAL);
    }
    if (this.contactInformations.containsKey(newUser.getPublicKey())) {
      ContactInformation contactInfo = (ContactInformation)this.contactInformations.get(newUser.getPublicKey());
      contactInfo.addUserMessage(newUser);
      freenetmessageboard.Main.getGUI().updateContactPanel(newUser.getPublicKey());
    } else {
      ContactInformation contactInfo = new ContactInformation(newUser);
      if (newUser.getPublicKey().equals(PersonalInfo.instance().getPublicKey())==false) {
  //      MessageGateway.instance().listenOnPersonalChannel(newUser.getPublicKey());
      }
      this.contactInformations.put(newUser.getPublicKey(), contactInfo);
      freenetmessageboard.Main.getGUI().addContactPanel(contactInfo);
    }
  }

  public UserMessage getLatestUserMessageFromPublicKey(String publicKey) throws MessageNotReceivedException{
    ContactInformation info = (ContactInformation)this.contactInformations.get(publicKey);
    if (info==null) {
      CoreLogger.log("requested a user message from an unknown user: "+publicKey, CoreLogger.LOG_ERROR);
      throw new MessageNotReceivedException();
    }
    return info.getLastUserMessage();
  }

  public UserMessage[] getUserMessagesToBeAnnounced() {
    java.util.List userMsgs = new java.util.LinkedList();

    synchronized(this.contactInformations) {
      java.util.Iterator it = this.contactInformations.values().iterator();
      while (it.hasNext()) {
        ContactInformation info = (ContactInformation)it.next();
        if (info.getPublicKey().equals(PersonalInfo.instance().getPublicKey())) {
          continue;
        }
        userMsgs.add(info.getLastUserMessage());
      }
      java.util.Collections.sort(userMsgs, Message.getReverseDateComparator());
      if (userMsgs.size()>9) {
        for (int i=userMsgs.size()-1; i>8; i--) {
          userMsgs.remove(i);
        }
      }
      userMsgs.add(PersonalInfo.instance().createUserMessage());
    }
    return (UserMessage[])userMsgs.toArray(new UserMessage[userMsgs.size()]);
  }

  private void userCommentMessageArrived(UserCommentMessage newUserComment) {
    CoreLogger.log("the contact list received a comment on "+newUserComment.getUserPublicKey(), CoreLogger.LOG_NORMAL);
    String sourceKey = newUserComment.getSourceKey();
    if (newUserComment.getUserPublicKey().equals(newUserComment.getOriginalPublicKey())) {
      return;
    }
    if (sourceKey.equals(newUserComment.getOriginalPublicKey())) {
      CoreLogger.log("this user comment is an original version because it was received from "+sourceKey, CoreLogger.LOG_NORMAL);
    } else {
      CoreLogger.log("this user comment is only a copy from "+sourceKey, CoreLogger.LOG_NORMAL);
    }
    if (this.contactInformations.containsKey(newUserComment.getUserPublicKey())) {
      ContactInformation contactInfo = (ContactInformation)this.contactInformations.get(newUserComment.getUserPublicKey());
      contactInfo.addUserCommentMessage(newUserComment);
    } else {
    }
  }

  public ContactInformation getContactInformationOfPublicKey(String publicKey) throws NoSuchContactException {
    ContactInformation contactInfo = (ContactInformation)this.contactInformations.get(publicKey);
    if (contactInfo==null) throw new NoSuchContactException();
    return contactInfo;
  }

  public String getNicknameOfPublicKey(String publicKey) {
    ContactInformation contactInfo = (ContactInformation)this.contactInformations.get(publicKey);
    if (contactInfo==null) {
      if (publicKey.startsWith("KSK@")) {
        return "anyone";
      }
      if (publicKey.equals("not succesfully inserted yet")) {
        return "memory";
      }
      return "unknown user";
    }
    return contactInfo.getNickname();
  }

  public void messageArrived(Message msg) {
    if (msg instanceof UserMessage) {
      this.userMessageArrived((UserMessage)msg);
    }
    if (msg instanceof UserCommentMessage) {
      this.userCommentMessageArrived((UserCommentMessage)msg);
    }

  }

  public static void main(String[] args) {
    ContactList.instance();
  }
}