package freenetmessageboard.core;

/**
 * Title:
 * Description:
 * Copyright:    Copyright (c) 2002
 * Company:
 * @author
 * @version 1.0
 */

public class ContactInformation {

  private java.util.List userMessages = new java.util.LinkedList();

  private java.util.Map userCommentMessages = new java.util.HashMap();

  private int goodRatings=0;
  private int neutralRatings=0;
  private int evilRatings=0;

  private static int maxRatings=0;

  private long timeOfLastActivity;

  public ContactInformation(UserMessage userMessage) {
    this.addUserMessage(userMessage);
    this.setTimeOfLastActivity(userMessage.getDate());
  }

  public long getTimeOfLastActivity() {
    return this.timeOfLastActivity;
  }

  public int[] getRatings() {
    int noRatingCount = ContactInformation.maxRatings-(this.goodRatings+this.neutralRatings+this.evilRatings);
    return new int[] { this.goodRatings, this.neutralRatings, this.evilRatings, noRatingCount };
  }

  public int getRatingScore() {
    return this.goodRatings*3+this.neutralRatings*2+this.evilRatings;
  }

  void setTimeOfLastActivity(String dateString) {
    try {
      long newTime= Message.messageDateFormat.parse(dateString).getTime();
      if (newTime>this.timeOfLastActivity) {
        this.timeOfLastActivity=newTime;
        freenetmessageboard.Main.getGUI().updateContactPanel(this.getPublicKey());
      }
    } catch (java.text.ParseException ex) {
      CoreLogger.log("couldn't parse the date from "+dateString, CoreLogger.LOG_ERROR);
    }
  }

  void addUserMessage(UserMessage msg) {
    synchronized(this.userMessages) {
      if (this.userMessages.contains(msg)==false) {
        userMessages.add(msg);
        java.util.Collections.sort(this.userMessages, Message.getReverseDateComparator());
        this.setTimeOfLastActivity(msg.getDate());
      } else {
        UserMessage existingMsg = (UserMessage)this.userMessages.get(this.userMessages.indexOf(msg));
        if (msg.getSourceUri().equals(msg.getOriginalUri()) || (existingMsg.getSourceUri().indexOf("SK@")==-1)) {
          this.userMessages.remove(existingMsg);
          this.userMessages.add(msg);
          java.util.Collections.sort(this.userMessages, Message.getReverseDateComparator());
          this.setTimeOfLastActivity(msg.getDate());
        }
      }
    }
  }

  void increaseRatingCounter(String rating) {
    if (rating.equals("GOOD")) {
      this.goodRatings++;
    }
    if (rating.equals("NEUTRAL")) {
      this.neutralRatings++;
    }
    if (rating.equals("EVIL")) {
      this.evilRatings++;
    }
    if (this.goodRatings+this.neutralRatings+this.evilRatings>ContactInformation.maxRatings) {
      ContactInformation.maxRatings=this.goodRatings+this.neutralRatings+this.evilRatings;
    }
  }

  void decreaseRatingCounter(String rating) {
    if (rating.equals("GOOD")) {
      this.goodRatings--;
    }
    if (rating.equals("NEUTRAL")) {
      this.neutralRatings--;
    }
    if (rating.equals("EVIL")) {
      this.evilRatings--;
    }
  }

  void addUserCommentMessage(UserCommentMessage msg) {
    if (this.userCommentMessages.containsKey(msg.getOriginalPublicKey())==false) {
      this.userCommentMessages.put(msg.getOriginalPublicKey(), msg);
      this.increaseRatingCounter(msg.getRating());
    } else {
      UserCommentMessage existingMsg = (UserCommentMessage)this.userCommentMessages.get(msg.getOriginalPublicKey());
      if (msg.compareTo(existingMsg)<0 || msg.getSourceUri().equals(msg.getOriginalUri())) {
        this.decreaseRatingCounter(existingMsg.getRating());
        this.userCommentMessages.put(msg.getOriginalPublicKey(), msg);
        this.increaseRatingCounter(msg.getRating());
      }
    }
  }

  public String getName() {
    return this.getLastUserMessage().getName();
  }

  public String getInterests() {
    return this.getLastUserMessage().getInterests();
  }

  public String getFreesiteUri() {
    return this.getLastUserMessage().getFreesiteUri();
  }

  public String getNickname() {
    return this.getLastUserMessage().getNickName();
  }

  public String getPublicKey() {
    return this.getLastUserMessage().getPublicKey();
  }

  public UserCommentMessage[] getUserCommentMessages() {
    return (UserCommentMessage[])this.userCommentMessages.values().toArray(new UserCommentMessage[this.userCommentMessages.size()]);
  }

  public UserMessage[] getUserMessages() {
    return (UserMessage[])this.userMessages.toArray(new UserMessage[this.userMessages.size()]);
  }

  public UserMessage getLastUserMessage() {
    return (UserMessage)this.userMessages.get(0);
  }

}