package freenetmessageboard.core;

import freenetmessageboard.schach.SchachSpiel;

/**
 * Title:
 * Description:
 * Copyright:    Copyright (c) 2002
 * Company:
 * @author
 * @version 1.0
 */

public class ChessMessage extends Message {

  private String whitePublicKey=new String();
  private String blackPublicKey=new String();
  private String movesString=new String();
  private String whiteMessage=new String();
  private String blackMessage=new String();
  private String gameID=new String();
  private String beginningDate=new String();
  private String moveCount=new String("0");

  public ChessMessage(freenetmessageboard.schach.SchachSpiel spiel) {
    super(Message.MSG_TYPE_CHESS);
    this.whitePublicKey=spiel.getWhitePublicKey();
    this.blackPublicKey=spiel.getBlackPublicKey();
    this.movesString=spiel.getMovesString();
    this.gameID=spiel.getGameId();
    this.beginningDate=spiel.getBeginningDate();
    this.whiteMessage=spiel.getWhiteMessage();
    this.blackMessage=spiel.getBlackMessage();
    this.moveCount=Integer.toString(spiel.getMoveCount());
    super.setField("white", this.whitePublicKey);
    super.setField("black", this.blackPublicKey);
    super.setField("moves", this.movesString);
    super.setField("moveCount", this.moveCount);
    super.setField("whiteMessage", this.whiteMessage);
    super.setField("blackMessage", this.blackMessage);
    super.setField("gameId", this.gameID);
    super.setField("beginning", this.beginningDate);
  }

  public ChessMessage() {
    super(Message.MSG_TYPE_CHESS);
    this.blackPublicKey=PersonalInfo.instance().getPublicKey();
     super.setField("white", this.whitePublicKey);
    super.setField("black", this.blackPublicKey);
    super.setField("moves", this.movesString);
    super.setField("moveCount", this.moveCount);
    super.setField("whiteMessage", this.whiteMessage);
    super.setField("blackMessage", this.blackMessage);
    super.setField("gameId", this.gameID);
    super.setField("beginning", this.beginningDate);
  }

  public ChessMessage(String messageString) throws MessageFormatException{

    super(messageString);
    try {
      this.whitePublicKey=super.getField("white");
      this.blackPublicKey=super.getField("black");
      this.movesString=super.getField("moves");
      this.whiteMessage=super.getField("whiteMessage");
      this.blackMessage=super.getField("blackMessage");
      this.gameID=super.getField("gameId");
      this.beginningDate=super.getField("beginning");
      this.moveCount=super.getField("moveCount");
    } catch (NoSuchFieldException ex) {
      throw new MessageFormatException(ex.getMessage());
    }
  }

  public String getWhiteKey() {
    return this.whitePublicKey;
  }

  public String getBlackKey() {
    return this.blackPublicKey;
  }

  public String toString() {
    return ContactList.instance().getNicknameOfPublicKey(this.blackPublicKey);
  }

  public String getGameId() {
    return this.gameID;
  }

  public String getBeginningDate() {
    return this.beginningDate;
  }

  public String getMovesString() {
    return this.movesString;
  }

  public String getMovesSoFar() {
    return this.moveCount;
  }

  public SchachSpiel getSchachSpiel() {
    SchachSpiel spiel = new SchachSpiel(this.gameID, this.beginningDate, this.whitePublicKey, this.blackPublicKey, this.whiteMessage, this.blackMessage);
    spiel.doMoves(this.movesString);
    return spiel;
  }
}