package freenetmessageboard.core;

/**
 * Title:
 * Description:
 * Copyright:    Copyright (c) 2002
 * Company:
 * @author
 * @version 1.0
 */

public class ChessLounge extends javax.swing.table.AbstractTableModel implements Runnable, MessageArrivedListener, javax.swing.ComboBoxModel {

  private static ChessLounge instance;

  private java.util.List opponentList= new java.util.LinkedList();

  private java.util.List newMessagesList = new java.util.LinkedList();
  private java.util.HashMap chessMessagesMap = new java.util.HashMap();
  private java.util.List allGameIds = new java.util.LinkedList();

  private java.util.List listDataListenerList = new java.util.LinkedList();

  private String colNames[] = { "white", "black", "last move at", "moves", "beginning" };

  private boolean informMeWhenItsMyTurn=false;

  private ChessMessage selectedOpponentMessage;

  private ChessLounge() {
    MessagePool.instance().addMessageArrivedListener(this, MessageFilter.getChessMessagesOnlyFilter());
  }

  public void informMeWhenItsMyTurn(boolean b) {
    if (b==false) {
      this.informMeWhenItsMyTurn=false;
      return;
    }
    CoreLogger.log("processing messages from local hard disk..", CoreLogger.LOG_NORMAL );
    this.processNewMessages();
    CoreLogger.log("looking for active games waiting for my turn...", CoreLogger.LOG_NORMAL );
    this.informMeWhenItsMyTurn=true;
    synchronized(this.allGameIds) {
      java.util.Iterator it = this.allGameIds.iterator();
      while (it.hasNext()) {
        String gameId = (String)it.next();
        CoreLogger.log("found "+gameId, CoreLogger.LOG_NORMAL );
        ChessMessage msg = (ChessMessage)this.chessMessagesMap.get(gameId);
        this.displayIfNeccessary(msg);
      }
    }
    CoreLogger.log("starting thread to listen for processing new messages...", CoreLogger.LOG_NORMAL );
  }

  public Object getSelectedItem() {
    if (this.selectedOpponentMessage!=null) {
      return this.selectedOpponentMessage;
    } else {
      return "select opponent...";
    }
  }

  public void setSelectedItem(Object o ) {
    if (o instanceof ChessMessage) {
      this.selectedOpponentMessage=(ChessMessage)o;
    } else {
      this.selectedOpponentMessage=null;
    }
  }

  public int getSize() {
    return this.opponentList.size()+1;
  }

  public Object getElementAt(int i) {
    if (i==0) {
      return "select opponent...";
    }
    return this.opponentList.get(i-1);
  }

  public void addListDataListener(javax.swing.event.ListDataListener l) {
    this.listDataListenerList.add(l);
  }

  public void removeListDataListener(javax.swing.event.ListDataListener l) {
    this.listDataListenerList.remove(l);
  }

  public static ChessLounge instance() {
    if (ChessLounge.instance==null) {
      ChessLounge.instance=new ChessLounge();
      ChessLounge.instance().start();
    }
    return ChessLounge.instance;
  }

  private void fireNewOpponent() {
    java.util.Iterator it = this.listDataListenerList.iterator();
    javax.swing.event.ListDataEvent event = new javax.swing.event.ListDataEvent(this, javax.swing.event.ListDataEvent.INTERVAL_ADDED, this.opponentList.size(), this.opponentList.size());
    while (it.hasNext()) {
      javax.swing.event.ListDataListener listener = (javax.swing.event.ListDataListener)it.next();
      listener.intervalAdded(event);
    }
  }

  private void fireNewGame() {
    super.fireTableRowsInserted(this.allGameIds.size()-1, this.allGameIds.size()-1);
  }

  private void fireGameChanged(String gameId) {
    int rowIndex = this.allGameIds.indexOf(gameId);
    super.fireTableRowsUpdated(rowIndex, rowIndex);
  }

  public int getColumnCount() {
    return this.colNames.length;
  }

  public String getColumnName(int i) {
    return this.colNames[i];
  }

  public void showGame(int i) {
    String gameId=(String)this.allGameIds.get(i);
    ChessMessage msg = (ChessMessage)this.chessMessagesMap.get(gameId);
    freenetmessageboard.schach.SchachTestFrame frame = new freenetmessageboard.schach.SchachTestFrame(msg.getSchachSpiel());
  }

  public int getRowCount() {
    return this.allGameIds.size();
  }

  public Object getValueAt(int row, int col) {
    String gameId = (String)this.allGameIds.get(row);
    ChessMessage msg = (ChessMessage)this.chessMessagesMap.get(gameId);
    switch (col) {
      case 0:
        return ContactList.instance().getNicknameOfPublicKey(msg.getWhiteKey());
      case 1:
        return ContactList.instance().getNicknameOfPublicKey(msg.getBlackKey());
      case 2:
        return msg.getDate();
      case 3:
        return msg.getMovesSoFar();
      case 4:
        return msg.getBeginningDate();
    }
    return "";
  }

  private void displayIfNeccessary(ChessMessage msg) {
    if (this.informMeWhenItsMyTurn==false) {
      CoreLogger.log("won't display begause displaying is turned off", CoreLogger.LOG_NORMAL );
      return;
    }
    if (msg.getBlackKey().equals(PersonalInfo.instance().getPublicKey())==false && msg.getWhiteKey().equals(PersonalInfo.instance().getPublicKey())==false) {
      CoreLogger.log("won't display because I am neither black nor white", CoreLogger.LOG_NORMAL );
      return;
    }
    freenetmessageboard.schach.SchachSpiel spiel = msg.getSchachSpiel();
    if (spiel.binIchAmZug()==false ) {
      CoreLogger.log("won't display because it's not my move", CoreLogger.LOG_NORMAL );
      return;
    }
    CoreLogger.log("i'm gonna show it", CoreLogger.LOG_NORMAL );
    freenetmessageboard.schach.SchachTestFrame frame = new freenetmessageboard.schach.SchachTestFrame(spiel);
  }

  public void processNewMessages() {
    synchronized(this.newMessagesList) {
      java.util.Iterator it = this.newMessagesList.iterator();
      while (it.hasNext()) {
        ChessMessage msg = (ChessMessage)it.next();
        if (msg.getGameId().length()==0) {
          CoreLogger.log("processing chess announcement from "+msg.getOriginalPublicKey(), CoreLogger.LOG_NORMAL );
          boolean opponentKnown=false;
          java.util.Iterator i = this.opponentList.iterator();
          while(i.hasNext()) {
            ChessMessage existing = (ChessMessage)i.next();
            if (existing.getBlackKey().equals(msg.getBlackKey())) {
              opponentKnown=true;
              break;
            }
          }
          if (opponentKnown==false) {
            CoreLogger.log("adding "+msg.getOriginalPublicKey()+" to the list of opponents", CoreLogger.LOG_NORMAL );
            this.opponentList.add(msg);
            this.fireNewOpponent();
          } else {
            CoreLogger.log("ignoring "+msg.getOriginalPublicKey()+"he is already in the list", CoreLogger.LOG_NORMAL );
          }
        } else {
          CoreLogger.log("received gamestate for game "+msg.getGameId(), CoreLogger.LOG_NORMAL );
          if (this.chessMessagesMap.containsKey(msg.getGameId())==false) {
            CoreLogger.log("its a new game, add it to the table", CoreLogger.LOG_NORMAL );
            this.chessMessagesMap.put(msg.getGameId(), msg);
            this.allGameIds.add(msg.getGameId());
            this.fireNewGame();
            this.displayIfNeccessary(msg);
          } else {
            ChessMessage existingMsg = (ChessMessage)this.chessMessagesMap.get(msg.getGameId());
            if (msg.getDate().compareTo(existingMsg.getDate())>0) {
              CoreLogger.log("it is a new gamestate, updating the table", CoreLogger.LOG_NORMAL );
              if (msg.getMovesString().startsWith(existingMsg.getMovesString())==false) {
                CoreLogger.log("ignoring the new gamestate because it doesn't start with the same move as the old one!", CoreLogger.LOG_ERROR);
              } else {
                this.chessMessagesMap.put(msg.getGameId(), msg);
                this.fireGameChanged(msg.getGameId());
                this.displayIfNeccessary(msg);
              }
            } else {
              CoreLogger.log("ignore it, it is an old gamestate", CoreLogger.LOG_NORMAL );
            }
          }
        }
        it.remove();
      }
    }
  }

  public void start() {
    Thread thread = new Thread(this, "chess lounge");
    thread.start();
  }

  public void run() {
    while(true) {
      this.processNewMessages();
      try {
        Thread.sleep(5000);
      }
      catch (InterruptedException ex) {
      }

    }
  }

  public void messageArrived(Message msg) {
    CoreLogger.log("a new chess message arrived: "+msg.toShortString(), CoreLogger.LOG_NORMAL );
    synchronized(this.newMessagesList) {
      this.newMessagesList.add(msg);
    }
  }


}