package freenetmessageboard.core;

/**
 * Title:
 * Description:
 * Copyright:    Copyright (c) 2002
 * Company:
 * @author
 * @version 1.0
 */

public class CharEncodingTest {

  public CharEncodingTest() {
  }

  private static String constructStringWithVeryStrangeChars(char from, char to) {
    StringBuffer buf = new StringBuffer(to-from);
    for (char c=from; c<to; c++) {
      buf.append(c);
    }
    return buf.toString();
  }

  private static boolean testWithString(String testString) {
    try {
      System.err.println("creating the message...");
      Message msg = new PostMessage("very strange chars", "", "", testString);
      msg.setOriginalUri("SSK@"+msg.getUniqueId());
      System.err.println("creating String version of the message...");
      String msgTxt = msg.getString();
      System.err.println("converting the string to bytes...");
      byte[] msgBytes = Message.getBytesFromString(msgTxt);
      System.err.println("converting the bytes to a string again...");
      String newString = Message.getStringFromBytes(msgBytes);
      System.err.println("parse the string to get the message back");
      Message parsedMsg = Message.parseString(newString);
      if (msg.equals(parsedMsg)==false) throw new Exception("the parsed message is different from the original");
      System.err.println("hurra! the message is still the same");
      Message[] msgs = new Message[1];
      msgs[0]=parsedMsg;
      System.err.println("creating an archive with the message in it...");
      MessageArchive archive = new MessageArchive(msgs, "test");
      System.err.println("get the message out of the archie again...");
      Message[] archivedMsgs = archive.getMessages();
      if (msg.equals(archivedMsgs[0])==false)  throw new Exception("the archived messagee is different from the original");
      System.err.println("hurra! the message is still the same");
      java.io.FileOutputStream fos = new java.io.FileOutputStream("testOutput");
      System.err.println("writing the message to disk...");
      fos.write(msgBytes);



      fos.close();
      return true;
    } catch (Exception ex) {
      ex.printStackTrace();
      return false;
    }
  }

  public static void main(String[] args) {
    for (int i=0; i<1; i++) {
      System.err.println("constructing a weird string...");
      String testString = CharEncodingTest.constructStringWithVeryStrangeChars((char)0, (char)(30000));
      if (CharEncodingTest.testWithString(testString)==false) {
        System.err.print(" "+i);
      }
    }
    System.exit(0);
  }
}