package freenetmessageboard.core;

/**
 * Title:
 * Description:
 * Copyright:    Copyright (c) 2002
 * Company:
 * @author
 * @version 1.0
 */

public class ChannelInfo {

  String baseName;
  private java.util.List receivedIndexList = new java.util.LinkedList();
  private java.util.List numberOfRetriesList = new java.util.LinkedList();
  private int currentIndex;
  private int currentHtl;

  private boolean[] receivedIndex = new boolean[10];
  private boolean[] indexMustBeThere=new boolean[10];
  private int[] triedIndex = new int[10];

  private boolean isListening;


  private String statusString = "not listening on this channel";
  private String slotInfoString = "";

  private static java.util.HashMap allInfos = new java.util.HashMap();

  private ChannelInfo(String baseName) {
    this.baseName=baseName;
    if (Message.isUriFromKey(baseName, PersonalInfo.instance().getPublicKey())) {
      this.statusString= "this is you";
    }
  }

  void startedListening(String statusString) {
    this.statusString=statusString;
    this.isListening=true;
  }

  public static ChannelInfo getInstance(String baseName) {
    ChannelInfo channelInfo = (ChannelInfo)ChannelInfo.allInfos.get(baseName);
    if (channelInfo==null) {
      channelInfo = new ChannelInfo(baseName);
      ChannelInfo.allInfos.put(baseName, channelInfo);
    }
    return channelInfo;
  }

  public static boolean instanceExists(String baseName) {
    return ChannelInfo.allInfos.containsKey(baseName);
  }

  int getHTLForCurrentRequest() {
    int htl = FreenetNetworkSettings.instance().channelRequestHTL+(this.getRetryCountOfIndex(this.currentIndex)*FreenetNetworkSettings.instance().channelRequestHTLIncrease);
    return htl;
  }

  String getNextUri() {
    return this.baseName+this.getNextIndex();
  }

  int getCurrentSlot() {
    return this.currentIndex;
  }


  synchronized int getRetryCountOfIndex(int i) {
    if (i>this.receivedIndex.length) {
      this.increaseArrayBounds(i+10);
    }
    return this.triedIndex[i];
  }

  public synchronized String getStatusString() {
    CoreLogger.log("the status string of channel "+this.baseName+" is "+this.statusString, CoreLogger.LOG_INFO);
    return this.statusString;
  }

  public synchronized String getSlotInfoString() {
    if (this.slotInfoString.length()>30) {
      return "..."+this.slotInfoString.substring(this.slotInfoString.length()-30);
    }
    return this.slotInfoString;
  }

  synchronized void updateSlotInfoString() {
    StringBuffer buf = new StringBuffer(40);
    boolean isInserting=false;
    int insertIndex=MessageGateway.instance().getCurrentPublicAnnouncementInsertIndex();
    if (insertIndex!=-1) {
      CoreLogger.log("I am currently announcing on slot "+insertIndex, CoreLogger.LOG_NORMAL);
      isInserting=true;
    }
    for (int i=0; i<this.triedIndex.length; i++) {
      String uri = this.baseName+i;
      if (MessageGateway.instance().isUriSpammed(uri)) {
        buf.append('?');
        continue;
      }
      if (isInserting) {
        if (this.baseName.equals(MessageGateway.instance().constructPublicAnnouncementChannelBaseName(MessageGateway.getCurrentDate()))) {
          if (i==insertIndex) {
            buf.append('I');
            continue;
          }
        }
      }
      if (this.currentIndex==i) {
        buf.append('R');
        continue;
      }
      if (this.receivedIndex[i]==true) {
        buf.append('X');
        continue;
      }
      boolean onlyZerosAfterThisIndex=true;
      for (int j=i; j<this.triedIndex.length; j++) {
        if (this.triedIndex[j]>0 ||this.receivedIndex[j] || this.indexMustBeThere[j]) {
          onlyZerosAfterThisIndex=false;
        }
      }
      if (onlyZerosAfterThisIndex) {
        break;
      }
      String triesString = Integer.toString(this.triedIndex[i]);
      buf.append(triesString.charAt(triesString.length()-1));
    }
    this.slotInfoString=buf.toString();

  }

  synchronized void setStatusString(String statusString) {
    CoreLogger.log("setting status string of channel "+this.baseName+" to "+statusString, CoreLogger.LOG_INFO);
    this.statusString=statusString;
    this.updateSlotInfoString();
    if (this.baseName.startsWith("SSK@")) {
      String publicKey = this.baseName.substring(4,35);
      CoreLogger.log("updating channel status on contact list...", CoreLogger.LOG_INFO);
      freenetmessageboard.Main.getGUI().updateContactPanel(publicKey);
    }
    if (this.baseName.equals(MessageGateway.instance().constructPublicAnnouncementChannelBaseName(MessageGateway.getCurrentDate()))) {
      freenetmessageboard.Main.getGUI().setAnnouncementChannelStatusString(this.statusString, this.getSlotInfoString());
    }

  }

  private synchronized int getNextIndex() {
    CoreLogger.log("calculating which slot to request next from channel "+this.baseName, CoreLogger.LOG_INFO);

    int lastReceivedIndex=-1;
    int lastIndexWhichMustBeThere=-1;
    for (int i=0; i<this.receivedIndex.length; i++) {
      if (this.isIndexReceived(i)) {
        lastReceivedIndex=i;
      } else {
        if (this.indexMustBeThere[i]) {
          lastIndexWhichMustBeThere=i;
        }
      }
    }

    CoreLogger.log("last index that was received: "+lastReceivedIndex, CoreLogger.LOG_INFO);
    CoreLogger.log("last index I heard of: "+lastIndexWhichMustBeThere, CoreLogger.LOG_INFO);
    if (lastIndexWhichMustBeThere!=-1) {
      if (this.triedIndex[lastIndexWhichMustBeThere]<2) {
       this.currentIndex=lastIndexWhichMustBeThere;
        CoreLogger.log("try the last index i heard of: "+lastIndexWhichMustBeThere, CoreLogger.LOG_INFO);
        return this.currentIndex;
      } else {
        CoreLogger.log("DON'T try the last index i heard of: "+lastIndexWhichMustBeThere+", tried "+this.triedIndex[lastIndexWhichMustBeThere]+" times before", CoreLogger.LOG_INFO);
      }
    }

    int possibleNextIndex=-1;

    for (int i=0; i<this.receivedIndex.length; i++) {
      if (this.isIndexReceived(i)) continue;
      if (possibleNextIndex==-1) {
        possibleNextIndex=i;
      }
      if (i>lastReceivedIndex+3 && i>lastIndexWhichMustBeThere) {
        CoreLogger.log("try index "+possibleNextIndex+", there were no message after "+lastReceivedIndex, CoreLogger.LOG_INFO);
        this.currentIndex=possibleNextIndex;
        return this.currentIndex;
      }
      if (this.triedIndex[i]<this.triedIndex[possibleNextIndex]) {
        CoreLogger.log("maybe index "+i+", we've tried it only "+this.triedIndex[i]+" times.", CoreLogger.LOG_INFO);
        possibleNextIndex=i;
      } else {
        CoreLogger.log("don't try index "+i+", we've tried it "+this.triedIndex[i]+" times.", CoreLogger.LOG_INFO);
      }
    }
    int oldLength = this.receivedIndex.length;
    this.increaseArrayBounds(oldLength+10);
    this.currentIndex=oldLength;
    return oldLength;
  }

  private synchronized int getNextIndexOld() {
    CoreLogger.log("calculating which slot to request next from channel "+this.baseName, CoreLogger.LOG_INFO);
    int nextHoleToStuff=-1;
    int lastReceivedIndex=-1;
    int retriesOfNextHole=99;
    for (int i=0; i<this.receivedIndex.length; i++) {
      if (this.isIndexReceived(i)==false) {
        CoreLogger.log("slot "+i+" has not been received yet...", CoreLogger.LOG_INFO);
        if (nextHoleToStuff!=-1) {
          if (this.triedIndex[i]>retriesOfNextHole-(i-nextHoleToStuff)+4 && this.triedIndex[i]<9) {
            CoreLogger.log("try slot "+nextHoleToStuff+" ("+retriesOfNextHole+"), before trying slot "+i+" ("+this.triedIndex[i]+" retries).", CoreLogger.LOG_INFO);
            this.currentIndex=nextHoleToStuff;
            return nextHoleToStuff;
          }
        }
        if (this.triedIndex[i]<retriesOfNextHole) {
          CoreLogger.log("slot "+i+" looks good, because you only have tried it "+this.triedIndex[i]+" times...", CoreLogger.LOG_INFO);
          nextHoleToStuff=i;
          retriesOfNextHole=this.triedIndex[i];
        }
      } else {
        lastReceivedIndex=i;
      }

      if (i-lastReceivedIndex>=3) {
        CoreLogger.log("try slot "+nextHoleToStuff+", there was no other message found up to slot "+i, CoreLogger.LOG_INFO);
        this.currentIndex=nextHoleToStuff;
        return nextHoleToStuff;
      }
    }
    int nextIndex = this.receivedIndex.length;
    this.increaseArrayBounds(this.receivedIndex.length+10);
    CoreLogger.log("increased array bounds to create slot "+nextIndex, CoreLogger.LOG_INFO);
    this.currentIndex=nextIndex;
    return nextIndex;
  }

  synchronized boolean isIndexReceived(int i) {
    if (i>=this.receivedIndex.length) {
      return false;
    } else {
      return this.receivedIndex[i];
    }
  }

  private synchronized void increaseArrayBounds(int newSize) {
    boolean[] newReceivedArray = new boolean[newSize];
    for (int i=0; i<newReceivedArray.length; i++) {
      if (i<this.receivedIndex.length) {
        newReceivedArray[i]=this.receivedIndex[i];
      } else {
        newReceivedArray[i]=false;
      }
    }
    this.receivedIndex=newReceivedArray;

    boolean[] newMustBeThereArray = new boolean[newSize];
    for (int i=0; i<newMustBeThereArray.length; i++) {
      if (i<this.indexMustBeThere.length) {
        newMustBeThereArray[i]=this.indexMustBeThere[i];
      } else {
        newMustBeThereArray[i]=false;
      }
    }
    this.indexMustBeThere=newMustBeThereArray;

    int[] newTriedArray = new int[newSize];
    for (int i=0; i<newTriedArray.length; i++) {
      if (i<this.triedIndex.length) {
        newTriedArray[i]=this.triedIndex[i];
      } else {
        newTriedArray[i]=0;
      }
    }
    this.triedIndex=newTriedArray;
  }

  synchronized void heardOfIndex(int i) {
    if (i>=this.receivedIndex.length) {
      this.increaseArrayBounds(i+10);
    }
    this.indexMustBeThere[i]=true;
  }

  synchronized void failedToReceiveIndex(int i) {
    if (i>=this.receivedIndex.length) {
      this.increaseArrayBounds(i+10);
    }
    this.triedIndex[i]++;
  }

  synchronized void receivedIndex(int i) {
    if (i>=this.receivedIndex.length) {
      this.increaseArrayBounds(i+10);
    }
    this.receivedIndex[i]=true;
  }
}
