package freenetmessageboard.core;

import javax.swing.tree.DefaultMutableTreeNode;

/**
 * Title:
 * Description:
 * Copyright:    Copyright (c) 2002
 * Company:
 * @author
 * @version 1.0
 */

public class BoardContent extends javax.swing.table.AbstractTableModel implements MessageArrivedListener {

  private static BoardContent instance;

  private java.util.List allPosts = new java.util.LinkedList();

  private int unreceivedIndex=0;

  private java.util.Set unreadPosts = new java.util.HashSet();

  java.util.HashMap treeNodes = new java.util.HashMap();

  private boolean markAsUnread=true;

  private PostMessageTreeNode rootNode = new PostMessageTreeNode("don't touch me before the tree has build up...");
  private javax.swing.tree.DefaultTreeModel treeModel = new javax.swing.tree.DefaultTreeModel(rootNode);

  private BoardContent(){
    MessagePool.instance().addMessageArrivedListener(this, MessageFilter.getAllPostsMessageFilter());
  }

  public PostMessageTreeNode getTreeNode(PostMessage msg) {
    PostMessageTreeNode treeNode = (PostMessageTreeNode)this.treeNodes.get(msg.getUniqueId());
    if (treeNode==null) {
      CoreLogger.log("couldn't find a treenode for the "+msg.toShortString(), CoreLogger.LOG_ERROR);
    }
    return treeNode;
  }

  public javax.swing.tree.TreeModel getTreeModel() {
    return this.treeModel;
  }

  public static synchronized BoardContent instance() {
    if (BoardContent.instance==null) {
      BoardContent.instance=new BoardContent();
    }
    return BoardContent.instance;
  }

  public void setMarkAsUnreadFlag(boolean b) {
    this.markAsUnread=b;
    if (b==true) {
      this.rootNode.setUserObject("the posts should appear here...");
      this.treeModel.nodeChanged(this.rootNode);
    }
  }

  public int getRowCount() {
    return this.allPosts.size();
  }

  public void markAsRead(PostMessage msg) {
    synchronized(this.unreadPosts) {
      if (this.unreadPosts.contains(msg.getUniqueId())) {
        this.unreadPosts.remove(msg.getUniqueId());
        PostMessageTreeNode readNode = (PostMessageTreeNode)this.treeNodes.get(msg.getUniqueId());
        readNode.checkForUnreadChildren();
        PostMessageTreeNode node = (PostMessageTreeNode)readNode.getParent();
        while(node!=null) {
          node.checkForUnreadChildren();
          this.treeModel.nodeChanged(node);
          node=(PostMessageTreeNode)node.getParent();

        }
      }
    }
  }

  public PostMessage getMessageAtRow(int row) {
    PostMessage msg = (PostMessage)this.allPosts.get(row);
    this.markAsRead(msg);
    return msg;
  }

  public int getColumnCount() {
    return 3;
  }

  public Object getValueAt(int row, int col) {
    StringBuffer buf = new StringBuffer(50);
    PostMessage msg = (PostMessage)this.allPosts.get(row);
    if (this.unreadPosts.contains(msg.getUniqueId())) {
      buf.append(this.getBeginUnreadTag());
    }
    if (col==0) {
      buf.append(ContactList.instance().getNicknameOfPublicKey(msg.getOriginalPublicKey()));
      if (msg.getOriginalPublicKey().equals(msg.getSourceKey())==false) {
        buf.append(" (unverified)");
      }
    }
    if (col==1) {
      buf.append(msg.getSubject());
    }
    if (col==2) {
      buf.append(msg.getDate());
    }
    if (this.unreadPosts.contains(msg.getUniqueId())) {
      buf.append(this.getEndUnreadTag());
    }
    return buf.toString();
  }

  public String getBeginUnreadTag() {
    return "<html><b><font face=\"SansSerif\">";
  }

  public String getEndUnreadTag() {
    return "</font></b></html>";
  }

  public String getBeginUnreadRepliesTag() {
    return "<html><b><font face=\"SansSerif\" color=\"gray\">";
  }

  public String getEndUnreadRepliesTag() {
    return "</font></b></html>";
  }

  public String getColumnName(int col) {
    if (col==0) return "from";
    if (col==1) return "subject";
    if (col==2) return "date";
    return "nosuchcol";
  }

  public void messageArrived(Message msg) {
    CoreLogger.log("the new message "+((PostMessage)msg).getSubject()+" was received.", CoreLogger.LOG_NORMAL);
    synchronized(this.allPosts) {
      if (this.allPosts.contains(msg)) {
        int index = this.allPosts.indexOf(msg);
        CoreLogger.log("there already is a copy there", CoreLogger.LOG_NORMAL);
        if (msg.getSourceUri().equals(msg.getOriginalUri())) {
          CoreLogger.log("the new one is the original one", CoreLogger.LOG_NORMAL);
          this.allPosts.remove(index);
          this.allPosts.add(msg);
          PostMessageTreeNode node = (PostMessageTreeNode)this.treeNodes.get(msg.getUniqueId());
          node.setUserObject(msg);
        }
      } else {
        if (FMBSettings.instance().autoReply) {
          this.autoReplyMessage(msg);
        }
        if (this.markAsUnread) {
          this.unreadPosts.add(msg.getUniqueId());
        }
        this.addToTree(msg);
        this.allPosts.add(msg);
      }
      java.util.Collections.sort(this.allPosts, Message.getReverseDateComparator());
    }
    super.fireTableDataChanged();
    if (this.markAsUnread==false) {
      CoreLogger.log("updating the board content view", CoreLogger.LOG_NORMAL);
      freenetmessageboard.Main.getGUI().updateBoardContentView();
    }
  }

  public boolean isMessageRead(String uniqueID) {
    return (!this.unreadPosts.contains(uniqueID));
  }

  private void addToTree(Message msg) {
    try {
      String msgLine = ((PostMessage)msg).getSubject()+" ("+ContactList.instance().getNicknameOfPublicKey(msg.getOriginalPublicKey())+")";
      PostMessageTreeNode newNode;

      if (this.treeNodes.containsKey(msg.getUniqueId())) {
        CoreLogger.log("there is an existing temporary node for msg: "+((PostMessage)msg).getSubject(), CoreLogger.LOG_INFO);
        PostMessageTreeNode existingNode = (PostMessageTreeNode)this.treeNodes.get(msg.getUniqueId());
        DefaultMutableTreeNode parentNode = (PostMessageTreeNode)existingNode.getParent();
        existingNode.setUserObject(msg);
        CoreLogger.log("removing "+existingNode.getUserObject()+" from "+parentNode.getUserObject()+"...", CoreLogger.LOG_INFO);
        this.treeModel.removeNodeFromParent(existingNode);
        newNode=existingNode;
      } else {
        newNode = new PostMessageTreeNode((PostMessage)msg);
      }

      PostMessageTreeNode parentNode = this.getParentNode((PostMessage)msg);
      CoreLogger.log("adding node "+newNode.getUserObject()+" to node "+parentNode.getUserObject()+"...", CoreLogger.LOG_INFO);

      boolean inserted=false;
      CoreLogger.log("parent node has "+parentNode.getChildCount()+" children", CoreLogger.LOG_INFO);
      for (int i=0; i<parentNode.getChildCount(); i++) {

        PostMessageTreeNode existingNode = (PostMessageTreeNode)parentNode.getChildAt(i);
        java.util.Comparator comp;
        if (parentNode.equals(this.rootNode)) {
          comp = PostMessageTreeNode.getDateComparator();
        } else {
          comp = PostMessageTreeNode.getReverseDateComparator();
        }
         if (comp.compare(existingNode, newNode)<0) {
          CoreLogger.log("inserting node "+newNode+" after node "+existingNode+" at pos "+i, CoreLogger.LOG_INFO);
          this.treeModel.insertNodeInto(newNode, parentNode, i);
          inserted=true;
          break;
        }
      }
      if (inserted==false) {
       this.treeModel.insertNodeInto(newNode, parentNode, parentNode.getChildCount());
      }
      CoreLogger.log("node "+newNode+" is the final node for id: "+msg.getUniqueId(), CoreLogger.LOG_INFO);

      rootNode.checkForUnreadChildren();

      newNode.checkForUnreadChildren();
      PostMessageTreeNode node = (PostMessageTreeNode)newNode.getParent();
      while(node!=null) {
        node.checkForUnreadChildren();
        node=(PostMessageTreeNode)node.getParent();
      }

      this.treeNodes.put(msg.getUniqueId(), newNode);
    } catch (Throwable t) {
      t.printStackTrace();
      CoreLogger.log("error while adding "+msg.toShortString()+" to the tree", CoreLogger.LOG_ERROR);
    }
  }

  private PostMessageTreeNode getParentNode(PostMessage msg) {

    String parentID = msg.getReplyToUniqueId();
    CoreLogger.log("the message "+msg.toShortString()+" is a reply to "+parentID, CoreLogger.LOG_INFO);
    if (parentID.length()==0) {
      return this.rootNode;
    }
    if (this.treeNodes.containsKey(parentID)) {
      return (PostMessageTreeNode)this.treeNodes.get(parentID);
    } else {
      CoreLogger.log("parent node for msg: "+msg.getSubject()+" doesn't exist yet!", CoreLogger.LOG_INFO);
      PostMessageTreeNode newParentNode = new PostMessageTreeNode("unreceived "+this.unreceivedIndex++);
       CoreLogger.log("node "+newParentNode+" is the temp node for id: "+msg.getUniqueId(), CoreLogger.LOG_INFO);
      this.treeNodes.put(parentID, newParentNode);
      CoreLogger.log("added temp node "+newParentNode.getUserObject()+" to "+this.rootNode.getUserObject(), CoreLogger.LOG_INFO);
      this.treeModel.insertNodeInto(newParentNode, this.rootNode, this.rootNode.getChildCount());
  //    this.treeModel.nodeChanged(this.rootNode);
      return newParentNode;
    }
  }

  private void autoReplyMessage(Message msg) {
    final PostMessage postMsg = (PostMessage)msg;
    CoreLogger.log("sending autoreply to "+postMsg.getSubject()+"...", CoreLogger.LOG_WARNING);

    String msgString = "I received your message at "+Message.messageDateFormat.format(new java.util.Date())+" from "+postMsg.getSourceUri();
    final PostMessage replyMessage = new PostMessage("AutoReply: "+postMsg.getSubject(), postMsg.getUniqueId(), postMsg.getKeywords(), msgString);
    Thread helperThread = new Thread() {
      public void run() {
        if ( FMBSettings.instance().autoForward==false) {
          MessageGateway.instance().sendMessageOnPersonalChannel(postMsg);
        }
        MessageGateway.instance().sendMessageOnPersonalChannel(replyMessage);
      }
    };
    helperThread.start();
  }
}