package freenetmessageboard.core;

/**
 * Title:
 * Description:
 * Copyright:    Copyright (c) 2002
 * Company:
 * @author
 * @version 1.0
 */

public class ArchiveMessage extends Message {

  private String uri;
  private String messageListingString;
  private int size;
  private String description;

  public ArchiveMessage(String uri, MessageArchive archive) {
    super(Message.MSG_TYPE_ARCHIVE);
    this.uri=uri;
    this.messageListingString=archive.getMessageListing();
    this.size=archive.getBytes().length;
    this.description=archive.getDescription();
    super.setField("uri", this.uri);
    super.setField("messageListing", this.messageListingString);
    super.setField("description", this.description);
    super.setField("size", Integer.toString(this.size));
  }

  public ArchiveMessage(String msgString) throws MessageFormatException {
    super(msgString);
    try {
      this.uri=super.getField("uri");
      this.messageListingString=super.getField("messageListing");
      this.description=super.getField("description");
      this.size=Integer.parseInt(super.getField("size"));
    } catch (Throwable t) {
      throw new MessageFormatException(t.getClass()+": "+t.getMessage());
    }
  }

  String getUri() {
    return this.uri;
  }

  String getDescription() {
    return this.description;
  }

  int getSize() {
    return this.size;
  }

  String[] getUniqueIDs() {
    try {
      java.io.StringReader reader = new java.io.StringReader(this.messageListingString);
      java.io.LineNumberReader lnr = new java.io.LineNumberReader(reader);
      java.util.List idList = new java.util.ArrayList();
      String nextLine = lnr.readLine();
      while (nextLine!=null) {
        idList.add(nextLine);
        nextLine=lnr.readLine();
      }
      return (String[])idList.toArray(new String[idList.size()]);
    } catch (Throwable t) {
      return new String[0];
    }


  }
}