package freenetmessageboard;

/**
 * Title:
 * Description:
 * Copyright:    Copyright (c) 2002
 * Company:
 * @author
 * @version 1.0
 */

public class Main {

  public Main() {
  }

  private static freenetmessageboard.gui.GUIInterface gui;

  public static freenetmessageboard.gui.GUIInterface getGUI() {
    return Main.gui;
  }

  public static void shutDown() {
    System.err.println("closing fmb...");

    try {
      freenetmessageboard.core.MessagePool.instance().saveToDisk();
      System.exit(0);
    } catch (Exception ex) {
      System.err.println("failed to close down properly...");
      System.exit(-1);
    }
  }

  public static void main(String[] args) {

    freenetmessageboard.core.CoreLogger.logLevel=freenetmessageboard.core.CoreLogger.LOG_WARNING;
    freenetmessageboard.fcpinterface.FCPLogger.setLoggingLevel(freenetmessageboard.fcpinterface.FCPLogger.INTERFACE_WARNING);

    boolean autoListen=false;
    boolean autoReply=false;
    boolean autoForward=false;
    boolean forwarderMode=false;
    try {
      for (int i=0; i<args.length; i++) {

      // Don't uncomment this, unless you want to fix that deadlock problem that occur!

        if(args[i].equals("--autoListen")) {
          autoListen=true;
          continue;
        }
        if(args[i].equals("--forward")) {
          forwarderMode=true;
          continue;
        }
   /*     if(args[i].equals("--autoForward")) {
          autoForward=true;
          continue;
        }
        if (args[i].equals("--autoReply")) {
          autoReply=true;
          continue;
        }*/
        if (args[i].equals("--verbose")) {
          freenetmessageboard.core.CoreLogger.logLevel=freenetmessageboard.core.CoreLogger.LOG_NORMAL;
          continue;
        }
        if (args[i].equals("--fcpPort")) {
          freenetmessageboard.fcpinterface.FCPConfig.setPort(Integer.parseInt(args[++i]));
          System.err.println("fcp port set to "+freenetmessageboard.fcpinterface.FCPConfig.getPort());
          continue;
        }
        if (args[i].equals("--fcpHost")) {
          freenetmessageboard.fcpinterface.FCPConfig.setHostname(args[++i]);
          System.err.println("fcp host set to "+freenetmessageboard.fcpinterface.FCPConfig.getHostname());
          continue;
        }
        if (args[i].equals("--help")) {
          throw new Exception();
        }
      }
    } catch (Throwable t) {
      System.err.println("syntax: java -jar fmb.jar [--fcpPort portNr] [--fcpHost ip.adress] [--verbose] [--autoListen]");
      System.exit(-1);
    }

    if (forwarderMode) {
      Main.gui=freenetmessageboard.gui.DummieGUI.instance();
      freenetmessageboard.core.PersonalInfo.setDemonMode("[forwarder]");
      freenetmessageboard.core.MessagePool.instance().processNewMessages();
      freenetmessageboard.core.ForwardDemon forwardDemon = new freenetmessageboard.core.ForwardDemon();
      freenetmessageboard.core.MessagePool.instance().start();
      forwardDemon.start();
      return;
    }

    Main.gui=freenetmessageboard.gui.BetaGUI.instance();

    freenetmessageboard.gui.BetaGUI.instance().activateGUI();
    freenetmessageboard.gui.ColorsAndIcons.instance();

    freenetmessageboard.core.FMBSettings.instance().setAutoListen(autoListen);
    freenetmessageboard.core.PersonalInfo.instance();

    if (freenetmessageboard.core.PersonalInfo.instance().isDefault()) {
      freenetmessageboard.core.CoreLogger.log("show personal information dialog...", freenetmessageboard.core.CoreLogger.LOG_NORMAL);
      Main.gui.showPersonalInformationDialog(freenetmessageboard.core.PersonalInfo.instance());
      try {
        freenetmessageboard.core.PersonalInfo.instance().saveToDisk();
      } catch (java.io.IOException ex) {
        freenetmessageboard.core.CoreLogger.log("failed to save updated personal info to disk", freenetmessageboard.core.CoreLogger.LOG_ERROR);
      }
    }
    freenetmessageboard.core.MessagePool.instance();
    freenetmessageboard.core.ContactList.instance();
    freenetmessageboard.core.ChessLounge.instance();
    freenetmessageboard.core.MessageArchiveReceiver.instance();

    freenetmessageboard.core.NewsgroupDataModel.instance();

    freenetmessageboard.core.NewsgroupDataModel.instance().setMarkNewMessagesAsUnread(false);
    freenetmessageboard.core.MessagePool.instance().processNewMessages();

    freenetmessageboard.core.NewsgroupDataModel.instance().setMarkNewMessagesAsUnread(true);

    freenetmessageboard.core.FMBSettings.instance().setAutoReply(autoReply);
    freenetmessageboard.core.FMBSettings.instance().setAutoForward(autoForward);

    freenetmessageboard.core.MessageGateway.instance().startListeningOnPublicAnnouncementChannel();
    freenetmessageboard.core.MessageArchiveReceiver.instance().start();

    freenetmessageboard.core.MessagePool.instance().start();


  }
}