/*
 * Decompiled with CFR 0.152.
 */
package freenetmessageboard.schach;

import freenetmessageboard.schach.Bauer;
import freenetmessageboard.schach.BesonderesEreignisException;
import freenetmessageboard.schach.Dame;
import freenetmessageboard.schach.Koenig;
import freenetmessageboard.schach.Laeufer;
import freenetmessageboard.schach.SchachFigur;
import freenetmessageboard.schach.SchachSpiel;
import freenetmessageboard.schach.Springer;
import freenetmessageboard.schach.Turm;
import freenetmessageboard.schach.UngueltigerZugException;

public class SchachZug {
    private SchachFigur figur;
    private int neuX;
    private int neuY;
    private int altX;
    private int altY;
    private int ereignis = -1;
    private static char[] zeilenNamen = new char[]{'1', '2', '3', '4', '5', '6', '7', '8'};
    private static char[] spaltenNamen = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H'};
    private SchachFigur beteiligteFigur;

    public SchachZug(SchachFigur schachFigur, int n, int n2) {
        this.figur = schachFigur;
        this.altX = schachFigur.posX;
        this.altY = schachFigur.posY;
        this.neuX = n;
        this.neuY = n2;
    }

    void setBesonderesEreignis(int n) {
        this.ereignis = n;
    }

    void setBeteiligteFigur(SchachFigur schachFigur) {
        this.beteiligteFigur = schachFigur;
    }

    SchachFigur getBeteiligteFigur() {
        return this.beteiligteFigur;
    }

    private static int getZeile(char c) {
        int n = 0;
        while (n < zeilenNamen.length) {
            if (zeilenNamen[n] == c) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private static int getSpalte(char c) {
        int n = 0;
        while (n < spaltenNamen.length) {
            if (spaltenNamen[n] == c) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    static SchachZug parseShortString(String string, SchachSpiel schachSpiel) throws UngueltigerZugException {
        try {
            int n = SchachZug.getSpalte(string.charAt(0));
            int n2 = SchachZug.getZeile(string.charAt(1));
            int n3 = SchachZug.getSpalte(string.charAt(2));
            int n4 = SchachZug.getZeile(string.charAt(3));
            SchachFigur schachFigur = schachSpiel.getFigurAnPosition(n, n2);
            SchachZug schachZug = new SchachZug(schachFigur, n3, n4);
            if (string.length() > 4) {
                SchachFigur schachFigur2 = null;
                String string2 = string.substring(5);
                if (string2.equals(Dame.name)) {
                    schachFigur2 = new Dame(schachSpiel, schachFigur.istWeiss, n3, n4);
                }
                if (string2.equals(Turm.name)) {
                    schachFigur2 = new Turm(schachSpiel, schachFigur.istWeiss, n3, n4);
                }
                if (string2.equals(Laeufer.name)) {
                    schachFigur2 = new Laeufer(schachSpiel, schachFigur.istWeiss, n3, n4);
                }
                if (string2.equals(Springer.name)) {
                    schachFigur2 = new Springer(schachSpiel, schachFigur.istWeiss, n3, n4);
                }
                if (schachFigur2 != null) {
                    schachZug.setBeteiligteFigur(schachFigur2);
                }
            }
            return schachZug;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new UngueltigerZugException(string + ": " + throwable.getClass().getName() + ": " + throwable.getMessage());
        }
    }

    public String toShortString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(spaltenNamen[this.altX]);
        stringBuffer.append(zeilenNamen[this.altY]);
        stringBuffer.append(spaltenNamen[this.neuX]);
        stringBuffer.append(zeilenNamen[this.neuY]);
        if (this.beteiligteFigur != null) {
            stringBuffer.append(",");
            stringBuffer.append(this.beteiligteFigur.getName());
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.figur.getName());
        stringBuffer.append(" ");
        stringBuffer.append(spaltenNamen[this.altX]);
        stringBuffer.append(zeilenNamen[this.altY]);
        stringBuffer.append(" - ");
        stringBuffer.append(spaltenNamen[this.neuX]);
        stringBuffer.append(zeilenNamen[this.neuY]);
        if (this.ereignis != -1) {
            if (this.ereignis == 4) {
                stringBuffer.append(" -> ");
                stringBuffer.append(this.beteiligteFigur.getName());
            } else {
                stringBuffer.append(": ");
                stringBuffer.append(BesonderesEreignisException.ereignisStrings[this.ereignis]);
            }
        }
        return stringBuffer.toString();
    }

    boolean istRochade() {
        return this.figur instanceof Koenig && Math.abs(this.neuX - this.altX) > 1;
    }

    boolean istBauernEroeffnung() {
        return this.figur instanceof Bauer && Math.abs(this.neuY - this.altY) == 2;
    }

    boolean istFigurUmwandlung() {
        return this.figur instanceof Bauer && (this.figur.istWeiss && this.neuY == 7 || !this.figur.istWeiss && this.neuY == 0);
    }

    public SchachFigur getFigur() {
        return this.figur;
    }

    public int getAltX() {
        return this.altX;
    }

    public int getAltY() {
        return this.altY;
    }

    public int getZielX() {
        return this.neuX;
    }

    public int getZielY() {
        return this.neuY;
    }
}

