/*
 * Decompiled with CFR 0.152.
 */
package freenetmessageboard.schach;

import freenetmessageboard.core.Message;
import freenetmessageboard.core.PersonalInfo;
import freenetmessageboard.schach.Bauer;
import freenetmessageboard.schach.BesonderesEreignisException;
import freenetmessageboard.schach.Dame;
import freenetmessageboard.schach.FigurGeschlagenException;
import freenetmessageboard.schach.KeineFigurAufDiesemFeldException;
import freenetmessageboard.schach.Koenig;
import freenetmessageboard.schach.Laeufer;
import freenetmessageboard.schach.SchachFigur;
import freenetmessageboard.schach.SchachZug;
import freenetmessageboard.schach.Springer;
import freenetmessageboard.schach.Turm;
import freenetmessageboard.schach.UngueltigerZugException;
import java.awt.Dimension;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractListModel;

public class SchachSpiel
extends AbstractListModel {
    private List schachFigurenListe = new LinkedList();
    private String whitePublicKey = new String();
    private String blackPublicKey = new String();
    private String gameId = new String();
    private String beginningDate = Message.messageDateFormat.format(new Date());
    String whiteMessage = new String();
    String blackMessage = new String();
    private List bisherigeZuegeListe = new LinkedList();
    private List bisherigePositionenHashmapListe = new LinkedList();
    private boolean weissAmZug = true;
    private boolean wurdeSchachGesagt = false;
    private boolean hatWeissSchonSchachGesagt = false;
    private boolean hatSchwarzSchonSchachGesagt = true;
    boolean letzterZugWarBauernEroeffnung = false;
    private boolean warDameVorherImSchach;
    private boolean alteStellungWirdAngezeigt = false;

    public SchachSpiel(SchachSpiel schachSpiel) {
        this.blackPublicKey = schachSpiel.blackPublicKey;
        this.whitePublicKey = schachSpiel.whitePublicKey;
        this.blackMessage = schachSpiel.blackMessage;
        this.whiteMessage = schachSpiel.whiteMessage;
        this.beginningDate = schachSpiel.beginningDate;
        this.gameId = schachSpiel.gameId;
        this.stelleFigurenAuf();
    }

    public SchachSpiel(String string) {
        this.blackPublicKey = string;
        this.whitePublicKey = PersonalInfo.instance().getPublicKey();
        Date date = new Date();
        this.beginningDate = Message.messageDateFormat.format(date);
        this.gameId = this.whitePublicKey + this.blackPublicKey + date.getTime();
        this.stelleFigurenAuf();
    }

    public SchachSpiel(String string, String string2, String string3, String string4, String string5, String string6) {
        this.gameId = string;
        this.beginningDate = string2;
        this.whitePublicKey = string3;
        this.blackPublicKey = string4;
        this.blackMessage = string6;
        this.whiteMessage = string5;
        this.stelleFigurenAuf();
    }

    public String getGameId() {
        return this.gameId;
    }

    public String getBeginningDate() {
        return this.beginningDate;
    }

    public String getWhitePublicKey() {
        return this.whitePublicKey;
    }

    public String getBlackMessage() {
        return this.blackMessage;
    }

    public String getWhiteMessage() {
        return this.whiteMessage;
    }

    public String getBlackPublicKey() {
        return this.blackPublicKey;
    }

    public void doMoves(String string) {
        try {
            LineNumberReader lineNumberReader = new LineNumberReader(new StringReader(string));
            String string2 = lineNumberReader.readLine();
            while (string2 != null) {
                SchachZug schachZug = SchachZug.parseShortString(string2, this);
                string2 = lineNumberReader.readLine();
                try {
                    this.fuehreZugAus(schachZug);
                }
                catch (BesonderesEreignisException besonderesEreignisException) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            System.err.println("Ungueltiger Zug im moveString:" + exception.getMessage() + "\n" + string);
        }
    }

    public int getMoveCount() {
        return this.bisherigeZuegeListe.size();
    }

    public String getMovesString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.bisherigeZuegeListe.iterator();
        while (iterator.hasNext()) {
            SchachZug schachZug = (SchachZug)iterator.next();
            stringBuffer.append(schachZug.toShortString());
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    public int getSize() {
        return this.bisherigeZuegeListe.size();
    }

    public Object getElementAt(int n) {
        if (n % 2 == 0) {
            return n / 2 + 1 + ": " + this.bisherigeZuegeListe.get(n);
        }
        return "  " + this.bisherigeZuegeListe.get(n);
    }

    Dimension getPreferredScrollableViewportSize() {
        return new Dimension(80, this.schachFigurenListe.size() * 10);
    }

    private void stelleFigurenAuf() {
        this.schachFigurenListe.add(new Koenig(this, true, 4, 0));
        this.schachFigurenListe.add(new Koenig(this, false, 4, 7));
        this.schachFigurenListe.add(new Dame(this, true, 3, 0));
        this.schachFigurenListe.add(new Dame(this, false, 3, 7));
        this.schachFigurenListe.add(new Laeufer(this, true, 2, 0));
        this.schachFigurenListe.add(new Laeufer(this, true, 5, 0));
        this.schachFigurenListe.add(new Laeufer(this, false, 2, 7));
        this.schachFigurenListe.add(new Laeufer(this, false, 5, 7));
        this.schachFigurenListe.add(new Springer(this, true, 1, 0));
        this.schachFigurenListe.add(new Springer(this, true, 6, 0));
        this.schachFigurenListe.add(new Springer(this, false, 1, 7));
        this.schachFigurenListe.add(new Springer(this, false, 6, 7));
        this.schachFigurenListe.add(new Turm(this, true, 0, 0));
        this.schachFigurenListe.add(new Turm(this, true, 7, 0));
        this.schachFigurenListe.add(new Turm(this, false, 0, 7));
        this.schachFigurenListe.add(new Turm(this, false, 7, 7));
        int n = 0;
        while (n < 8) {
            this.schachFigurenListe.add(new Bauer(this, true, n, 1));
            this.schachFigurenListe.add(new Bauer(this, false, n, 6));
            ++n;
        }
    }

    boolean istFigurBedroht(SchachFigur schachFigur, SchachFigur schachFigur2) {
        Iterator iterator = this.schachFigurenListe.iterator();
        while (iterator.hasNext()) {
            SchachFigur schachFigur3 = (SchachFigur)iterator.next();
            if (schachFigur2 != null && schachFigur3.equals(schachFigur2) || schachFigur.istWeiss == schachFigur3.istWeiss) continue;
            try {
                schachFigur3.zugMoeglich(schachFigur.posX, schachFigur.posY, false);
            }
            catch (UngueltigerZugException ungueltigerZugException) {
            }
            catch (FigurGeschlagenException figurGeschlagenException) {
                return true;
            }
        }
        return false;
    }

    SchachZug getLetztenZug() {
        return (SchachZug)this.bisherigeZuegeListe.get(this.bisherigeZuegeListe.size() - 1);
    }

    SchachZug[] getMoeglicheZuege() {
        LinkedList<SchachZug> linkedList = new LinkedList<SchachZug>();
        Iterator iterator = new LinkedList(this.schachFigurenListe).iterator();
        while (iterator.hasNext()) {
            SchachFigur schachFigur = (SchachFigur)iterator.next();
            if (schachFigur.istWeiss != this.weissAmZug) continue;
            int n = 0;
            while (n < 8) {
                int n2 = 0;
                while (n2 < 8) {
                    try {
                        if (schachFigur.zugMoeglich(n, n2, true)) {
                            linkedList.add(new SchachZug(schachFigur, n, n2));
                        }
                    }
                    catch (FigurGeschlagenException figurGeschlagenException) {
                        linkedList.add(new SchachZug(schachFigur, n, n2));
                    }
                    catch (UngueltigerZugException ungueltigerZugException) {
                        // empty catch block
                    }
                    ++n2;
                }
                ++n;
            }
        }
        return linkedList.toArray(new SchachZug[linkedList.size()]);
    }

    boolean istKoenigBedroht(boolean bl) {
        Iterator iterator = this.schachFigurenListe.iterator();
        while (iterator.hasNext()) {
            SchachFigur schachFigur = (SchachFigur)iterator.next();
            if (schachFigur.istWeiss != bl || !(schachFigur instanceof Koenig)) continue;
            this.wurdeSchachGesagt = this.istFigurBedroht(schachFigur, null);
            if (!this.wurdeSchachGesagt) continue;
            if (this.weissAmZug) {
                this.hatSchwarzSchonSchachGesagt = true;
            } else {
                this.hatWeissSchonSchachGesagt = true;
            }
            return this.wurdeSchachGesagt;
        }
        return false;
    }

    boolean istKoenigBedrohtNachZug(SchachFigur schachFigur, int n, int n2, boolean bl) {
        SchachFigur schachFigur2 = null;
        try {
            schachFigur2 = this.getFigurAnPosition(n, n2);
        }
        catch (KeineFigurAufDiesemFeldException keineFigurAufDiesemFeldException) {
            // empty catch block
        }
        int n3 = schachFigur.posX;
        int n4 = schachFigur.posY;
        schachFigur.posX = n;
        schachFigur.posY = n2;
        Iterator iterator = this.schachFigurenListe.iterator();
        boolean bl2 = false;
        while (iterator.hasNext()) {
            SchachFigur schachFigur3 = (SchachFigur)iterator.next();
            if (schachFigur3.istWeiss != bl || !(schachFigur3 instanceof Koenig)) continue;
            this.wurdeSchachGesagt = this.istFigurBedroht(schachFigur3, schachFigur2);
            if (!this.wurdeSchachGesagt) continue;
            bl2 = true;
        }
        schachFigur.posX = n3;
        schachFigur.posY = n4;
        return bl2;
    }

    boolean istDameBedroht(boolean bl) {
        Iterator iterator = this.schachFigurenListe.iterator();
        while (iterator.hasNext()) {
            SchachFigur schachFigur = (SchachFigur)iterator.next();
            if (schachFigur.istWeiss != bl || !(schachFigur instanceof Dame)) continue;
            return this.istFigurBedroht(schachFigur, null);
        }
        return false;
    }

    boolean istWegFreiNach(SchachFigur schachFigur, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        if (schachFigur.posX > n) {
            n3 = -1;
        }
        if (schachFigur.posX < n) {
            n3 = 1;
        }
        if (schachFigur.posY > n2) {
            n4 = -1;
        }
        if (schachFigur.posY < n2) {
            n4 = 1;
        }
        int n5 = schachFigur.posX + n3;
        for (int i = schachFigur.posY + n4; n5 != n || i != n2; n5 += n3, i += n4) {
            if (!this.istFigurAufPosition(n5, i)) continue;
            return false;
        }
        return true;
    }

    boolean istWeissAmZug() {
        return this.weissAmZug;
    }

    boolean istFigurAufPosition(int n, int n2) {
        try {
            this.getFigurAnPosition(n, n2);
            return true;
        }
        catch (KeineFigurAufDiesemFeldException keineFigurAufDiesemFeldException) {
            return false;
        }
    }

    SchachFigur getFigurAnPosition(int n, int n2) throws KeineFigurAufDiesemFeldException {
        Iterator iterator = this.schachFigurenListe.iterator();
        while (iterator.hasNext()) {
            SchachFigur schachFigur = (SchachFigur)iterator.next();
            if (schachFigur.posX != n || schachFigur.posY != n2) continue;
            return schachFigur;
        }
        throw new KeineFigurAufDiesemFeldException();
    }

    SchachFigur getFigurAnPosition(int n, int n2, int n3) throws KeineFigurAufDiesemFeldException {
        Map map = (Map)this.bisherigePositionenHashmapListe.get(n3);
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            SchachFigur schachFigur = (SchachFigur)iterator.next();
            int[] nArray = (int[])map.get(schachFigur);
            if (nArray[0] != n || nArray[1] != n2) continue;
            return schachFigur;
        }
        throw new KeineFigurAufDiesemFeldException();
    }

    public boolean binIchAmZug() {
        if (this.whitePublicKey.equals(PersonalInfo.instance().getPublicKey())) {
            return this.weissAmZug;
        }
        if (this.blackPublicKey.equals(PersonalInfo.instance().getPublicKey())) {
            return !this.weissAmZug;
        }
        return false;
    }

    SchachSpiel getAlteStellung(int n) throws UngueltigerZugException {
        try {
            List list = this.bisherigeZuegeListe.subList(0, n + 1);
            SchachSpiel schachSpiel = new SchachSpiel(this);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                try {
                    SchachZug schachZug = (SchachZug)iterator.next();
                    SchachFigur schachFigur = schachSpiel.getFigurAnPosition(schachZug.getAltX(), schachZug.getAltY());
                    SchachZug schachZug2 = new SchachZug(schachFigur, schachZug.getZielX(), schachZug.getZielY());
                    schachSpiel.fuehreZugAus(schachZug2);
                }
                catch (BesonderesEreignisException besonderesEreignisException) {
                    System.err.println(besonderesEreignisException.getMessage());
                }
            }
            return schachSpiel;
        }
        catch (KeineFigurAufDiesemFeldException keineFigurAufDiesemFeldException) {
            throw new UngueltigerZugException("bad game state");
        }
    }

    void figurenTausch(SchachZug schachZug, SchachFigur schachFigur) throws BesonderesEreignisException {
        schachZug.setBeteiligteFigur(schachFigur);
        this.schachFigurenListe.remove(schachZug.getFigur());
        this.schachFigurenListe.add(schachFigur);
        this.testeSituation();
    }

    private Map erzeugeStellungsMap() {
        Iterator iterator = this.schachFigurenListe.iterator();
        HashMap<SchachFigur, int[]> hashMap = new HashMap<SchachFigur, int[]>();
        while (iterator.hasNext()) {
            SchachFigur schachFigur = (SchachFigur)iterator.next();
            hashMap.put(schachFigur, new int[]{schachFigur.posX, schachFigur.posY});
        }
        return hashMap;
    }

    void fuehreZugAus(SchachZug schachZug) throws UngueltigerZugException, BesonderesEreignisException {
        this.warDameVorherImSchach = this.istDameBedroht(!this.weissAmZug);
        try {
            if (schachZug.istRochade()) {
                Turm turm = ((Koenig)schachZug.getFigur()).getTurmZurRochade(schachZug.getZielX(), schachZug.getZielY());
                schachZug.getFigur().zieheNach(schachZug.getZielX(), schachZug.getZielY());
                turm.posX = turm.posX < schachZug.getZielX() ? schachZug.getZielX() + 1 : schachZug.getZielX() - 1;
            } else {
                schachZug.getFigur().zieheNach(schachZug.getZielX(), schachZug.getZielY());
                this.letzterZugWarBauernEroeffnung = schachZug.istBauernEroeffnung();
            }
        }
        catch (FigurGeschlagenException figurGeschlagenException) {
            this.schachFigurenListe.remove(figurGeschlagenException.getGeschlageneFigur());
        }
        this.bisherigeZuegeListe.add(schachZug);
        if (schachZug.istFigurUmwandlung()) {
            this.weissAmZug = !this.weissAmZug;
            schachZug.setBesonderesEreignis(4);
            if (schachZug.getBeteiligteFigur() == null) {
                throw new BesonderesEreignisException(4, schachZug);
            }
            this.figurenTausch(schachZug, schachZug.getBeteiligteFigur());
            return;
        }
        this.weissAmZug = !this.weissAmZug;
        this.testeSituation();
    }

    void testeSituation() throws BesonderesEreignisException {
        this.bisherigePositionenHashmapListe.add(this.erzeugeStellungsMap());
        this.fireIntervalAdded(this, this.bisherigeZuegeListe.size(), this.bisherigeZuegeListe.size());
        if (this.istKoenigBedroht(this.weissAmZug)) {
            SchachZug[] schachZugArray = this.getMoeglicheZuege();
            System.err.println("es gibt noch " + schachZugArray.length + " moegliche zuege");
            if (schachZugArray.length == 0) {
                this.getLetztenZug().setBesonderesEreignis(2);
                throw new BesonderesEreignisException(2, this.getLetztenZug());
            }
            this.getLetztenZug().setBesonderesEreignis(0);
            throw new BesonderesEreignisException(0, this.getLetztenZug());
        }
        if (this.getMoeglicheZuege().length == 0) {
            this.getLetztenZug().setBesonderesEreignis(1);
            throw new BesonderesEreignisException(1, this.getLetztenZug());
        }
        if (this.istDameBedroht(this.weissAmZug) && !this.warDameVorherImSchach) {
            this.getLetztenZug().setBesonderesEreignis(3);
            throw new BesonderesEreignisException(3, this.getLetztenZug());
        }
    }
}

