/*
 * Decompiled with CFR 0.152.
 */
package freenetmessageboard.schach;

import freenetmessageboard.core.PersonalInfo;
import freenetmessageboard.schach.SchachBrett;
import freenetmessageboard.schach.SchachSpiel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SchachPanel
extends JPanel {
    BorderLayout mainBorderLayout = new BorderLayout();
    JScrollPane bisherigeZuegeScrollPane = new JScrollPane();
    JList bisherigeZuegeList;
    JLabel statusLabel = new JLabel();
    JPanel mainPanel = new JPanel();
    SchachBrett schachBrett1 = new SchachBrett();
    BorderLayout mainPanelBorderLayout = new BorderLayout();
    JPanel blackMessagePanel = new JPanel();
    BorderLayout blackMessagePanelBorderLayout = new BorderLayout();
    JLabel blackNickLabel = new JLabel();
    JTextField blackMessageTextField = new JTextField();
    JPanel whiteMessagePanel = new JPanel();
    BorderLayout whiteMessagePanelBorderLayout = new BorderLayout();
    JTextField whiteMessageTextField = new JTextField();
    JLabel whiteNickLabel = new JLabel();

    public SchachPanel(SchachSpiel schachSpiel) {
        this.schachBrett1 = new SchachBrett(schachSpiel);
        this.bisherigeZuegeList = new JList(schachSpiel);
        this.bisherigeZuegeScrollPane = new JScrollPane(this.bisherigeZuegeList);
        this.bisherigeZuegeList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                SchachPanel.this.bisherigeZuegeList_valueChanged(listSelectionEvent);
            }
        });
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void bisherigeZuegeList_valueChanged(ListSelectionEvent listSelectionEvent) {
        int n = this.bisherigeZuegeList.getSelectedIndex();
        if (n != -1) {
            this.schachBrett1.zeigeAlteStellungAn(n);
            this.schachBrett1.repaint();
        }
    }

    public SchachPanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void valide() {
        super.validate();
        this.bisherigeZuegeList.setVisibleRowCount(5);
    }

    private void jbInit() throws Exception {
        this.setLayout(this.mainBorderLayout);
        this.bisherigeZuegeScrollPane.setPreferredSize(new Dimension(190, 50));
        this.statusLabel.setText("");
        this.mainPanel.setLayout(this.mainPanelBorderLayout);
        this.blackMessagePanel.setLayout(this.blackMessagePanelBorderLayout);
        this.blackNickLabel.setBackground(Color.black);
        this.blackNickLabel.setForeground(Color.white);
        this.blackNickLabel.setOpaque(true);
        this.blackNickLabel.setText(this.schachBrett1.blackNick + ": ");
        this.blackMessageTextField.setBackground(Color.black);
        this.blackMessageTextField.setForeground(Color.white);
        this.blackMessageTextField.setEditable(false);
        this.blackMessageTextField.setText(this.schachBrett1.getSchachSpiel().blackMessage);
        this.whiteMessageTextField.setText(this.schachBrett1.getSchachSpiel().whiteMessage);
        this.whiteMessagePanel.setLayout(this.whiteMessagePanelBorderLayout);
        this.whiteMessageTextField.setBackground(Color.white);
        this.whiteMessageTextField.setEditable(false);
        this.whiteNickLabel.setBackground(Color.white);
        this.whiteNickLabel.setForeground(Color.darkGray);
        this.whiteNickLabel.setOpaque(true);
        this.whiteNickLabel.setText(this.schachBrett1.whiteNick + ": ");
        this.add((Component)this.bisherigeZuegeScrollPane, "East");
        this.add((Component)this.statusLabel, "South");
        this.add((Component)this.mainPanel, "Center");
        this.mainPanel.add((Component)this.schachBrett1, "Center");
        if (this.schachBrett1.getSchachSpiel().getBlackPublicKey().equals(PersonalInfo.instance().getPublicKey())) {
            this.mainPanel.add((Component)this.blackMessagePanel, "South");
            this.blackMessageTextField.setEditable(true);
            this.schachBrett1.reverseView();
        } else {
            this.mainPanel.add((Component)this.blackMessagePanel, "North");
            this.whiteMessageTextField.setEditable(true);
        }
        this.blackMessagePanel.add((Component)this.blackMessageTextField, "Center");
        this.blackMessagePanel.add((Component)this.blackNickLabel, "West");
        if (this.schachBrett1.getSchachSpiel().getBlackPublicKey().equals(PersonalInfo.instance().getPublicKey())) {
            this.mainPanel.add((Component)this.whiteMessagePanel, "North");
        } else {
            this.mainPanel.add((Component)this.whiteMessagePanel, "South");
        }
        this.whiteMessagePanel.add((Component)this.whiteMessageTextField, "Center");
        this.whiteMessagePanel.add((Component)this.whiteNickLabel, "West");
    }
}

