/*
 * Decompiled with CFR 0.152.
 */
package freenetmessageboard.schach;

import freenetmessageboard.schach.FigurGeschlagenException;
import freenetmessageboard.schach.KeineFigurAufDiesemFeldException;
import freenetmessageboard.schach.SchachSpiel;
import freenetmessageboard.schach.UngueltigerZugException;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;

public abstract class SchachFigur {
    protected int posX;
    protected int posY;
    protected static int iconSize = 40;
    protected SchachSpiel schachSpiel;
    protected boolean wurdeBereitsBewegt = false;
    protected boolean istWeiss;

    public SchachFigur(SchachSpiel schachSpiel, boolean bl, int n, int n2) {
        this.posX = n;
        this.posY = n2;
        this.schachSpiel = schachSpiel;
        this.istWeiss = bl;
    }

    public String toString() {
        return this.getName();
    }

    public abstract String getName();

    public boolean hatGleicheFarbeWie(SchachFigur schachFigur) {
        return this.istWeiss == schachFigur.istWeiss;
    }

    public void paint(Graphics graphics, Point point) {
        if (this.istWeiss) {
            graphics.setColor(Color.white);
        } else {
            graphics.setColor(Color.black);
        }
        graphics.setFont(new Font("SansSerif", 1, 14));
    }

    public abstract Image getImage();

    public boolean kannZiehen() {
        return this.istWeiss == this.schachSpiel.istWeissAmZug();
    }

    public abstract String getKuerzel();

    public boolean zugMoeglich(int n, int n2, boolean bl) throws UngueltigerZugException, FigurGeschlagenException {
        try {
            SchachFigur schachFigur = this.schachSpiel.getFigurAnPosition(n, n2);
            if (this.hatGleicheFarbeWie(schachFigur)) {
                throw new UngueltigerZugException("you mustn't move to a field occupied by your " + schachFigur.getName());
            }
            if (bl && this.testeObSchachEntstehenW\u00fcrde(n, n2)) {
                throw new UngueltigerZugException("this move would result in a checkmate");
            }
            throw new FigurGeschlagenException(schachFigur);
        }
        catch (KeineFigurAufDiesemFeldException keineFigurAufDiesemFeldException) {
            if (bl && this.testeObSchachEntstehenW\u00fcrde(n, n2)) {
                throw new UngueltigerZugException("this move would result in a checkmate");
            }
            return true;
        }
    }

    private boolean testeObSchachEntstehenW\u00fcrde(int n, int n2) {
        return this.schachSpiel.istKoenigBedrohtNachZug(this, n, n2, this.schachSpiel.istWeissAmZug());
    }

    public void zieheNach(int n, int n2) throws UngueltigerZugException, FigurGeschlagenException {
        try {
            if (this.zugMoeglich(n, n2, true)) {
                this.posX = n;
                this.posY = n2;
                this.wurdeBereitsBewegt = true;
            }
        }
        catch (FigurGeschlagenException figurGeschlagenException) {
            this.posX = n;
            this.posY = n2;
            this.wurdeBereitsBewegt = true;
            throw figurGeschlagenException;
        }
    }
}

