/*
 * Decompiled with CFR 0.152.
 */
package freenetmessageboard.schach;

import freenetmessageboard.core.ChessMessage;
import freenetmessageboard.core.ContactList;
import freenetmessageboard.core.Message;
import freenetmessageboard.core.MessageGateway;
import freenetmessageboard.core.PersonalInfo;
import freenetmessageboard.schach.BesonderesEreignisException;
import freenetmessageboard.schach.Dame;
import freenetmessageboard.schach.FigurGeschlagenException;
import freenetmessageboard.schach.KeineFigurAufDiesemFeldException;
import freenetmessageboard.schach.Laeufer;
import freenetmessageboard.schach.SchachFigur;
import freenetmessageboard.schach.SchachPanel;
import freenetmessageboard.schach.SchachSpiel;
import freenetmessageboard.schach.SchachZug;
import freenetmessageboard.schach.Springer;
import freenetmessageboard.schach.Turm;
import freenetmessageboard.schach.UngueltigerZugException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class SchachBrett
extends JPanel {
    private SchachSpiel spiel;
    private int zeilenHoehe;
    private int spaltenBreite;
    private boolean umgekehrteSicht = false;
    private static Color ausgewaehlteFarbe = new Color(188, 188, 245);
    private static Color gueltigerZugFarbe = new Color(187, 247, 201);
    private static Color ungueltigerZugFarbe = new Color(243, 119, 105);
    private boolean figurAusgewaehlt = false;
    private boolean zielAusgewaehlt = false;
    private boolean zielMoeglich = false;
    private boolean zeigeAlteStellungAn = false;
    private int indexDerAltenStellung;
    String whiteNick;
    String blackNick;
    private int zielX;
    private int zielY;
    private SchachFigur ausgewaehlteFigur;
    private int ausgewaehltesY = -1;

    public SchachBrett(SchachSpiel schachSpiel) {
        this();
        this.spiel = schachSpiel;
        this.whiteNick = ContactList.instance().getNicknameOfPublicKey(this.spiel.getWhitePublicKey());
        this.blackNick = ContactList.instance().getNicknameOfPublicKey(this.spiel.getBlackPublicKey());
    }

    void reverseView() {
        this.umgekehrteSicht = !this.umgekehrteSicht;
    }

    private Point getSpielFeldPosition(int n, int n2) {
        if (!this.umgekehrteSicht) {
            return new Point(n2 * this.spaltenBreite, (7 - n) * this.zeilenHoehe);
        }
        return new Point((7 - n2) * this.spaltenBreite, n * this.zeilenHoehe);
    }

    private int[] getIndicesVon(Point point) {
        if (!this.umgekehrteSicht) {
            return new int[]{point.x / this.spaltenBreite, 7 - point.y / this.zeilenHoehe};
        }
        return new int[]{7 - point.x / this.spaltenBreite, point.y / this.zeilenHoehe};
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.zeilenHoehe = this.getSize().height / 8;
        this.spaltenBreite = this.getSize().width / 8;
        if (this.zeilenHoehe > this.spaltenBreite) {
            this.zeilenHoehe = this.spaltenBreite;
        } else {
            this.spaltenBreite = this.zeilenHoehe;
        }
        SchachSpiel schachSpiel = this.spiel;
        int n = 0;
        while (n < 8) {
            int n2 = 0;
            while (n2 < 8) {
                Point point = this.getSpielFeldPosition(n, n2);
                if ((n + n2) % 2 == 0) {
                    graphics.setColor(Color.lightGray);
                } else {
                    graphics.setColor(Color.gray);
                }
                if (this.figurAusgewaehlt && n2 == this.ausgewaehlteFigur.posX && n == this.ausgewaehlteFigur.posY) {
                    graphics.setColor(ausgewaehlteFarbe);
                }
                if (this.zielAusgewaehlt && this.zielX == n2 && this.zielY == n) {
                    if (this.zielMoeglich) {
                        graphics.setColor(gueltigerZugFarbe);
                    } else {
                        graphics.setColor(ungueltigerZugFarbe);
                    }
                }
                graphics.fillRect(point.x, point.y, this.spaltenBreite, this.zeilenHoehe);
                if (this.spiel != null) {
                    try {
                        SchachFigur schachFigur = this.zeigeAlteStellungAn ? schachSpiel.getFigurAnPosition(n2, n, this.indexDerAltenStellung) : schachSpiel.getFigurAnPosition(n2, n);
                        if (schachFigur.istWeiss) {
                            graphics.setColor(Color.white);
                        } else {
                            graphics.setColor(Color.black);
                        }
                        graphics.drawImage(schachFigur.getImage(), point.x + this.spaltenBreite / 2 - SchachFigur.iconSize / 2, point.y + this.zeilenHoehe / 2 - SchachFigur.iconSize / 2, this);
                    }
                    catch (KeineFigurAufDiesemFeldException keineFigurAufDiesemFeldException) {
                        // empty catch block
                    }
                }
                ++n2;
            }
            ++n;
        }
    }

    public SchachBrett() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent mouseEvent) {
                SchachBrett.this.this_mouseDragged(mouseEvent);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                SchachBrett.this.this_mousePressed(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                SchachBrett.this.this_mouseReleased(mouseEvent);
            }
        });
    }

    void this_mousePressed(MouseEvent mouseEvent) {
        if (this.zeigeAlteStellungAn) {
            this.zeigeAktuelleStellungAn();
            return;
        }
        if (!this.spiel.binIchAmZug()) {
            return;
        }
        int[] nArray = this.getIndicesVon(mouseEvent.getPoint());
        int n = nArray[0];
        int n2 = nArray[1];
        if (n < 0 || n > 7 || n2 < 0 || n2 > 7) {
            this.figurAusgewaehlt = false;
        }
        try {
            this.ausgewaehlteFigur = this.spiel.getFigurAnPosition(n, n2);
            if (this.ausgewaehlteFigur.kannZiehen()) {
                this.setCursor(Cursor.getPredefinedCursor(13));
                this.figurAusgewaehlt = true;
                this.repaint();
            }
        }
        catch (KeineFigurAufDiesemFeldException keineFigurAufDiesemFeldException) {
            System.err.println("keine figur auf feld " + n + ", " + n2);
        }
    }

    private void zeigeBesonderesEreignisAn(BesonderesEreignisException besonderesEreignisException) {
        if (besonderesEreignisException.getEreignis() == 0) {
            this.getSchachPanel().statusLabel.setText("check!");
        }
        if (besonderesEreignisException.getEreignis() == 2) {
            this.getSchachPanel().statusLabel.setText("checkmate");
        }
        if (besonderesEreignisException.getEreignis() == 3) {
            this.getSchachPanel().statusLabel.setText("gardez!");
        }
    }

    SchachSpiel getSchachSpiel() {
        return this.spiel;
    }

    private void sendMove() {
        this.spiel.whiteMessage = this.getSchachPanel().whiteMessageTextField.getText();
        this.spiel.blackMessage = this.getSchachPanel().blackMessageTextField.getText();
        ChessMessage chessMessage = new ChessMessage(this.spiel);
        MessageGateway.instance().sendMessageOnPersonalChannel(chessMessage);
    }

    void this_mouseReleased(MouseEvent mouseEvent) {
        if (!this.spiel.binIchAmZug()) {
            return;
        }
        int[] nArray = this.getIndicesVon(mouseEvent.getPoint());
        int n = nArray[0];
        int n2 = nArray[1];
        if (n < 0 || n > 7 || n2 < 0 || n2 > 7) {
            this.figurAusgewaehlt = false;
        }
        SchachZug schachZug = new SchachZug(this.ausgewaehlteFigur, n, n2);
        if (this.figurAusgewaehlt && this.zielAusgewaehlt) {
            try {
                this.spiel.fuehreZugAus(schachZug);
                if (this.spiel.istWeissAmZug()) {
                    this.getSchachPanel().statusLabel.setText("it's " + this.whiteNick + "'s turn now, waiting for his next move...");
                } else {
                    this.getSchachPanel().statusLabel.setText("it's " + this.blackNick + "'s turn, waiting for his next move...");
                }
                this.sendMove();
            }
            catch (UngueltigerZugException ungueltigerZugException) {
                this.getSchachPanel().statusLabel.setText(ungueltigerZugException.getMessage());
            }
            catch (BesonderesEreignisException besonderesEreignisException) {
                if (besonderesEreignisException.getEreignis() == 4) {
                    try {
                        this.waehleNeueFigur(besonderesEreignisException.getSpielZug());
                    }
                    catch (BesonderesEreignisException besonderesEreignisException2) {
                        this.zeigeBesonderesEreignisAn(besonderesEreignisException2);
                    }
                }
                this.zeigeBesonderesEreignisAn(besonderesEreignisException);
                this.sendMove();
            }
        }
        this.setCursor(Cursor.getDefaultCursor());
        this.figurAusgewaehlt = false;
        this.zielAusgewaehlt = false;
        this.repaint();
    }

    void zeigeAlteStellungAn(int n) {
        this.getSchachPanel().statusLabel.setText("viewing old gamestate, click board to continue playing...");
        this.zeigeAlteStellungAn = true;
        this.indexDerAltenStellung = n;
    }

    void zeigeAktuelleStellungAn() {
        this.zeigeAlteStellungAn = false;
        this.zeigeAnWerDranIst();
        this.getSchachPanel().bisherigeZuegeList.setSelectedIndices(new int[0]);
    }

    void zeigeAnWerDranIst() {
        if (this.spiel.binIchAmZug()) {
            this.getSchachPanel().statusLabel.setText("it's your turn, now...");
        } else if (this.spiel.istWeissAmZug()) {
            this.getSchachPanel().statusLabel.setText("it's " + this.whiteNick + "'s turn now, waiting for his next move...");
        } else {
            this.getSchachPanel().statusLabel.setText("it's " + this.blackNick + "'s turn, waiting for his next move...");
        }
    }

    private SchachPanel getSchachPanel() {
        Container container = this.getParent();
        while (!(container instanceof SchachPanel)) {
            container = container.getParent();
        }
        return (SchachPanel)container;
    }

    void autoPlay() {
        Object object;
        int n = 0;
        while (((SchachZug[])(object = this.spiel.getMoeglicheZuege())).length != 0 && n != 250) {
            block8: {
                ++n;
                int n2 = (int)(Math.random() * (double)((SchachZug[])object).length);
                try {
                    this.spiel.fuehreZugAus(object[n2]);
                }
                catch (UngueltigerZugException ungueltigerZugException) {
                    this.getSchachPanel().statusLabel.setText(ungueltigerZugException.getMessage());
                }
                catch (BesonderesEreignisException besonderesEreignisException) {
                    if (besonderesEreignisException.getEreignis() != 4) break block8;
                    try {
                        int n3 = (int)(Math.random() * 4.0);
                        this.spiel.figurenTausch((SchachZug)object[n2], this.getMoeglicheFigurenZumTausch((SchachZug)object[n2])[n3]);
                    }
                    catch (BesonderesEreignisException besonderesEreignisException2) {
                        this.zeigeBesonderesEreignisAn(besonderesEreignisException2);
                    }
                }
            }
            this.getSchachPanel().repaint();
        }
        try {
            object = new ChessMessage(this.getSchachSpiel());
            ((Message)object).setOriginalUri("SSK@" + PersonalInfo.instance().getPublicKey() + "/chess");
            String string = ((Message)object).getString();
            ChessMessage chessMessage = new ChessMessage(string);
            SchachSpiel schachSpiel = chessMessage.getSchachSpiel();
            JFrame jFrame = new JFrame("game copy");
            SchachPanel schachPanel = new SchachPanel(schachSpiel);
            jFrame.getContentPane().add((Component)schachPanel, "Center");
            jFrame.setSize(545, 450);
            jFrame.setVisible(true);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private SchachFigur[] getMoeglicheFigurenZumTausch(SchachZug schachZug) {
        SchachFigur[] schachFigurArray = new SchachFigur[]{new Dame(this.spiel, schachZug.getFigur().istWeiss, schachZug.getFigur().posX, schachZug.getFigur().posY), new Turm(this.spiel, schachZug.getFigur().istWeiss, schachZug.getFigur().posX, schachZug.getFigur().posY), new Laeufer(this.spiel, schachZug.getFigur().istWeiss, schachZug.getFigur().posX, schachZug.getFigur().posY), new Springer(this.spiel, schachZug.getFigur().istWeiss, schachZug.getFigur().posX, schachZug.getFigur().posY)};
        return schachFigurArray;
    }

    private void waehleNeueFigur(SchachZug schachZug) throws BesonderesEreignisException {
        Object[] objectArray = this.getMoeglicheFigurenZumTausch(schachZug);
        int n = JOptionPane.showOptionDialog(this, "choose the piece you want to get", "choose", -1, 3, new ImageIcon(this.getClass().getResource("dameweiss.gif")), objectArray, objectArray[0]);
        this.spiel.figurenTausch(schachZug, (SchachFigur)objectArray[n]);
    }

    void this_mouseDragged(MouseEvent mouseEvent) {
        if (!this.spiel.binIchAmZug()) {
            return;
        }
        if (this.figurAusgewaehlt) {
            int[] nArray = this.getIndicesVon(mouseEvent.getPoint());
            int n = nArray[0];
            int n2 = nArray[1];
            if (n < 0 || n > 7 || n2 < 0 || n2 > 7) {
                this.figurAusgewaehlt = false;
            }
            if (this.ausgewaehlteFigur.posX != n || this.ausgewaehlteFigur.posY != n2) {
                this.zielX = n;
                this.zielY = n2;
                this.zielAusgewaehlt = true;
                try {
                    this.zielMoeglich = this.ausgewaehlteFigur.zugMoeglich(n, n2, true);
                }
                catch (UngueltigerZugException ungueltigerZugException) {
                    this.zielMoeglich = false;
                }
                catch (FigurGeschlagenException figurGeschlagenException) {
                    this.zielMoeglich = true;
                }
            } else {
                this.zielAusgewaehlt = false;
            }
            this.repaint();
        }
    }
}

