/*
 * Decompiled with CFR 0.152.
 */
package freenetmessageboard.schach;

import freenetmessageboard.schach.FigurGeschlagenException;
import freenetmessageboard.schach.KeineFigurAufDiesemFeldException;
import freenetmessageboard.schach.SchachFigur;
import freenetmessageboard.schach.SchachSpiel;
import freenetmessageboard.schach.Turm;
import freenetmessageboard.schach.UngueltigerZugException;
import java.awt.Image;
import javax.swing.ImageIcon;

class Koenig
extends SchachFigur {
    private static Image weissesIcon = new ImageIcon((class$freenetmessageboard$schach$Bauer == null ? (class$freenetmessageboard$schach$Bauer = Koenig.class$("freenetmessageboard.schach.Bauer")) : class$freenetmessageboard$schach$Bauer).getResource("koenigweiss.gif")).getImage().getScaledInstance(SchachFigur.iconSize, SchachFigur.iconSize, 4);
    private static Image schwarzesIcon = new ImageIcon((class$freenetmessageboard$schach$Bauer == null ? (class$freenetmessageboard$schach$Bauer = Koenig.class$("freenetmessageboard.schach.Bauer")) : class$freenetmessageboard$schach$Bauer).getResource("koenigschwarz.gif")).getImage().getScaledInstance(SchachFigur.iconSize, SchachFigur.iconSize, 4);
    static String name = "King";
    static /* synthetic */ Class class$freenetmessageboard$schach$Bauer;

    public Koenig(SchachSpiel schachSpiel, boolean bl, int n, int n2) {
        super(schachSpiel, bl, n, n2);
    }

    public String getName() {
        return name;
    }

    public String getKuerzel() {
        return "K";
    }

    public Image getImage() {
        if (this.istWeiss) {
            return weissesIcon;
        }
        return schwarzesIcon;
    }

    Turm getTurmZurRochade(int n, int n2) throws UngueltigerZugException {
        int n3;
        int n4;
        if (this.wurdeBereitsBewegt) {
            throw new UngueltigerZugException("Castling is only possible if the king hasn't moved before");
        }
        if (n != 2 && n != 6) {
            throw new UngueltigerZugException("Castling is only possible to certain positions");
        }
        if (this.schachSpiel.istKoenigBedroht(this.istWeiss) || this.schachSpiel.istKoenigBedrohtNachZug(this, this.posX + (n - this.posX) / 2, n2, this.istWeiss)) {
            throw new UngueltigerZugException("Castline is not possible in check situations.");
        }
        if (this.istWeiss) {
            n4 = 0;
            n3 = n == 2 ? 0 : 7;
        } else {
            n4 = 7;
            n3 = n == 2 ? 0 : 7;
        }
        try {
            SchachFigur schachFigur = this.schachSpiel.getFigurAnPosition(n3, n4);
            if (schachFigur.wurdeBereitsBewegt || !(schachFigur instanceof Turm)) {
                throw new UngueltigerZugException("Castling is only possible if the Rook's haven't moved");
            }
            if (!this.schachSpiel.istWegFreiNach(this, schachFigur.posX, schachFigur.posY)) {
                throw new UngueltigerZugException("Castling is only possible if there is nothing in between");
            }
            return (Turm)schachFigur;
        }
        catch (KeineFigurAufDiesemFeldException keineFigurAufDiesemFeldException) {
            throw new UngueltigerZugException("Castling is only possible if the Rook's haven't moved");
        }
    }

    public boolean zugMoeglich(int n, int n2, boolean bl) throws UngueltigerZugException, FigurGeschlagenException {
        if (Math.abs(this.posX - n) > 1 && Math.abs(this.posY - n2) == 0) {
            Turm turm = this.getTurmZurRochade(n, n2);
            return super.zugMoeglich(n, n2, bl);
        }
        if (Math.abs(this.posX - n) > 1 || Math.abs(this.posY - n2) > 1) {
            throw new UngueltigerZugException("the king mustn't move more than one field in any direction");
        }
        return super.zugMoeglich(n, n2, bl);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

