/*
 * Decompiled with CFR 0.152.
 */
package freenetmessageboard.schach;

import freenetmessageboard.schach.FigurGeschlagenException;
import freenetmessageboard.schach.KeineFigurAufDiesemFeldException;
import freenetmessageboard.schach.SchachFigur;
import freenetmessageboard.schach.SchachSpiel;
import freenetmessageboard.schach.UngueltigerZugException;
import java.awt.Image;
import javax.swing.ImageIcon;

class Bauer
extends SchachFigur {
    static String name = "Pawn";
    boolean istAlsLetztesZweiZuegeGegangen = false;
    private static Image weissesIcon = new ImageIcon((class$freenetmessageboard$schach$Bauer == null ? (class$freenetmessageboard$schach$Bauer = Bauer.class$("freenetmessageboard.schach.Bauer")) : class$freenetmessageboard$schach$Bauer).getResource("bauerweiss.gif")).getImage().getScaledInstance(SchachFigur.iconSize, SchachFigur.iconSize, 4);
    private static Image schwarzesIcon = new ImageIcon((class$freenetmessageboard$schach$Bauer == null ? (class$freenetmessageboard$schach$Bauer = Bauer.class$("freenetmessageboard.schach.Bauer")) : class$freenetmessageboard$schach$Bauer).getResource("bauerschwarz.gif")).getImage().getScaledInstance(SchachFigur.iconSize, SchachFigur.iconSize, 4);
    static /* synthetic */ Class class$freenetmessageboard$schach$Bauer;

    public Bauer(SchachSpiel schachSpiel, boolean bl, int n, int n2) {
        super(schachSpiel, bl, n, n2);
    }

    public String getName() {
        return name;
    }

    public Image getImage() {
        if (this.istWeiss) {
            return weissesIcon;
        }
        return schwarzesIcon;
    }

    public String getKuerzel() {
        return "P";
    }

    public void zieheNach(int n, int n2) throws UngueltigerZugException, FigurGeschlagenException {
        int n3 = this.posY;
        super.zieheNach(n, n2);
        this.istAlsLetztesZweiZuegeGegangen = Math.abs(n3 - n2) == 2;
    }

    public boolean zugMoeglich(int n, int n2, boolean bl) throws UngueltigerZugException, FigurGeschlagenException {
        int n3 = n2 - this.posY;
        int n4 = n - this.posX;
        if (this.istWeiss && n3 <= 0 || !this.istWeiss && n3 >= 0) {
            throw new UngueltigerZugException("the pawn can only move forward");
        }
        if (Math.abs(n4) >= 2 || Math.abs(n3) > 2) {
            throw new UngueltigerZugException("the pawn cannot move so far");
        }
        if (Math.abs(n3) == 2 && (this.wurdeBereitsBewegt || Math.abs(n4) != 0)) {
            throw new UngueltigerZugException("the pawn can only move two steps ahead on his first move...");
        }
        if (n4 == 0) {
            if (this.schachSpiel.istFigurAufPosition(n, n2)) {
                throw new UngueltigerZugException("the pawn cannot take a piece straight ahead");
            }
        } else if (!this.schachSpiel.istFigurAufPosition(n, n2)) {
            try {
                SchachFigur schachFigur = this.schachSpiel.getFigurAnPosition(n, this.posY);
                if (schachFigur instanceof Bauer) {
                    if (!((Bauer)schachFigur).istAlsLetztesZweiZuegeGegangen) {
                        throw new UngueltigerZugException("cannot take en passante, the pawn didn't move two fields to get there");
                    }
                    if (!this.schachSpiel.getLetztenZug().getFigur().equals(schachFigur)) {
                        throw new UngueltigerZugException("cannot take en passante, only possible instantly");
                    }
                }
            }
            catch (KeineFigurAufDiesemFeldException keineFigurAufDiesemFeldException) {
                throw new UngueltigerZugException("the pawn can only go that way when taking a piece.");
            }
        }
        return super.zugMoeglich(n, n2, bl);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

