/*
 * Decompiled with CFR 0.152.
 */
package freenetmessageboard.gui;

import freenetmessageboard.core.ContactList;
import freenetmessageboard.core.CoreLogger;
import freenetmessageboard.core.MessageGateway;
import freenetmessageboard.core.PersonalInfo;
import freenetmessageboard.core.UserMessage;
import freenetmessageboard.gui.BetaGUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;

public class UserMessagePanel
extends JPanel {
    BorderLayout personalInfoPanelBorderLayout = new BorderLayout();
    JPanel buttonPanel = new JPanel();
    JPanel mainPanel = new JPanel();
    BorderLayout buttonPanelBorderLayout = new BorderLayout();
    BorderLayout mainPanelBorderLayout = new BorderLayout();
    JPanel shortInfosPanel = new JPanel();
    BorderLayout shortInfosPanelBorderLayout = new BorderLayout();
    JPanel shortInfosCaptionPanel = new JPanel();
    GridLayout shortInfosCaptionPanelGridLayout = new GridLayout();
    JPanel shortInfosValuePanel = new JPanel();
    GridLayout shortInfosValuePanelGridLayout = new GridLayout();
    JLabel publicKeyCaptionLabel = new JLabel();
    JLabel nickCaptionLabel = new JLabel();
    JLabel nameCaptionLabel = new JLabel();
    JLabel freesiteUriCaptionLabel = new JLabel();
    JLabel interestsCaptionLabel = new JLabel();
    public JTextField publicKeyTextField = new JTextField();
    public JTextField nickTextField = new JTextField();
    public JTextField nameTextField = new JTextField();
    public JTextField freesiteUriTextField = new JTextField();
    public JTextField interestsTextField = new JTextField();
    JPanel longInfosPanel = new JPanel();
    BorderLayout longInfosPanelBorderLayout = new BorderLayout();
    JPanel longInfosCaptionPanel = new JPanel();
    JPanel longInfosValuePanel = new JPanel();
    GridLayout longInfosValuePanelGridLayout = new GridLayout();
    GridLayout longInfosCaptionPanelGridLayout = new GridLayout();
    public JTextPane descriptionTextArea = new JTextPane();
    public JTextPane messageTextArea = new JTextPane();
    JLabel descriptionCaptionLabel = new JLabel();
    JLabel messageCaptionLabel = new JLabel();
    JScrollPane descriptionScrollPane = new JScrollPane();
    JScrollPane messageScrollPane = new JScrollPane();
    JLabel sourceCaptionLabel = new JLabel();
    JButton sendAnnouncementButton = new JButton();
    JPanel sourcePanel = new JPanel();
    JTextField sourceTextField = new JTextField();
    BorderLayout sourcePanelBorderLayout = new BorderLayout();
    JButton getOriginalButton = new JButton();
    UserMessage userMsg;

    public UserMessagePanel(UserMessage userMessage) {
        this();
        this.publicKeyTextField.setText(userMessage.getPublicKey());
        this.nickTextField.setText(userMessage.getNickName());
        this.nameTextField.setText(userMessage.getName());
        this.descriptionTextArea.setText(userMessage.getDescription());
        this.interestsTextField.setText(userMessage.getInterests());
        this.freesiteUriTextField.setText(userMessage.getFreesiteUri());
        this.messageTextArea.setText(userMessage.getMessage());
        this.sourceTextField.setText(ContactList.instance().getNicknameOfPublicKey(userMessage.getSourceKey()) + " (" + userMessage.getSourceUri() + ")");
        this.userMsg = userMessage;
        if (userMessage.getOriginalPublicKey().equals(userMessage.getSourceKey())) {
            this.getOriginalButton.setEnabled(false);
        } else {
            this.getOriginalButton.setEnabled(true);
        }
        if (userMessage.getOriginalPublicKey().equals(PersonalInfo.instance().getPublicKey())) {
            this.makeEditable();
        }
    }

    void makeEditable() {
        this.nickTextField.setEditable(true);
        this.nameTextField.setEditable(true);
        this.descriptionTextArea.setEditable(true);
        this.interestsTextField.setEditable(true);
        this.freesiteUriTextField.setEditable(true);
        this.messageTextArea.setEditable(true);
        this.sendAnnouncementButton.setEnabled(true);
    }

    public UserMessagePanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.personalInfoPanelBorderLayout);
        this.buttonPanel.setLayout(this.buttonPanelBorderLayout);
        this.mainPanel.setLayout(this.mainPanelBorderLayout);
        this.shortInfosPanel.setLayout(this.shortInfosPanelBorderLayout);
        this.shortInfosCaptionPanel.setLayout(this.shortInfosCaptionPanelGridLayout);
        this.shortInfosValuePanel.setLayout(this.shortInfosValuePanelGridLayout);
        this.publicKeyCaptionLabel.setHorizontalAlignment(0);
        this.publicKeyCaptionLabel.setText("public key:");
        this.shortInfosCaptionPanelGridLayout.setRows(6);
        this.shortInfosCaptionPanelGridLayout.setColumns(1);
        this.nickCaptionLabel.setHorizontalAlignment(0);
        this.nickCaptionLabel.setText("nick:");
        this.nameCaptionLabel.setToolTipText("");
        this.nameCaptionLabel.setHorizontalAlignment(0);
        this.nameCaptionLabel.setText("name:");
        this.freesiteUriCaptionLabel.setHorizontalAlignment(0);
        this.freesiteUriCaptionLabel.setText("freesite uri:");
        this.interestsCaptionLabel.setHorizontalAlignment(0);
        this.interestsCaptionLabel.setText("interests:");
        this.shortInfosValuePanelGridLayout.setRows(6);
        this.shortInfosValuePanelGridLayout.setColumns(1);
        this.longInfosPanel.setLayout(this.longInfosPanelBorderLayout);
        this.longInfosValuePanel.setLayout(this.longInfosValuePanelGridLayout);
        this.longInfosCaptionPanel.setLayout(this.longInfosCaptionPanelGridLayout);
        this.longInfosCaptionPanelGridLayout.setRows(2);
        this.longInfosCaptionPanelGridLayout.setColumns(1);
        this.longInfosValuePanelGridLayout.setRows(2);
        this.longInfosValuePanelGridLayout.setColumns(1);
        this.descriptionTextArea.setBorder(BorderFactory.createLineBorder(Color.black));
        this.descriptionTextArea.setEditable(false);
        this.messageTextArea.setBorder(BorderFactory.createLineBorder(Color.black));
        this.messageTextArea.setEditable(false);
        this.descriptionCaptionLabel.setHorizontalAlignment(0);
        this.descriptionCaptionLabel.setText("description:");
        this.messageCaptionLabel.setHorizontalAlignment(0);
        this.messageCaptionLabel.setText("message:");
        this.shortInfosCaptionPanel.setMinimumSize(new Dimension(80, 120));
        this.shortInfosCaptionPanel.setPreferredSize(new Dimension(80, 120));
        this.longInfosCaptionPanel.setMinimumSize(new Dimension(80, 120));
        this.longInfosCaptionPanel.setPreferredSize(new Dimension(80, 120));
        this.interestsTextField.setEditable(false);
        this.freesiteUriTextField.setEditable(false);
        this.nameTextField.setEditable(false);
        this.nickTextField.setEditable(false);
        this.publicKeyTextField.setEditable(false);
        this.sourceCaptionLabel.setHorizontalAlignment(0);
        this.sourceCaptionLabel.setText("source:");
        this.longInfosPanel.setMinimumSize(new Dimension(103, 40));
        this.longInfosPanel.setPreferredSize(new Dimension(85, 80));
        this.sendAnnouncementButton.setEnabled(false);
        this.sendAnnouncementButton.setFont(new Font("Dialog", 0, 9));
        this.sendAnnouncementButton.setText("send changes on on your personal channel");
        this.sendAnnouncementButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UserMessagePanel.this.sendAnnouncementButton_actionPerformed(actionEvent);
            }
        });
        this.setFont(new Font("Dialog", 0, 9));
        this.sourceTextField.setEditable(false);
        this.sourcePanel.setLayout(this.sourcePanelBorderLayout);
        this.getOriginalButton.setEnabled(false);
        this.getOriginalButton.setFont(new Font("Dialog", 0, 9));
        this.getOriginalButton.setForeground(Color.red);
        this.getOriginalButton.setText("verify");
        this.getOriginalButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UserMessagePanel.this.getOriginalButton_actionPerformed(actionEvent);
            }
        });
        this.add((Component)this.buttonPanel, "South");
        this.buttonPanel.add((Component)this.sendAnnouncementButton, "Center");
        this.add((Component)this.mainPanel, "Center");
        this.mainPanel.add((Component)this.shortInfosPanel, "North");
        this.shortInfosPanel.add((Component)this.shortInfosCaptionPanel, "West");
        this.shortInfosPanel.add((Component)this.shortInfosValuePanel, "Center");
        this.shortInfosCaptionPanel.add((Component)this.publicKeyCaptionLabel, null);
        this.shortInfosCaptionPanel.add((Component)this.nickCaptionLabel, null);
        this.shortInfosCaptionPanel.add((Component)this.nameCaptionLabel, null);
        this.shortInfosCaptionPanel.add((Component)this.freesiteUriCaptionLabel, null);
        this.shortInfosCaptionPanel.add((Component)this.interestsCaptionLabel, null);
        this.shortInfosCaptionPanel.add((Component)this.sourceCaptionLabel, null);
        this.shortInfosValuePanel.add((Component)this.publicKeyTextField, null);
        this.shortInfosValuePanel.add((Component)this.nickTextField, null);
        this.shortInfosValuePanel.add((Component)this.nameTextField, null);
        this.shortInfosValuePanel.add((Component)this.freesiteUriTextField, null);
        this.shortInfosValuePanel.add((Component)this.interestsTextField, null);
        this.mainPanel.add((Component)this.longInfosPanel, "Center");
        this.longInfosPanel.add((Component)this.longInfosCaptionPanel, "West");
        this.longInfosPanel.add((Component)this.longInfosValuePanel, "Center");
        this.longInfosValuePanel.add((Component)this.descriptionScrollPane, null);
        this.descriptionScrollPane.getViewport().add((Component)this.descriptionTextArea, null);
        this.longInfosCaptionPanel.add((Component)this.descriptionCaptionLabel, null);
        this.longInfosCaptionPanel.add((Component)this.messageCaptionLabel, null);
        this.longInfosValuePanel.add((Component)this.messageScrollPane, null);
        this.messageScrollPane.getViewport().add((Component)this.messageTextArea, null);
        this.shortInfosValuePanel.add((Component)this.sourcePanel, null);
        this.sourcePanel.add((Component)this.sourceTextField, "Center");
        this.sourcePanel.add((Component)this.getOriginalButton, "East");
    }

    void sendAnnouncementButton_actionPerformed(ActionEvent actionEvent) {
        UserMessage userMessage = new UserMessage(this.publicKeyTextField.getText(), this.nickTextField.getText(), this.nameTextField.getText(), this.interestsTextField.getText(), this.descriptionTextArea.getText(), this.freesiteUriTextField.getText(), "noicon", this.messageTextArea.getText());
        MessageGateway.instance().sendMessageOnPersonalChannel(userMessage);
        PersonalInfo.instance().updateInfoFromUserMessage(userMessage);
        try {
            PersonalInfo.instance().saveToDisk();
        }
        catch (IOException iOException) {
            CoreLogger.log("failed to save updated personal info to disk", 0);
        }
    }

    void getOriginalButton_actionPerformed(ActionEvent actionEvent) {
        BetaGUI.instance().verifyMessage(this.userMsg);
    }
}

