/*
 * Decompiled with CFR 0.152.
 */
package freenetmessageboard.gui;

import freenetmessageboard.core.ContactList;
import freenetmessageboard.core.CoreLogger;
import freenetmessageboard.core.Message;
import freenetmessageboard.core.MessageGateway;
import freenetmessageboard.core.MessageNotReceivedException;
import freenetmessageboard.core.PersonalInfo;
import freenetmessageboard.core.UserCommentMessage;
import freenetmessageboard.gui.BetaGUI;
import freenetmessageboard.gui.ColorsAndIcons;
import freenetmessageboard.gui.ContactInformationPanel;
import freenetmessageboard.gui.MessageVerificationPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;

public class UserCommentMessagePanel
extends JPanel {
    BorderLayout mainBorderLayout = new BorderLayout();
    JPanel buttonPanel = new JPanel();
    JPanel commentPanel = new JPanel();
    BorderLayout commentPanelBorderLayout = new BorderLayout();
    JPanel commentCaptionsPanel = new JPanel();
    JPanel commentValuesPanel = new JPanel();
    GridLayout commentCaptionsPanelGridLayout = new GridLayout();
    GridLayout commentValuesPanelGridLayout = new GridLayout();
    JLabel publicKeyCaptionLabel = new JLabel();
    JLabel ratingCaptionLabel = new JLabel();
    JLabel commentCaption = new JLabel();
    JTextField publicKeyTextField = new JTextField();
    JPanel ratingPanel = new JPanel();
    GridLayout ratingPanelGridLayout = new GridLayout();
    JLabel reasonCaptionLabel = new JLabel();
    JTextField reasonTextField = new JTextField();
    JButton sendCommentButton = new JButton();
    BorderLayout buttonPanelBorderLayout = new BorderLayout();
    private String commentedPublicKey;
    JLabel dateCaptionLabel = new JLabel();
    JLabel sourceCaptionLabel = new JLabel();
    JComboBox ratingComboBox = new JComboBox();
    JLabel ratingLabel = new JLabel();
    JScrollPane commentScrollPane = new JScrollPane();
    JTextPane commentTextPane = new JTextPane();
    JPanel sourcePanel = new JPanel();
    JTextField sourceTextfield = new JTextField();
    JTextField dateTextField = new JTextField();
    BorderLayout sourcePanelBorderLayout = new BorderLayout();
    JButton getOriginalButton = new JButton();
    private UserCommentMessage userCommentMessage;

    public UserCommentMessagePanel(UserCommentMessage userCommentMessage) {
        this();
        this.userCommentMessage = userCommentMessage;
        if (this.userCommentMessage != null) {
            if (this.userCommentMessage.getOriginalPublicKey().equals(this.userCommentMessage.getSourceKey())) {
                this.getOriginalButton.setEnabled(false);
            } else {
                this.getOriginalButton.setEnabled(true);
            }
        }
        this.publicKeyTextField.setText(userCommentMessage.getOriginalPublicKey());
        this.commentedPublicKey = userCommentMessage.getUserPublicKey();
        this.ratingLabel.setText(userCommentMessage.getRating());
        this.ratingLabel.setBackground(ColorsAndIcons.getColorOfRating(userCommentMessage.getRating()));
        this.reasonTextField.setText(userCommentMessage.getReason());
        this.commentTextPane.setText(userCommentMessage.getComment());
        this.dateTextField.setText(userCommentMessage.getDate());
        this.sourceTextfield.setText(userCommentMessage.getSourceUri());
    }

    public UserCommentMessagePanel(UserCommentMessage userCommentMessage, boolean bl) {
        this(userCommentMessage);
        this.commentedPublicKey = userCommentMessage.getUserPublicKey();
        if (bl) {
            this.makePanelEditable();
        }
        this.ratingComboBox.setSelectedItem(userCommentMessage.getRating());
    }

    private void makePanelEditable() {
        this.reasonTextField.setEditable(true);
        this.commentTextPane.setEditable(true);
        this.ratingComboBox.setEnabled(true);
        this.sendCommentButton.setEnabled(true);
        this.publicKeyTextField.setText(PersonalInfo.instance().getPublicKey());
        this.ratingComboBox.addItem("GOOD");
        this.ratingComboBox.addItem("NEUTRAL");
        this.ratingComboBox.addItem("EVIL");
        this.ratingComboBox.validate();
    }

    public UserCommentMessagePanel(String string, boolean bl) {
        this();
        this.commentedPublicKey = string;
        if (bl) {
            this.makePanelEditable();
        }
    }

    public UserCommentMessagePanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.mainBorderLayout);
        this.commentPanel.setLayout(this.commentPanelBorderLayout);
        this.commentCaptionsPanel.setLayout(this.commentCaptionsPanelGridLayout);
        this.commentValuesPanel.setLayout(this.commentValuesPanelGridLayout);
        this.commentCaptionsPanelGridLayout.setRows(6);
        this.commentCaptionsPanelGridLayout.setColumns(1);
        this.commentValuesPanelGridLayout.setRows(6);
        this.commentValuesPanelGridLayout.setColumns(1);
        this.publicKeyCaptionLabel.setMaximumSize(new Dimension(100, 17));
        this.publicKeyCaptionLabel.setPreferredSize(new Dimension(100, 17));
        this.publicKeyCaptionLabel.setHorizontalAlignment(0);
        this.publicKeyCaptionLabel.setText("public key:");
        this.ratingCaptionLabel.setMaximumSize(new Dimension(100, 17));
        this.ratingCaptionLabel.setMinimumSize(new Dimension(60, 17));
        this.ratingCaptionLabel.setPreferredSize(new Dimension(100, 17));
        this.ratingCaptionLabel.setHorizontalAlignment(0);
        this.ratingCaptionLabel.setText("rating:");
        this.commentCaptionsPanel.setPreferredSize(new Dimension(100, 38));
        this.commentPanel.setMinimumSize(new Dimension(337, 90));
        this.commentPanel.setPreferredSize(new Dimension(60, 120));
        this.commentCaption.setMaximumSize(new Dimension(100, 17));
        this.commentCaption.setPreferredSize(new Dimension(100, 17));
        this.commentCaption.setHorizontalAlignment(0);
        this.commentCaption.setText("your comment:");
        this.ratingPanel.setLayout(this.ratingPanelGridLayout);
        this.ratingPanelGridLayout.setColumns(2);
        this.publicKeyTextField.setMinimumSize(new Dimension(25, 20));
        this.publicKeyTextField.setPreferredSize(new Dimension(25, 20));
        this.publicKeyTextField.setEditable(false);
        this.reasonCaptionLabel.setHorizontalAlignment(0);
        this.reasonCaptionLabel.setText("reason:");
        this.reasonTextField.setMinimumSize(new Dimension(25, 20));
        this.reasonTextField.setPreferredSize(new Dimension(25, 20));
        this.reasonTextField.setEditable(false);
        this.sendCommentButton.setEnabled(false);
        this.sendCommentButton.setFont(new Font("Dialog", 0, 10));
        this.sendCommentButton.setMinimumSize(new Dimension(225, 15));
        this.sendCommentButton.setPreferredSize(new Dimension(225, 15));
        this.sendCommentButton.setText("send comment on your personal channel");
        this.sendCommentButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UserCommentMessagePanel.this.sendCommentButton_actionPerformed(actionEvent);
            }
        });
        this.buttonPanel.setLayout(this.buttonPanelBorderLayout);
        this.buttonPanel.setPreferredSize(new Dimension(225, 15));
        this.dateCaptionLabel.setHorizontalAlignment(0);
        this.dateCaptionLabel.setText("date:");
        this.sourceCaptionLabel.setHorizontalAlignment(0);
        this.sourceCaptionLabel.setText("source:");
        this.ratingComboBox.setEnabled(false);
        this.ratingComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                UserCommentMessagePanel.this.ratingComboBox_itemStateChanged(itemEvent);
            }
        });
        this.ratingLabel.setBackground(Color.red);
        this.ratingLabel.setForeground(Color.white);
        this.ratingLabel.setMinimumSize(new Dimension(25, 20));
        this.ratingLabel.setOpaque(true);
        this.ratingLabel.setPreferredSize(new Dimension(25, 20));
        this.ratingLabel.setHorizontalAlignment(0);
        this.sourceTextfield.setEditable(false);
        this.dateTextField.setEditable(false);
        this.sourcePanel.setLayout(this.sourcePanelBorderLayout);
        this.getOriginalButton.setEnabled(false);
        this.getOriginalButton.setFont(new Font("Dialog", 0, 9));
        this.getOriginalButton.setForeground(Color.red);
        this.getOriginalButton.setText("verify");
        this.getOriginalButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UserCommentMessagePanel.this.getOriginalButton_actionPerformed(actionEvent);
            }
        });
        this.add((Component)this.buttonPanel, "South");
        this.buttonPanel.add((Component)this.sendCommentButton, "Center");
        this.add((Component)this.commentPanel, "North");
        this.commentPanel.add((Component)this.commentCaptionsPanel, "West");
        this.commentPanel.add((Component)this.commentValuesPanel, "Center");
        this.commentValuesPanel.add((Component)this.publicKeyTextField, null);
        this.commentValuesPanel.add((Component)this.dateTextField, null);
        this.commentValuesPanel.add((Component)this.sourcePanel, null);
        this.sourcePanel.add((Component)this.sourceTextfield, "Center");
        this.commentValuesPanel.add((Component)this.ratingPanel, null);
        this.commentCaptionsPanel.add((Component)this.publicKeyCaptionLabel, null);
        this.commentCaptionsPanel.add((Component)this.dateCaptionLabel, null);
        this.commentCaptionsPanel.add((Component)this.sourceCaptionLabel, null);
        this.commentCaptionsPanel.add((Component)this.ratingCaptionLabel, null);
        this.commentCaptionsPanel.add((Component)this.reasonCaptionLabel, null);
        this.add((Component)this.commentScrollPane, "Center");
        this.commentCaptionsPanel.add((Component)this.commentCaption, null);
        this.commentValuesPanel.add((Component)this.reasonTextField, null);
        this.ratingPanel.add((Component)this.ratingLabel, null);
        this.ratingPanel.add((Component)this.ratingComboBox, null);
        this.commentScrollPane.getViewport().add((Component)this.commentTextPane, null);
        this.sourcePanel.add((Component)this.getOriginalButton, "East");
    }

    void ratingComboBox_itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            String string = (String)this.ratingComboBox.getSelectedItem();
            this.ratingLabel.setText(string);
            this.ratingLabel.setBackground(ColorsAndIcons.getColorOfRating(string));
        }
    }

    void sendCommentButton_actionPerformed(ActionEvent actionEvent) {
        Object object;
        UserCommentMessage userCommentMessage = new UserCommentMessage(this.commentedPublicKey, this.ratingLabel.getText(), this.reasonTextField.getText(), this.commentTextPane.getText(), "no message");
        try {
            object = ContactList.instance().getLatestUserMessageFromPublicKey(this.commentedPublicKey);
            MessageGateway.instance().sendMessageOnPersonalChannel((Message)object);
        }
        catch (MessageNotReceivedException messageNotReceivedException) {
            CoreLogger.log("couldn't find the user message you commented in the message pool!", 0);
        }
        MessageGateway.instance().sendMessageOnPersonalChannel(userCommentMessage);
        object = this.getParent();
        while (object != null) {
            if (object instanceof ContactInformationPanel) {
                ((ContactInformationPanel)object).updateInformation();
            }
            object = ((Component)object).getParent();
        }
    }

    void getOriginalButton_actionPerformed(ActionEvent actionEvent) {
        MessageVerificationPanel messageVerificationPanel = new MessageVerificationPanel(this.userCommentMessage);
        String string = ContactList.instance().getNicknameOfPublicKey(this.userCommentMessage.getOriginalPublicKey());
        String string2 = ContactList.instance().getNicknameOfPublicKey(this.userCommentMessage.getUserPublicKey());
        BetaGUI.instance().verifyMessage(this.userCommentMessage);
    }
}

