/*
 * Decompiled with CFR 0.152.
 */
package freenetmessageboard.gui;

import freenetmessageboard.core.ContactList;
import freenetmessageboard.core.CoreLogger;
import freenetmessageboard.core.Message;
import freenetmessageboard.core.MessageGateway;
import freenetmessageboard.core.MessageNotReceivedException;
import freenetmessageboard.core.MessagePool;
import freenetmessageboard.core.PersonalInfo;
import freenetmessageboard.core.PostMessage;
import freenetmessageboard.gui.BetaGUI;
import freenetmessageboard.gui.MessageVerificationPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;

public class PostMessagePanel
extends JPanel {
    BorderLayout mainBorderLayout = new BorderLayout();
    JPanel topPanel = new JPanel();
    JPanel mainPanel = new JPanel();
    JPanel bottomPanel = new JPanel();
    BorderLayout topPanelBorderLayout = new BorderLayout();
    JPanel messageHeaderCaptionsPanel = new JPanel();
    JPanel messageHeaderValuesPanel = new JPanel();
    GridLayout messageHeaderValuesPanelGridLayout = new GridLayout();
    GridLayout messageHeaderCaptionsPanelGridLayout = new GridLayout();
    JLabel dateCaptionLabel = new JLabel();
    JLabel newsgroupCaptionLabel = new JLabel();
    JLabel replyToCaptionLabel = new JLabel();
    JLabel subjectCaptionLabel = new JLabel();
    JTextField dateTextField = new JTextField();
    JTextField fromTextField = new JTextField();
    JTextField newsgroupTextField = new JTextField();
    JTextField replyToTextField = new JTextField();
    JScrollPane messageTextScrollPane1 = new JScrollPane();
    BorderLayout mainPanelBorderLayout1 = new BorderLayout();
    JTextPane messageTextTextPane = new JTextPane();
    JLabel fromCaptionLabel = new JLabel();
    JTextField subjectTextField = new JTextField();
    JButton sendButton = new JButton();
    BorderLayout bottomPanelBorderLayout = new BorderLayout();
    private boolean isEditable = false;
    JLabel sourceCaptionLabel = new JLabel();
    PostMessage replyToMessage;
    PostMessage myPostMessage;
    String replyToUniqueId = new String();
    String myUniqueId = new String();
    JPanel sourcePanel = new JPanel();
    JTextField sourceTextField = new JTextField();
    BorderLayout sourcePanelBorderLayout = new BorderLayout();
    JButton getOriginalButton = new JButton();

    public PostMessagePanel(PostMessage postMessage, boolean bl) {
        this();
        if (!bl) {
            this.myPostMessage = postMessage;
            this.replyToMessage = null;
            this.updateInformationFrom(postMessage);
        } else {
            this.replyToMessage = postMessage;
            this.replyToUniqueId = postMessage.getUniqueId();
            this.myPostMessage = null;
            this.setEditable(true);
            String string = ContactList.instance().getNicknameOfPublicKey(postMessage.getOriginalPublicKey());
            this.replyToTextField.setText("'" + postMessage.getSubject() + "' from " + string + " (" + postMessage.getOriginalPublicKey() + ")");
            this.newsgroupTextField.setText(postMessage.getKeywords());
        }
    }

    void updateInformationFrom(PostMessage postMessage) {
        this.myPostMessage = postMessage;
        this.replyToMessage = null;
        this.dateTextField.setText(postMessage.getDate());
        this.subjectTextField.setText(postMessage.getSubject());
        this.messageTextTextPane.setText(postMessage.getMessage());
        this.newsgroupTextField.setText(postMessage.getKeywords());
        this.fromTextField.setText(ContactList.instance().getNicknameOfPublicKey(postMessage.getOriginalPublicKey()) + " (" + postMessage.getOriginalPublicKey() + ")");
        this.sourceTextField.setText(ContactList.instance().getNicknameOfPublicKey(postMessage.getSourceKey()) + " (" + postMessage.getSourceKey() + ")");
        if (postMessage.getOriginalPublicKey().equals(postMessage.getSourceKey())) {
            this.getOriginalButton.setEnabled(false);
        } else {
            this.getOriginalButton.setEnabled(true);
        }
        this.myUniqueId = postMessage.getUniqueId();
        if (postMessage.getReplyToUniqueId().length() > 0) {
            this.replyToUniqueId = postMessage.getReplyToUniqueId();
            try {
                PostMessage postMessage2 = MessagePool.instance().getPostMessage(postMessage.getReplyToUniqueId());
                String string = postMessage2.getSubject();
                String string2 = ContactList.instance().getNicknameOfPublicKey(postMessage2.getOriginalPublicKey());
                this.replyToTextField.setText("'" + string + "' from " + string2 + " (" + postMessage2.getOriginalPublicKey() + ")");
            }
            catch (MessageNotReceivedException messageNotReceivedException) {
                this.replyToTextField.setText("(a message that has not yet been received)");
            }
        } else {
            this.replyToUniqueId = new String();
            this.replyToTextField.setText("");
        }
    }

    public PostMessagePanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void setEditable(boolean bl) {
        this.isEditable = bl;
        this.dateTextField.setText(Message.messageDateFormat.format(new Date()));
        String string = PersonalInfo.instance().getPublicKey();
        this.fromTextField.setText(PersonalInfo.instance().getNickname() + " (" + string + ")");
        this.subjectTextField.setEditable(bl);
        this.newsgroupTextField.setEditable(bl);
        this.messageTextTextPane.setEditable(bl);
        if (bl) {
            this.sendButton.setText("send this message on your personal channel");
        } else {
            this.sendButton.setText("reply to this message");
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.mainBorderLayout);
        this.topPanel.setLayout(this.topPanelBorderLayout);
        this.messageHeaderValuesPanel.setLayout(this.messageHeaderValuesPanelGridLayout);
        this.messageHeaderCaptionsPanel.setLayout(this.messageHeaderCaptionsPanelGridLayout);
        this.messageHeaderCaptionsPanelGridLayout.setRows(6);
        this.messageHeaderCaptionsPanelGridLayout.setColumns(1);
        this.messageHeaderValuesPanelGridLayout.setRows(6);
        this.messageHeaderValuesPanelGridLayout.setColumns(1);
        this.dateCaptionLabel.setHorizontalAlignment(4);
        this.dateCaptionLabel.setText("date:");
        this.newsgroupCaptionLabel.setHorizontalAlignment(4);
        this.newsgroupCaptionLabel.setText("newsgroup:");
        this.replyToCaptionLabel.setHorizontalAlignment(4);
        this.replyToCaptionLabel.setText("reply to:");
        this.subjectCaptionLabel.setHorizontalAlignment(4);
        this.subjectCaptionLabel.setText("subject:");
        this.mainPanel.setLayout(this.mainPanelBorderLayout1);
        this.fromCaptionLabel.setHorizontalAlignment(4);
        this.fromCaptionLabel.setText("from:");
        this.sendButton.setText("reply to this message");
        this.sendButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PostMessagePanel.this.sendButton_actionPerformed(actionEvent);
            }
        });
        this.bottomPanel.setLayout(this.bottomPanelBorderLayout);
        this.messageTextTextPane.setEditable(false);
        this.subjectTextField.setEditable(false);
        this.replyToTextField.setEditable(false);
        this.newsgroupTextField.setEditable(false);
        this.dateTextField.setEditable(false);
        this.fromTextField.setEditable(false);
        this.sourceCaptionLabel.setHorizontalAlignment(4);
        this.sourceCaptionLabel.setText("source:");
        this.sourceTextField.setEditable(false);
        this.sourcePanel.setLayout(this.sourcePanelBorderLayout);
        this.getOriginalButton.setFont(new Font("Dialog", 0, 9));
        this.getOriginalButton.setForeground(Color.red);
        this.getOriginalButton.setToolTipText("");
        this.getOriginalButton.setText("verify");
        this.getOriginalButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PostMessagePanel.this.getOriginalButton_actionPerformed(actionEvent);
            }
        });
        this.add((Component)this.topPanel, "North");
        this.add((Component)this.mainPanel, "Center");
        this.add((Component)this.bottomPanel, "South");
        this.topPanel.add((Component)this.messageHeaderCaptionsPanel, "West");
        this.topPanel.add((Component)this.messageHeaderValuesPanel, "Center");
        this.messageHeaderCaptionsPanel.add((Component)this.fromCaptionLabel, null);
        this.messageHeaderCaptionsPanel.add((Component)this.sourceCaptionLabel, null);
        this.messageHeaderCaptionsPanel.add((Component)this.dateCaptionLabel, null);
        this.messageHeaderCaptionsPanel.add((Component)this.newsgroupCaptionLabel, null);
        this.messageHeaderCaptionsPanel.add((Component)this.replyToCaptionLabel, null);
        this.messageHeaderCaptionsPanel.add((Component)this.subjectCaptionLabel, null);
        this.messageHeaderValuesPanel.add((Component)this.fromTextField, null);
        this.messageHeaderValuesPanel.add((Component)this.sourcePanel, null);
        this.sourcePanel.add((Component)this.sourceTextField, "Center");
        this.messageHeaderValuesPanel.add((Component)this.dateTextField, null);
        this.messageHeaderValuesPanel.add((Component)this.newsgroupTextField, null);
        this.messageHeaderValuesPanel.add((Component)this.replyToTextField, null);
        this.messageHeaderValuesPanel.add((Component)this.subjectTextField, null);
        this.mainPanel.add((Component)this.messageTextScrollPane1, "Center");
        this.messageTextScrollPane1.getViewport().add((Component)this.messageTextTextPane, null);
        this.bottomPanel.add((Component)this.sendButton, "Center");
        this.sourcePanel.add((Component)this.getOriginalButton, "East");
    }

    void sendButton_actionPerformed(ActionEvent actionEvent) {
        if (this.isEditable) {
            Serializable serializable;
            PostMessage postMessage = new PostMessage(this.subjectTextField.getText(), this.replyToUniqueId, this.newsgroupTextField.getText(), this.messageTextTextPane.getText());
            if (this.replyToMessage != null) {
                CoreLogger.log("looking for the prev messages of the reply...", 2);
                serializable = new LinkedList();
                PostMessage postMessage2 = this.replyToMessage;
                while (true) {
                    serializable.add(0, postMessage2);
                    CoreLogger.log("adding prev msg " + postMessage2.toShortString(), 2);
                    if (postMessage2.getReplyToUniqueId().length() == 0) break;
                    try {
                        postMessage2 = MessagePool.instance().getPostMessage(postMessage2.getReplyToUniqueId());
                    }
                    catch (MessageNotReceivedException messageNotReceivedException) {
                        // empty catch block
                        break;
                    }
                }
                CoreLogger.log("sending all msgs...", 2);
                Iterator iterator = serializable.iterator();
                while (iterator.hasNext()) {
                    PostMessage postMessage3 = (PostMessage)iterator.next();
                    CoreLogger.log("sending message " + postMessage3.toShortString(), 2);
                    MessageGateway.instance().sendMessageOnPersonalChannel(postMessage3);
                }
            }
            MessageGateway.instance().sendMessageOnPersonalChannel(postMessage);
            serializable = this.getParent();
            while (!(serializable instanceof JFrame)) {
                serializable = ((Component)serializable).getParent();
            }
            BetaGUI.instance().defaultFrameSize = ((Component)serializable).getSize();
            BetaGUI.instance().defaultFrameLocation = ((Component)serializable).getLocation();
            ((Component)serializable).setVisible(false);
        } else {
            PostMessagePanel postMessagePanel = new PostMessagePanel(this.myPostMessage, true);
            BetaGUI.instance().newFrame("create reply to " + this.subjectTextField.getText(), postMessagePanel);
        }
    }

    void getOriginalButton_actionPerformed(ActionEvent actionEvent) {
        MessageVerificationPanel messageVerificationPanel = new MessageVerificationPanel(this.myPostMessage);
        BetaGUI.instance().verifyMessage(this.myPostMessage);
    }
}

