/*
 * Decompiled with CFR 0.152.
 */
package freenetmessageboard.gui;

import freenetmessageboard.core.ContactList;
import freenetmessageboard.core.Message;
import freenetmessageboard.core.MessagePool;
import freenetmessageboard.fcpinterface.FCPFacade;
import freenetmessageboard.fcpinterface.FCPRequestCallback;
import freenetmessageboard.fcpinterface.RequestedData;
import freenetmessageboard.gui.BetaGUI;
import freenetmessageboard.gui.ColorsAndIcons;
import freenetmessageboard.gui.MessagePanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

class MessageVerificationPanel
extends JPanel
implements FCPRequestCallback {
    BorderLayout mainBorderLayout = new BorderLayout();
    JPanel topPanel = new JPanel();
    JLabel jLabel1 = new JLabel();
    JTabbedPane jTabbedPane1 = new JTabbedPane();
    JButton requestOriginalButton = new JButton();
    private Message existingMsg;
    private Map newCopiesMap = new HashMap();
    private Map allPanels = new HashMap();
    private Message originalMsg;

    public MessageVerificationPanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public MessageVerificationPanel(Message message, Message message2) {
        this();
        this.addExistingMessage(message);
        this.addNewMessage(message2);
        Thread thread = new Thread(){

            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                MessageVerificationPanel.this.requestOriginalVersion();
            }
        };
        thread.setName("MsgVerification");
        thread.start();
        this.validate();
        this.repaint();
    }

    public MessageVerificationPanel(Message message) {
        this();
        this.jLabel1.setText("trying to request the original version...");
        this.addExistingMessage(message);
        this.requestOriginalVersion();
        this.validate();
        this.repaint();
    }

    private void addNewMessage(Message message) {
        if (this.newCopiesMap.containsKey(message.getSourceUri())) {
            return;
        }
        this.newCopiesMap.put(message.getSourceUri(), message);
        MessagePanel messagePanel = new MessagePanel(message);
        String string = ContactList.instance().getNicknameOfPublicKey(message.getSourceKey());
        String string2 = message.getOriginalUri().equals(message.getSourceUri()) ? "new original from " + string : (message.getSourceKey().equals(message.getOriginalPublicKey()) ? "new signed copy from " + string : "new copy from " + string);
        this.jTabbedPane1.add(string2, messagePanel);
        this.allPanels.put(message.getSourceUri(), messagePanel);
        this.compareToOriginalMessage();
    }

    private void addExistingMessage(Message message) {
        this.existingMsg = message;
        MessagePanel messagePanel = new MessagePanel(message);
        String string = ContactList.instance().getNicknameOfPublicKey(message.getSourceKey());
        String string2 = message.getOriginalUri().equals(message.getSourceUri()) ? "existing original from " + string : (message.getSourceKey().equals(message.getOriginalPublicKey()) ? "existing signed copy from " + string : "existing copy from " + string);
        this.jTabbedPane1.add(string2, messagePanel);
        this.allPanels.put(message.getSourceUri(), messagePanel);
    }

    private void compareToOriginalMessage() {
        if (this.originalMsg == null) {
            return;
        }
        MessagePanel messagePanel = (MessagePanel)this.jTabbedPane1.getComponent(0);
        MessagePanel messagePanel2 = (MessagePanel)this.allPanels.get(this.originalMsg.getSourceUri());
        this.jTabbedPane1.setIconAt(this.jTabbedPane1.indexOfComponent(messagePanel2), ColorsAndIcons.getIconForRating("GOOD"));
        if (this.newCopiesMap.size() == 0) {
            if (this.existingMsg.equals(this.originalMsg)) {
                this.jLabel1.setText("the copy of the message equals the original message!");
                this.jLabel1.setForeground(Color.green);
                this.jTabbedPane1.setIconAt(this.jTabbedPane1.indexOfComponent(messagePanel), ColorsAndIcons.getIconForRating("GOOD"));
                BetaGUI.instance().setVerifyingRating(this.originalMsg, "GOOD");
            } else {
                this.jLabel1.setText("the copy of the message is different from the original one!");
                this.jLabel1.setForeground(Color.red);
                this.jTabbedPane1.setIconAt(this.jTabbedPane1.indexOfComponent(messagePanel), ColorsAndIcons.getIconForRating("EVIL"));
                BetaGUI.instance().setVerifyingRating(this.originalMsg, "EVIL");
            }
        } else {
            LinkedList<String> linkedList = new LinkedList<String>();
            Iterator iterator = this.newCopiesMap.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Message message = (Message)this.newCopiesMap.get(string);
                MessagePanel messagePanel3 = (MessagePanel)this.allPanels.get(message.getSourceUri());
                if (message.equals(this.originalMsg)) continue;
                linkedList.add(string);
                this.jTabbedPane1.setIconAt(this.jTabbedPane1.indexOfComponent(messagePanel3), ColorsAndIcons.getIconForRating("EVIL"));
            }
            if (this.existingMsg.equals(this.originalMsg)) {
                this.jTabbedPane1.setIconAt(this.jTabbedPane1.indexOfComponent(messagePanel), ColorsAndIcons.getIconForRating("GOOD"));
                if (linkedList.size() == 0) {
                    this.jLabel1.setText("all copies seem to be correct");
                    this.jLabel1.setForeground(Color.green);
                    BetaGUI.instance().setVerifyingRating(this.originalMsg, "GOOD");
                } else {
                    this.jLabel1.setText("you're existing copy is correct, some of the new copies aren't!");
                    this.jLabel1.setForeground(Color.red);
                    BetaGUI.instance().setVerifyingRating(this.originalMsg, "EVIL");
                }
            } else {
                this.jTabbedPane1.setIconAt(this.jTabbedPane1.indexOfComponent(messagePanel), ColorsAndIcons.getIconForRating("EVIL"));
                if (linkedList.size() == 0) {
                    this.jLabel1.setText("you're existing copy is incorrect, the new ones are");
                    this.jLabel1.setForeground(Color.red);
                    BetaGUI.instance().setVerifyingRating(this.originalMsg, "EVIL");
                } else {
                    this.jLabel1.setText("neither your existing copy nor the new ones are correct");
                    this.jLabel1.setForeground(Color.red);
                    BetaGUI.instance().setVerifyingRating(this.originalMsg, "EVIL");
                }
            }
        }
    }

    public void requestSuccesfull(String string, RequestedData requestedData) {
        Message[] messageArray = Message.parseMultipleMessageString(Message.getStringFromBytes(requestedData.getDataBytes()));
        if (messageArray.length == 0) {
            this.requestOriginalButton.setText("there were invalid messages found at " + string + "!");
            return;
        }
        this.requestOriginalButton.setText("requesting of" + this.existingMsg.getOriginalUri() + " was succesful.");
        boolean bl = false;
        int n = 0;
        while (n < messageArray.length) {
            messageArray[n].setSource(string);
            if (messageArray[n].getUniqueId().equals(this.existingMsg.getUniqueId())) {
                this.requestOriginalButton.setText("the original version was found and added to your message box! click here to remove this tab");
                this.requestOriginalButton.setEnabled(true);
                String string2 = ContactList.instance().getNicknameOfPublicKey(messageArray[n].getOriginalPublicKey());
                MessagePanel messagePanel = new MessagePanel(messageArray[n]);
                this.jTabbedPane1.add("original version from " + string2, messagePanel);
                this.allPanels.put(messageArray[n].getSourceUri(), messagePanel);
                bl = true;
                this.originalMsg = messageArray[n];
                this.compareToOriginalMessage();
            }
            MessagePool.instance().addMessage(string, messageArray[n]);
            ++n;
        }
        if (!bl) {
            this.jLabel1.setText("there is no such message at " + string + "! the copy is faked!");
            this.jLabel1.setForeground(Color.red);
            BetaGUI.instance().setVerifyingRating(this.existingMsg, "EVIL");
        }
    }

    public void requestFailedWithRouteNotFound(String string) {
        this.requestOriginalButton.setText("request failed with route not found, retrying...");
        this.requestOriginalVersion();
    }

    public void requestFailedWithDataNotFound(String string) {
        this.requestOriginalButton.setText("request failed with data not found, click here to retry again");
        this.jLabel1.setText("the original message wasn't found! be careful, perhaps there is no such message!");
        this.jLabel1.setForeground(Color.yellow);
        BetaGUI.instance().setVerifyingRating(this.existingMsg, "YELLOW");
        this.requestOriginalButton.setEnabled(true);
    }

    public void requestFailedBadly(String string, String string2) {
        if (string2.length() > 30) {
            string2 = string2.substring(0, 30) + "...";
        }
        this.requestOriginalButton.setText("request failed: " + string2 + ", click to try again");
        this.requestOriginalButton.setEnabled(true);
        BetaGUI.instance().setVerifyingRating(this.existingMsg, "YELLOW");
    }

    public void requestStarted(String string) {
        this.requestOriginalButton.setText("requesting " + this.existingMsg.getOriginalUri() + "...");
    }

    private void jbInit() throws Exception {
        this.setLayout(this.mainBorderLayout);
        this.jLabel1.setForeground(Color.red);
        this.jLabel1.setText("these two messages are not equal. please check if one of them is faked:");
        this.requestOriginalButton.setFont(new Font("Dialog", 0, 10));
        this.requestOriginalButton.setForeground(Color.red);
        this.requestOriginalButton.setText("request original version");
        this.requestOriginalButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MessageVerificationPanel.this.requestOriginalButton_actionPerformed(actionEvent);
            }
        });
        this.add((Component)this.topPanel, "North");
        this.topPanel.add((Component)this.jLabel1, null);
        this.add((Component)this.jTabbedPane1, "Center");
        this.add((Component)this.requestOriginalButton, "South");
    }

    private void requestOriginalVersion() {
        FCPFacade.instance().startFreenetRequest(this, this.existingMsg.getOriginalUri(), 50, false);
        this.requestOriginalButton.setText("request of " + this.existingMsg.getOriginalUri() + " is queued...");
        this.requestOriginalButton.setEnabled(false);
    }

    void requestOriginalButton_actionPerformed(ActionEvent actionEvent) {
        if (this.originalMsg != null) {
            BetaGUI.instance().removeVerification(this.originalMsg);
            return;
        }
        if (this.newCopiesMap.size() == 0) {
            this.jLabel1.setText("requesting the original version to verify the copy...");
        } else {
            this.jLabel1.setText("requesting the original version to decide which copy is correct...");
        }
        BetaGUI.instance().setVerifyingRating(this.existingMsg, "WHITE");
        this.requestOriginalVersion();
    }
}

