/*
 * Decompiled with CFR 0.152.
 */
package freenetmessageboard.gui;

import freenetmessageboard.core.Message;
import freenetmessageboard.gui.ColorsAndIcons;
import freenetmessageboard.gui.MessageVerificationPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.HashMap;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;

public class MessageVerificationFrame
extends JFrame {
    BorderLayout mainBorderLayout = new BorderLayout();
    JTabbedPane verificationPanelsTabbedPane = new JTabbedPane();
    HashMap displayMessageVerificationPanels = new HashMap();

    public MessageVerificationFrame() {
        try {
            this.jbInit();
            this.setSize(750, 550);
            this.setLocation(10, 10);
            this.setTitle("message verification window");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void showVerificationRating(Message message, String string) {
        MessageVerificationPanel messageVerificationPanel = (MessageVerificationPanel)this.displayMessageVerificationPanels.get(message.getUniqueId());
        int n = this.verificationPanelsTabbedPane.indexOfComponent(messageVerificationPanel);
        if (n != -1) {
            this.verificationPanelsTabbedPane.setIconAt(n, ColorsAndIcons.getIconForRating(string));
        }
    }

    void removeMessage(Message message) {
        MessageVerificationPanel messageVerificationPanel = (MessageVerificationPanel)this.displayMessageVerificationPanels.get(message.getUniqueId());
        this.verificationPanelsTabbedPane.remove(messageVerificationPanel);
    }

    public void verifyMessage(Message message, Message message2) {
        if (!this.displayMessageVerificationPanels.containsKey(message.getUniqueId())) {
            MessageVerificationPanel messageVerificationPanel = new MessageVerificationPanel(message, message2);
            this.displayMessageVerificationPanels.put(message.getUniqueId(), messageVerificationPanel);
            this.verificationPanelsTabbedPane.add(message.toShortString(), messageVerificationPanel);
            this.verificationPanelsTabbedPane.setIconAt(this.verificationPanelsTabbedPane.getComponentCount() - 1, ColorsAndIcons.getIconForRating("NOTYET"));
            this.verificationPanelsTabbedPane.setSelectedComponent(messageVerificationPanel);
        }
    }

    public void verifyMessage(Message message) {
        if (!this.displayMessageVerificationPanels.containsKey(message.getUniqueId())) {
            MessageVerificationPanel messageVerificationPanel = new MessageVerificationPanel(message);
            this.displayMessageVerificationPanels.put(message.getUniqueId(), messageVerificationPanel);
            this.verificationPanelsTabbedPane.add(message.toShortString(), messageVerificationPanel);
            this.verificationPanelsTabbedPane.setIconAt(this.verificationPanelsTabbedPane.getComponentCount() - 1, ColorsAndIcons.getIconForRating("NOTYET"));
            this.verificationPanelsTabbedPane.setSelectedComponent(messageVerificationPanel);
        }
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(this.mainBorderLayout);
        this.getContentPane().add((Component)this.verificationPanelsTabbedPane, "Center");
    }
}

