/*
 * Decompiled with CFR 0.152.
 */
package freenetmessageboard.gui;

import freenetmessageboard.core.ChannelInfo;
import freenetmessageboard.core.ContactInformation;
import freenetmessageboard.core.CoreLogger;
import freenetmessageboard.core.Message;
import freenetmessageboard.core.MessageGateway;
import freenetmessageboard.core.MessagePool;
import freenetmessageboard.core.PersonalInfo;
import freenetmessageboard.core.UserMessage;
import freenetmessageboard.gui.BetaGUI;
import freenetmessageboard.gui.ColorsAndIcons;
import freenetmessageboard.gui.ContactInformationPanel;
import freenetmessageboard.gui.RatingPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Comparator;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class ContactPanel
extends JPanel {
    BorderLayout contactPanelBorderLayout = new BorderLayout();
    JLabel publicKeyPanel = new JLabel();
    private UserMessage lastUserMessage;
    private ContactInformation contactInformation;
    JLabel slotInfoLabel = new JLabel();
    JPopupMenu contactPanelPopupMenu = new JPopupMenu();
    JMenuItem showInfoMenuItem = new JMenuItem();
    JMenuItem stopListeningMenuItem = new JMenuItem();
    JMenuItem startListeningMenuItem = new JMenuItem();
    JPanel jPanel1 = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    JLabel nickNamePanel = new JLabel();
    JLabel lastOnlineLabel = new JLabel();
    Border border1;
    JPopupMenu sendingChannelPopupMenu = new JPopupMenu();
    JMenuItem sendBufferdInsertsMenuitem = new JMenuItem();
    JMenuItem showInfoMenuItem1 = new JMenuItem();
    RatingPanel ratingPanel1 = new RatingPanel(new int[]{0, 0, 0}, new Color[]{ColorsAndIcons.getColorOfRating("GOOD"), ColorsAndIcons.getColorOfRating("NEUTRAL"), ColorsAndIcons.getColorOfRating("EVIL"), this.getBackground()});

    public ContactPanel(ContactInformation contactInformation) {
        this();
        this.contactInformation = contactInformation;
        this.updateInformation();
    }

    public void updateInformation() {
        this.nickNamePanel.setText(this.contactInformation.getNickname());
        String string = MessageGateway.constructPersonalChannelBaseName(this.contactInformation.getPublicKey(), MessageGateway.getCurrentDate());
        CoreLogger.log("getting status string from channel " + string + "...", 4);
        ChannelInfo channelInfo = ChannelInfo.getInstance(string);
        this.ratingPanel1.update(this.contactInformation.getRatings());
        if (this.contactInformation.getPublicKey().equals(PersonalInfo.instance().getPublicKey())) {
            this.slotInfoLabel.setText(MessageGateway.instance().getSlotInfoStringForMyPersonalChannel());
            int n = MessageGateway.instance().getActiveInsertCount();
            if (n == 0) {
                this.publicKeyPanel.setText("no active inserts, " + MessageGateway.instance().getSendBufferSize() + " bytes buffered");
            } else {
                this.publicKeyPanel.setText(n + " active inserts, " + MessageGateway.instance().getSendBufferSize() + " bytes buffered");
            }
            return;
        }
        Message message = MessagePool.instance().getLatestMessageFromUser(this.contactInformation.getPublicKey());
        String string2 = "no msgs";
        try {
            long l = this.contactInformation.getTimeOfLastActivity();
            long l2 = new Date().getTime() - l;
            long l3 = l2 / 1000L;
            if (l3 < 60L) {
                string2 = l3 + "s";
            }
            if (l3 >= 60L && l3 <= 3600L) {
                string2 = l3 / 60L + "m";
            }
            if (l3 > 3600L) {
                string2 = l3 / 3600L + "h";
            }
            if (message.isFromCurrentDay()) {
                this.lastOnlineLabel.setForeground(this.nickNamePanel.getForeground());
            } else {
                this.lastOnlineLabel.setForeground(Color.red);
            }
        }
        catch (Throwable throwable) {
            CoreLogger.log("error while caluclating time offset: " + throwable.getClass().getName() + ": " + throwable.getMessage(), 0);
        }
        this.lastOnlineLabel.setText(string2);
        this.publicKeyPanel.setText(channelInfo.getStatusString());
        this.slotInfoLabel.setText(channelInfo.getSlotInfoString());
    }

    public ContactPanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.border1 = BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140));
        this.setLayout(this.contactPanelBorderLayout);
        this.publicKeyPanel.setFont(new Font("Dialog", 0, 9));
        this.publicKeyPanel.setForeground(Color.black);
        this.publicKeyPanel.setMinimumSize(new Dimension(117, 11));
        this.publicKeyPanel.setPreferredSize(new Dimension(117, 11));
        this.publicKeyPanel.setHorizontalAlignment(2);
        this.publicKeyPanel.setHorizontalTextPosition(0);
        this.publicKeyPanel.setText("Ksdkdfkmsdfkm34ksdfm34");
        this.setBorder(this.border1);
        this.setMinimumSize(new Dimension(123, 35));
        this.setPreferredSize(new Dimension(123, 40));
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                ContactPanel.this.this_mousePressed(mouseEvent);
            }
        });
        this.slotInfoLabel.setFont(new Font("Monospaced", 0, 9));
        this.slotInfoLabel.setForeground(Color.black);
        this.slotInfoLabel.setMinimumSize(new Dimension(15, 10));
        this.slotInfoLabel.setPreferredSize(new Dimension(15, 10));
        this.slotInfoLabel.setText("000");
        this.showInfoMenuItem.setText("show information about this user");
        this.showInfoMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ContactPanel.this.showInfoMenuItem_actionPerformed(actionEvent);
            }
        });
        this.stopListeningMenuItem.setText("stop requesting from this channel");
        this.stopListeningMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ContactPanel.this.stopListeningMenuItem_actionPerformed(actionEvent);
            }
        });
        this.startListeningMenuItem.setText("start requesting from this channel");
        this.startListeningMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ContactPanel.this.startListeningMenuItem_actionPerformed(actionEvent);
            }
        });
        this.jPanel1.setLayout(this.borderLayout1);
        this.nickNamePanel.setMinimumSize(new Dimension(24, 15));
        this.nickNamePanel.setPreferredSize(new Dimension(24, 15));
        this.nickNamePanel.setHorizontalAlignment(2);
        this.nickNamePanel.setIconTextGap(0);
        this.nickNamePanel.setText("nick");
        this.lastOnlineLabel.setFont(new Font("Dialog", 0, 9));
        this.lastOnlineLabel.setText("n/a");
        this.sendBufferdInsertsMenuitem.setText("send buffered inserts now");
        this.sendBufferdInsertsMenuitem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ContactPanel.this.sendBufferdInsertsMenuitem_actionPerformed(actionEvent);
            }
        });
        this.showInfoMenuItem1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ContactPanel.this.showInfoMenuItem1_actionPerformed(actionEvent);
            }
        });
        this.showInfoMenuItem1.setText("show information about this user");
        this.borderLayout1.setHgap(4);
        this.add((Component)this.slotInfoLabel, "Center");
        this.add((Component)this.jPanel1, "North");
        this.jPanel1.add((Component)this.nickNamePanel, "Center");
        this.jPanel1.add((Component)this.lastOnlineLabel, "East");
        this.jPanel1.add((Component)this.ratingPanel1, "West");
        this.add((Component)this.publicKeyPanel, "South");
        this.contactPanelPopupMenu.add(this.showInfoMenuItem);
        this.contactPanelPopupMenu.add(this.showInfoMenuItem1);
        this.contactPanelPopupMenu.add(this.startListeningMenuItem);
        this.contactPanelPopupMenu.add(this.stopListeningMenuItem);
        this.sendingChannelPopupMenu.add(this.showInfoMenuItem);
        this.sendingChannelPopupMenu.add(this.sendBufferdInsertsMenuitem);
    }

    void showInfoMenuItem_actionPerformed(ActionEvent actionEvent) {
        BetaGUI.instance().newFrame("contact information for " + this.nickNamePanel.getText(), new ContactInformationPanel(this.contactInformation));
    }

    void this_mousePressed(MouseEvent mouseEvent) {
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            if (this.contactInformation.getPublicKey().equals(PersonalInfo.instance().getPublicKey())) {
                this.sendingChannelPopupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
            } else {
                this.contactPanelPopupMenu.show(this, mouseEvent.getPoint().x, mouseEvent.getPoint().y);
            }
        }
    }

    static Comparator getNickNameComparator() {
        return new Comparator(){

            public int compare(Object object, Object object2) {
                ContactPanel contactPanel = (ContactPanel)object;
                ContactPanel contactPanel2 = (ContactPanel)object2;
                return contactPanel.contactInformation.getNickname().compareTo(contactPanel2.contactInformation.getNickname());
            }
        };
    }

    static Comparator getLastActivityComparator() {
        return new Comparator(){

            public int compare(Object object, Object object2) {
                ContactPanel contactPanel = (ContactPanel)object;
                ContactPanel contactPanel2 = (ContactPanel)object2;
                Long l = new Long(contactPanel.contactInformation.getTimeOfLastActivity());
                Long l2 = new Long(contactPanel2.contactInformation.getTimeOfLastActivity());
                return -l.compareTo(l2);
            }
        };
    }

    static Comparator getRatingScoreComparator() {
        return new Comparator(){

            public int compare(Object object, Object object2) {
                ContactPanel contactPanel = (ContactPanel)object;
                ContactPanel contactPanel2 = (ContactPanel)object2;
                Integer n = new Integer(contactPanel.contactInformation.getRatingScore());
                Integer n2 = new Integer(contactPanel2.contactInformation.getRatingScore());
                return -n.compareTo(n2);
            }
        };
    }

    void startListeningMenuItem_actionPerformed(ActionEvent actionEvent) {
        MessageGateway.instance().startListeningOnPersonalChannel(this.contactInformation.getPublicKey());
    }

    void stopListeningMenuItem_actionPerformed(ActionEvent actionEvent) {
        MessageGateway.instance().stopListeningOnPersonalChannel(this.contactInformation.getPublicKey());
    }

    void sendBufferdInsertsMenuitem_actionPerformed(ActionEvent actionEvent) {
        MessageGateway.instance().flushPersonalChannelMessageBuffer();
    }

    void showInfoMenuItem1_actionPerformed(ActionEvent actionEvent) {
        BetaGUI.instance().newFrame("contact information for " + this.nickNamePanel.getText(), new ContactInformationPanel(this.contactInformation));
    }
}

