/*
 * Decompiled with CFR 0.152.
 */
package freenetmessageboard.gui;

import freenetmessageboard.core.ContactInformation;
import freenetmessageboard.core.CoreLogger;
import freenetmessageboard.core.MessageGateway;
import freenetmessageboard.gui.ContactPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class ContactListPanel
extends JPanel {
    BorderLayout contactListBorderLayout = new BorderLayout();
    JScrollPane contactsScrollPane = new JScrollPane();
    private static final int SORT_NOSORT = 0;
    private static final int SORT_NICKSORT = 1;
    private static final int SORT_LASTMSGSORT = 2;
    private static final int SORT_RATINGSORT = 3;
    private int currentSorting = 0;
    private static final String[] SORT_DESCRIPTIONS = new String[]{"sort contact list...", "sort by nick", "sort by last activity", "sort by ratings"};
    private Map allContactPanelsMap = new HashMap();
    JPanel announcementChannelStatusPanel = new JPanel();
    BorderLayout announcementChannelStatusPanelBorderLayout = new BorderLayout();
    JLabel announcementChannelStatusCaptionLabel = new JLabel();
    JLabel announcementChannelStatusLabel = new JLabel();
    GridLayout contactsPanelGridLayout = new GridLayout();
    JPanel contactsPanel = new JPanel();
    JLabel slotInfoLabel = new JLabel();
    JPopupMenu announcementChannelPopupMenu = new JPopupMenu();
    JMenuItem startListeningMenuItem = new JMenuItem();
    JMenuItem stopListeningMenuItem = new JMenuItem();
    JPanel topPanel = new JPanel();
    JLabel headerLabel = new JLabel();
    BorderLayout topPanelBorderLayout1 = new BorderLayout();
    JComboBox sortByComboBox = new JComboBox();

    public ContactListPanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Thread thread = new Thread(){

            public void run() {
                while (true) {
                    try {
                        Thread.sleep(30000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    CoreLogger.log("updating contact list panel...", 4);
                    Map map = ContactListPanel.this.allContactPanelsMap;
                    synchronized (map) {
                        Iterator iterator = ContactListPanel.this.allContactPanelsMap.values().iterator();
                        while (iterator.hasNext()) {
                            ContactPanel contactPanel = (ContactPanel)iterator.next();
                            contactPanel.updateInformation();
                        }
                    }
                    CoreLogger.log("updating done...", 4);
                }
            }
        };
        thread.setName("ContactListUpdater");
        thread.start();
    }

    public void addNewContactPanel(ContactInformation contactInformation) {
        CoreLogger.log("adding new panel for " + contactInformation.getNickname(), 2);
        Map map = this.allContactPanelsMap;
        synchronized (map) {
            ContactPanel contactPanel = new ContactPanel(contactInformation);
            this.allContactPanelsMap.put(contactInformation.getPublicKey(), contactPanel);
            this.contactsPanel.add(contactPanel);
            if (this.allContactPanelsMap.size() > this.contactsPanelGridLayout.getRows()) {
                this.contactsPanelGridLayout.setRows(this.allContactPanelsMap.size());
            }
        }
        this.validate();
        this.repaint();
    }

    void updateAllContactPanels() {
        Map map = this.allContactPanelsMap;
        synchronized (map) {
            Iterator iterator = this.allContactPanelsMap.values().iterator();
            ContactPanel contactPanel = (ContactPanel)iterator.next();
            contactPanel.updateInformation();
        }
    }

    void updateContactPanel(String string) {
        final ContactPanel contactPanel = (ContactPanel)this.allContactPanelsMap.get(string);
        if (contactPanel == null) {
            return;
        }
        CoreLogger.log("updating " + contactPanel.nickNamePanel.getText() + "'s channel status...", 4);
        Thread thread = new Thread(){

            public void run() {
                contactPanel.updateInformation();
            }
        };
        thread.setName("ContactPanelUpdateThread");
        thread.start();
    }

    public void setAnnouncementChannelStatusString(String string, String string2) {
        this.announcementChannelStatusLabel.setText(string);
        this.slotInfoLabel.setText(string2);
    }

    private void sortContactList(int n) {
        if (n == 0) {
            return;
        }
        this.currentSorting = n;
        LinkedList linkedList = new LinkedList(this.allContactPanelsMap.values());
        if (n == 1) {
            CoreLogger.log("sorting contact list by nick...", 2);
            Collections.sort(linkedList, ContactPanel.getNickNameComparator());
        }
        if (n == 2) {
            CoreLogger.log("sorting contact list by last activity...", 2);
            Collections.sort(linkedList, ContactPanel.getLastActivityComparator());
        }
        if (n == 3) {
            CoreLogger.log("sorting contact list by rating...", 2);
            Collections.sort(linkedList, ContactPanel.getRatingScoreComparator());
        }
        JPanel jPanel = this.contactsPanel;
        synchronized (jPanel) {
            this.contactsPanel.removeAll();
            int n2 = 0;
            while (n2 < linkedList.size()) {
                ((ContactPanel)linkedList.get(n2)).updateInformation();
                this.contactsPanel.add((ContactPanel)linkedList.get(n2));
                ++n2;
            }
        }
        this.contactsPanel.validate();
        this.contactsPanel.repaint();
    }

    private void jbInit() throws Exception {
        this.setLayout(this.contactListBorderLayout);
        this.announcementChannelStatusPanel.setLayout(this.announcementChannelStatusPanelBorderLayout);
        this.announcementChannelStatusCaptionLabel.setText("announcement channel:");
        this.announcementChannelStatusLabel.setFont(new Font("Dialog", 0, 9));
        this.announcementChannelStatusLabel.setForeground(Color.black);
        this.announcementChannelStatusLabel.setText("not listening");
        this.contactsPanelGridLayout.setRows(12);
        this.contactsPanelGridLayout.setColumns(1);
        this.contactsPanel.setLayout(this.contactsPanelGridLayout);
        this.setMinimumSize(new Dimension(200, 69));
        this.setPreferredSize(new Dimension(200, 65));
        this.slotInfoLabel.setFont(new Font("Monospaced", 0, 9));
        this.slotInfoLabel.setForeground(Color.black);
        this.slotInfoLabel.setText("000");
        this.startListeningMenuItem.setText("start listening on announcement channel");
        this.startListeningMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ContactListPanel.this.startListeningMenuItem_actionPerformed(actionEvent);
            }
        });
        this.stopListeningMenuItem.setText("stop listening on announcement channel");
        this.stopListeningMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ContactListPanel.this.stopListeningMenuItem_actionPerformed(actionEvent);
            }
        });
        this.announcementChannelStatusPanel.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                ContactListPanel.this.announcementChannelStatusPanel_mousePressed(mouseEvent);
            }
        });
        this.headerLabel.setHorizontalAlignment(0);
        this.headerLabel.setText("contact list");
        this.topPanel.setLayout(this.topPanelBorderLayout1);
        this.sortByComboBox.setFont(new Font("Dialog", 0, 9));
        this.sortByComboBox.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                ContactListPanel.this.sortByComboBox_mouseClicked(mouseEvent);
            }

            public void mousePressed(MouseEvent mouseEvent) {
                ContactListPanel.this.sortByComboBox_mousePressed(mouseEvent);
            }
        });
        this.sortByComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                ContactListPanel.this.sortByComboBox_itemStateChanged(itemEvent);
            }
        });
        this.add((Component)this.contactsScrollPane, "Center");
        this.contactsScrollPane.getViewport().add((Component)this.contactsPanel, null);
        this.add((Component)this.announcementChannelStatusPanel, "South");
        this.announcementChannelStatusPanel.add((Component)this.announcementChannelStatusLabel, "Center");
        this.announcementChannelStatusPanel.add((Component)this.slotInfoLabel, "South");
        this.announcementChannelStatusPanel.add((Component)this.announcementChannelStatusCaptionLabel, "North");
        this.add((Component)this.topPanel, "North");
        this.topPanel.add((Component)this.headerLabel, "Center");
        this.announcementChannelPopupMenu.add(this.startListeningMenuItem);
        this.announcementChannelPopupMenu.add(this.stopListeningMenuItem);
        this.topPanel.add((Component)this.sortByComboBox, "South");
        int n = 0;
        while (n < SORT_DESCRIPTIONS.length) {
            this.sortByComboBox.addItem(SORT_DESCRIPTIONS[n]);
            ++n;
        }
    }

    void stopListeningMenuItem_actionPerformed(ActionEvent actionEvent) {
        MessageGateway.instance().stopListeningOnPublicAnnouncementChannel();
    }

    void startListeningMenuItem_actionPerformed(ActionEvent actionEvent) {
        MessageGateway.instance().startListeningOnPublicAnnouncementChannel();
    }

    void announcementChannelStatusPanel_mousePressed(MouseEvent mouseEvent) {
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            this.announcementChannelPopupMenu.show(this.announcementChannelStatusPanel, mouseEvent.getPoint().x, mouseEvent.getPoint().y);
        }
    }

    void sortByComboBox_itemStateChanged(ItemEvent itemEvent) {
        CoreLogger.log("Item stated changed: " + itemEvent.getStateChange(), 2);
        this.sortContactList(this.sortByComboBox.getSelectedIndex());
    }

    void sortByComboBox_mouseClicked(MouseEvent mouseEvent) {
    }

    void sortByComboBox_mousePressed(MouseEvent mouseEvent) {
    }
}

