/*
 * Decompiled with CFR 0.152.
 */
package freenetmessageboard.gui;

import freenetmessageboard.core.ContactInformation;
import freenetmessageboard.core.ContactList;
import freenetmessageboard.core.PersonalInfo;
import freenetmessageboard.core.UserCommentMessage;
import freenetmessageboard.core.UserMessage;
import freenetmessageboard.gui.ColorsAndIcons;
import freenetmessageboard.gui.UserCommentMessagePanel;
import freenetmessageboard.gui.UserMessagePanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;

public class ContactInformationPanel
extends JPanel {
    BorderLayout mainBorderLayout = new BorderLayout();
    JPanel topPanel = new JPanel();
    JPanel bottomPanel = new JPanel();
    JPanel mainPanel = new JPanel();
    JSplitPane mainSlitPane = new JSplitPane();
    BorderLayout mainPanelBorderLayout = new BorderLayout();
    JPanel userMessagesPanel = new JPanel();
    JPanel commentsMessagesPanel = new JPanel();
    BorderLayout commentsMessagesPanelBorderLayout = new BorderLayout();
    JLabel commentsCaptionLabel = new JLabel();
    JLabel userMessagesCaptionLabel = new JLabel();
    JTabbedPane userMessagesTabbedPane = new JTabbedPane();
    JTabbedPane commentsMessagesTabbedPane = new JTabbedPane();
    BorderLayout userMessagesPanelBorderLayout = new BorderLayout();
    JPanel defaultDescriptionsPanel = new JPanel();
    JPanel defaultCommentsPanel = new JPanel();
    JLabel noCommentsLabel = new JLabel();
    BorderLayout bottomPanelBorderLayout = new BorderLayout();
    ContactInformation information;
    JButton refreshButton = new JButton();

    public ContactInformationPanel(ContactInformation contactInformation) {
        this();
        this.information = contactInformation;
        this.updateInformation();
    }

    void updateInformation() {
        UserMessage[] userMessageArray = this.information.getUserMessages();
        this.userMessagesTabbedPane.removeAll();
        int n = 0;
        while (n < userMessageArray.length) {
            if (n > 4) break;
            this.userMessagesTabbedPane.add(new UserMessagePanel(userMessageArray[n]));
            this.userMessagesTabbedPane.setTitleAt(n, userMessageArray[n].getDate());
            ++n;
        }
        this.userMessagesTabbedPane.validate();
        UserCommentMessage[] userCommentMessageArray = this.information.getUserCommentMessages();
        boolean bl = false;
        this.commentsMessagesTabbedPane.removeAll();
        if (userCommentMessageArray.length > 0) {
            this.commentsMessagesTabbedPane.removeAll();
            int n2 = 0;
            while (n2 < userCommentMessageArray.length) {
                if (userCommentMessageArray[n2].getOriginalPublicKey().equals(PersonalInfo.instance().getPublicKey())) {
                    this.commentsMessagesTabbedPane.add((Component)new UserCommentMessagePanel(userCommentMessageArray[n2], true), n2);
                    this.commentsMessagesTabbedPane.setTitleAt(n2, "your comment");
                    this.commentsMessagesTabbedPane.setIconAt(n2, ColorsAndIcons.getIconForRating(userCommentMessageArray[n2].getRating()));
                    bl = true;
                } else {
                    this.commentsMessagesTabbedPane.add(new UserCommentMessagePanel(userCommentMessageArray[n2]));
                    this.commentsMessagesTabbedPane.setTitleAt(n2, ContactList.instance().getNicknameOfPublicKey(userCommentMessageArray[n2].getOriginalPublicKey()));
                    this.commentsMessagesTabbedPane.setIconAt(n2, ColorsAndIcons.getIconForRating(userCommentMessageArray[n2].getRating()));
                }
                ++n2;
            }
        }
        if (!bl && !this.information.getPublicKey().equals(PersonalInfo.instance().getPublicKey())) {
            this.commentsMessagesTabbedPane.add((Component)new UserCommentMessagePanel(this.information.getPublicKey(), true), userCommentMessageArray.length);
            this.commentsMessagesTabbedPane.setTitleAt(userCommentMessageArray.length, "your comment");
            this.commentsMessagesTabbedPane.setIconAt(userCommentMessageArray.length, ColorsAndIcons.getIconForRating("any"));
        }
        this.repaint();
    }

    public ContactInformationPanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.mainBorderLayout);
        this.mainSlitPane.setOrientation(0);
        this.mainPanel.setLayout(this.mainPanelBorderLayout);
        this.commentsMessagesPanel.setLayout(this.commentsMessagesPanelBorderLayout);
        this.commentsCaptionLabel.setOpaque(true);
        this.commentsCaptionLabel.setText("comments from other users:");
        this.userMessagesCaptionLabel.setOpaque(true);
        this.userMessagesCaptionLabel.setText("self descriptions from this user:");
        this.userMessagesPanel.setLayout(this.userMessagesPanelBorderLayout);
        this.noCommentsLabel.setText("no comments have been received on this user");
        this.setMaximumSize(new Dimension(800, 600));
        this.setMinimumSize(new Dimension(300, 200));
        this.setPreferredSize(new Dimension(400, 300));
        this.userMessagesTabbedPane.setBackground(UIManager.getColor("Panel.background"));
        this.userMessagesTabbedPane.setForeground(new Color(102, 102, 153));
        this.userMessagesTabbedPane.setOpaque(true);
        this.commentsMessagesTabbedPane.setBackground(UIManager.getColor("Panel.background"));
        this.commentsMessagesTabbedPane.setForeground(new Color(102, 102, 153));
        this.commentsMessagesTabbedPane.setOpaque(true);
        this.bottomPanel.setLayout(this.bottomPanelBorderLayout);
        this.refreshButton.setFont(new Font("Dialog", 0, 9));
        this.refreshButton.setText("refresh self-descriptions and comments");
        this.refreshButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ContactInformationPanel.this.refreshButton_actionPerformed(actionEvent);
            }
        });
        this.add((Component)this.topPanel, "North");
        this.add((Component)this.bottomPanel, "South");
        this.bottomPanel.add((Component)this.refreshButton, "Center");
        this.add((Component)this.mainPanel, "Center");
        this.mainPanel.add((Component)this.mainSlitPane, "Center");
        this.mainSlitPane.add((Component)this.userMessagesPanel, "top");
        this.mainSlitPane.add((Component)this.commentsMessagesPanel, "bottom");
        this.commentsMessagesPanel.add((Component)this.commentsCaptionLabel, "North");
        this.userMessagesPanel.add((Component)this.userMessagesCaptionLabel, "North");
        this.userMessagesPanel.add((Component)this.userMessagesTabbedPane, "Center");
        this.userMessagesTabbedPane.add((Component)this.defaultDescriptionsPanel, "jPanel1");
        this.commentsMessagesPanel.add((Component)this.commentsMessagesTabbedPane, "Center");
        this.commentsMessagesTabbedPane.add((Component)this.defaultCommentsPanel, "no comments");
        this.defaultCommentsPanel.add((Component)this.noCommentsLabel, null);
    }

    void refreshButton_actionPerformed(ActionEvent actionEvent) {
        this.updateInformation();
    }
}

