/*
 * Decompiled with CFR 0.152.
 */
package freenetmessageboard.gui;

import freenetmessageboard.core.ChessLounge;
import freenetmessageboard.core.ChessMessage;
import freenetmessageboard.core.MessageGateway;
import freenetmessageboard.gui.TableSorter;
import freenetmessageboard.schach.SchachSpiel;
import freenetmessageboard.schach.SchachTestFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;

public class ChessLoungepanel
extends JPanel {
    BorderLayout mainBorderLayout = new BorderLayout();
    JScrollPane currentGamesScrollPane;
    JPanel bottomPanel = new JPanel();
    JButton startGameButton = new JButton();
    JComboBox opponentComboBox;
    BorderLayout bottomPanelBorderLayout = new BorderLayout();
    JButton addToOpponentListButton = new JButton();
    JTable currentGamesTable;
    JPopupMenu chessGamesPopUpMenu = new JPopupMenu();
    JMenuItem showGameMenuItem = new JMenuItem();
    JCheckBox showGamesCheckBox = new JCheckBox();

    public ChessLoungepanel() {
        this.opponentComboBox = new JComboBox(ChessLounge.instance());
        TableSorter tableSorter = new TableSorter(ChessLounge.instance());
        this.currentGamesTable = new JTable(tableSorter);
        tableSorter.addMouseListenerToHeaderInTable(this.currentGamesTable);
        this.currentGamesScrollPane = new JScrollPane(this.currentGamesTable);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.mainBorderLayout);
        this.startGameButton.setFont(new Font("Dialog", 0, 10));
        this.startGameButton.setText("play game");
        this.startGameButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChessLoungepanel.this.startGameButton_actionPerformed(actionEvent);
            }
        });
        this.bottomPanel.setLayout(this.bottomPanelBorderLayout);
        this.addToOpponentListButton.setFont(new Font("Dialog", 0, 10));
        this.addToOpponentListButton.setText("add me to that list");
        this.addToOpponentListButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChessLoungepanel.this.addToOpponentListButton_actionPerformed(actionEvent);
            }
        });
        this.opponentComboBox.setFont(new Font("Dialog", 0, 10));
        this.currentGamesTable.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                ChessLoungepanel.this.currentGamesTable_mousePressed(mouseEvent);
            }
        });
        this.showGameMenuItem.setText("show this game");
        this.showGameMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChessLoungepanel.this.showGameMenuItem_actionPerformed(actionEvent);
            }
        });
        this.showGamesCheckBox.setHorizontalAlignment(0);
        this.showGamesCheckBox.setText("show a popup frame whenever it's my turn in a game");
        this.showGamesCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChessLoungepanel.this.showGamesCheckBox_actionPerformed(actionEvent);
            }
        });
        this.add((Component)this.currentGamesScrollPane, "Center");
        this.currentGamesScrollPane.getViewport().add((Component)this.currentGamesTable, null);
        this.add((Component)this.bottomPanel, "North");
        this.bottomPanel.add((Component)this.opponentComboBox, "West");
        this.bottomPanel.add((Component)this.startGameButton, "Center");
        this.bottomPanel.add((Component)this.addToOpponentListButton, "East");
        this.add((Component)this.showGamesCheckBox, "South");
        this.chessGamesPopUpMenu.add(this.showGameMenuItem);
    }

    void addToOpponentListButton_actionPerformed(ActionEvent actionEvent) {
        ChessMessage chessMessage = new ChessMessage();
        MessageGateway.instance().sendMessageOnPersonalChannel(chessMessage);
    }

    void startGameButton_actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = this.opponentComboBox.getModel().getSelectedItem();
            if (!(object instanceof ChessMessage)) {
                return;
            }
            String string = ((ChessMessage)object).getBlackKey();
            SchachSpiel schachSpiel = new SchachSpiel(string);
            SchachTestFrame schachTestFrame = new SchachTestFrame(schachSpiel);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    void currentGamesTable_mousePressed(MouseEvent mouseEvent) {
        if (SwingUtilities.isRightMouseButton(mouseEvent) && this.currentGamesTable.getSelectedRow() != -1) {
            this.chessGamesPopUpMenu.show(this.currentGamesTable, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    void showGameMenuItem_actionPerformed(ActionEvent actionEvent) {
        int n = ((TableSorter)this.currentGamesTable.getModel()).getRealIndex(this.currentGamesTable.getSelectedRow());
        if (n != -1) {
            ChessLounge.instance().showGame(n);
        }
    }

    void showGamesCheckBox_actionPerformed(ActionEvent actionEvent) {
        ChessLounge.instance().informMeWhenItsMyTurn(this.showGamesCheckBox.isSelected());
    }
}

