/*
 * Decompiled with CFR 0.152.
 */
package freenetmessageboard.gui;

import freenetmessageboard.core.CoreLogger;
import freenetmessageboard.core.MessageArchive;
import freenetmessageboard.core.MessageArchiveReceiver;
import freenetmessageboard.core.MessageArchiveTransmitter;
import freenetmessageboard.core.MessageFilter;
import freenetmessageboard.core.MessageGateway;
import freenetmessageboard.core.MessagePool;
import freenetmessageboard.core.NewsgroupDataModel;
import freenetmessageboard.core.NewsgroupPost;
import freenetmessageboard.core.PostMessage;
import freenetmessageboard.gui.BetaGUI;
import freenetmessageboard.gui.ChessLoungepanel;
import freenetmessageboard.gui.NewsgroupPostTreeCellRenderer;
import freenetmessageboard.gui.PostMessagePanel;
import freenetmessageboard.gui.TableSorter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class BoardContentPanel
extends JPanel {
    JTabbedPane mainTabbedPane = new JTabbedPane();
    BorderLayout mainBorderLayout = new BorderLayout();
    JButton newMessageButton = new JButton();
    JScrollPane treeViewScrollPane = new JScrollPane();
    JScrollPane tableViewScrollPane = new JScrollPane();
    JTable postsTable = new JTable();
    JTree postsTree = new JTree();
    boolean isMouseDown = false;
    int lastSelectedMsg = -1;
    JPanel archivePanel = new JPanel();
    JScrollPane archiveScrollPane = new JScrollPane();
    JTable archivesTable = new JTable();
    BorderLayout archivePanelBorderLayout = new BorderLayout();
    JButton insertArchiveButton = new JButton();
    JPopupMenu archiveRequestsPopupMenu = new JPopupMenu();
    JMenuItem requestArchiveMenuItem = new JMenuItem();
    boolean treeViewSelected = true;
    ChessLoungepanel chessLoungepanel1 = new ChessLoungepanel();

    public BoardContentPanel() {
        try {
            this.jbInit();
            TableSorter tableSorter = new TableSorter(NewsgroupDataModel.instance());
            tableSorter.addMouseListenerToHeaderInTable(this.postsTable);
            this.postsTable.setModel(tableSorter);
            this.postsTable.setSelectionMode(0);
            this.postsTable.setAutoResizeMode(2);
            this.postsTable.getColumnModel().getColumn(0).setPreferredWidth(20);
            this.postsTable.getColumnModel().getColumn(0).setMaxWidth(20);
            this.postsTable.getColumnModel().getColumn(1).setPreferredWidth(75);
            this.postsTable.getColumnModel().getColumn(1).setMaxWidth(250);
            this.postsTable.getColumnModel().getColumn(2).setPreferredWidth(120);
            this.postsTable.getColumnModel().getColumn(2).setMaxWidth(600);
            this.postsTable.getColumnModel().getColumn(3).setPreferredWidth(140);
            this.postsTable.getColumnModel().getColumn(3).setMaxWidth(140);
            this.postsTable.getColumnModel().getColumn(4).setPreferredWidth(80);
            this.postsTable.getColumnModel().getColumn(4).setMaxWidth(200);
            this.archivesTable.setModel(MessageArchiveReceiver.instance());
            this.archivesTable.setSelectionMode(0);
            this.archivesTable.getColumnModel().getColumn(2).setPreferredWidth(30);
            this.archivesTable.getColumnModel().getColumn(2).setMaxWidth(40);
            this.archivesTable.getColumnModel().getColumn(3).setPreferredWidth(30);
            this.archivesTable.getColumnModel().getColumn(3).setMaxWidth(40);
            this.archivesTable.getColumnModel().getColumn(4).setPreferredWidth(40);
            this.archivesTable.getColumnModel().getColumn(4).setMaxWidth(50);
            this.postsTree.setModel(NewsgroupDataModel.instance());
            this.postsTree.setCellRenderer(new NewsgroupPostTreeCellRenderer());
            this.addTreeSelectionListener();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void addTreeSelectionListener() {
        this.postsTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                try {
                    JTree jTree = (JTree)treeSelectionEvent.getSource();
                    NewsgroupPost newsgroupPost = (NewsgroupPost)jTree.getLastSelectedPathComponent();
                    if (newsgroupPost == null) {
                        return;
                    }
                    CoreLogger.log("selected node: " + newsgroupPost.toString(), 2);
                    if (newsgroupPost.getPostMessage() != null) {
                        BetaGUI.instance().showPostMessage(newsgroupPost.getPostMessage());
                    }
                }
                catch (Throwable throwable) {
                    CoreLogger.log("exception while getting selected node: " + throwable.getClass() + ": " + throwable.getMessage(), 0);
                }
            }
        });
    }

    private void jbInit() throws Exception {
        this.setLayout(this.mainBorderLayout);
        this.newMessageButton.setText("create new message");
        this.newMessageButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BoardContentPanel.this.newMessageButton_actionPerformed(actionEvent);
            }
        });
        this.postsTable.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                BoardContentPanel.this.postsTable_mousePressed(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                BoardContentPanel.this.postsTable_mouseReleased(mouseEvent);
            }
        });
        this.archivePanel.setLayout(this.archivePanelBorderLayout);
        this.insertArchiveButton.setFont(new Font("Dialog", 0, 9));
        this.insertArchiveButton.setText("insert message archive");
        this.insertArchiveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BoardContentPanel.this.insertArchiveButton_actionPerformed(actionEvent);
            }
        });
        this.requestArchiveMenuItem.setText("request archive");
        this.requestArchiveMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BoardContentPanel.this.requestArchiveMenuItem_actionPerformed(actionEvent);
            }
        });
        this.archivesTable.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                BoardContentPanel.this.archivesTable_mousePressed(mouseEvent);
            }
        });
        this.mainTabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                BoardContentPanel.this.mainTabbedPane_stateChanged(changeEvent);
            }
        });
        this.add((Component)this.mainTabbedPane, "Center");
        this.mainTabbedPane.add((Component)this.treeViewScrollPane, "tree view");
        this.mainTabbedPane.add((Component)this.tableViewScrollPane, "table view");
        this.mainTabbedPane.add((Component)this.archivePanel, "archives");
        this.mainTabbedPane.add((Component)this.chessLoungepanel1, "chess lounge");
        this.add((Component)this.newMessageButton, "South");
        this.tableViewScrollPane.getViewport().add((Component)this.postsTable, null);
        this.treeViewScrollPane.getViewport().add((Component)this.postsTree, null);
        this.archivePanel.add((Component)this.archiveScrollPane, "Center");
        this.archiveScrollPane.getViewport().add((Component)this.archivesTable, null);
        this.archivePanel.add((Component)this.insertArchiveButton, "South");
        this.chessLoungepanel1.validate();
        this.archiveRequestsPopupMenu.add(this.requestArchiveMenuItem);
    }

    void newMessageButton_actionPerformed(ActionEvent actionEvent) {
        PostMessagePanel postMessagePanel = new PostMessagePanel();
        postMessagePanel.setEditable(true);
        BetaGUI.instance().newFrame("create new message", postMessagePanel);
    }

    void postsTable_mouseReleased(MouseEvent mouseEvent) {
        this.isMouseDown = false;
        this.showSelectedMessage();
    }

    void showSelectedMessage() {
        int n = ((TableSorter)this.postsTable.getModel()).getRealIndex(this.postsTable.getSelectedRow());
        if (n != this.lastSelectedMsg) {
            this.lastSelectedMsg = n;
            if (n < 0 || n >= this.postsTable.getModel().getRowCount()) {
                return;
            }
            BetaGUI.instance().showPostMessage(NewsgroupDataModel.instance().getPostMessageInRow(n));
        }
    }

    void postsTable_mousePressed(MouseEvent mouseEvent) {
        this.isMouseDown = true;
        this.showSelectedMessage();
    }

    void insertArchiveButton_actionPerformed(ActionEvent actionEvent) {
        try {
            MessageArchive messageArchive = MessagePool.instance().createArchive(MessageFilter.originalNonArchiveMessagesOnlyFilter());
            MessageArchiveTransmitter.instance().insertArchive(messageArchive, MessageGateway.uriDateFormat.format(new Date()));
            this.insertArchiveButton.setText("inserting...");
            this.insertArchiveButton.setEnabled(false);
        }
        catch (Throwable throwable) {
            this.insertArchiveButton.setText("failed to insert archive: " + throwable.getClass() + ": " + throwable.getMessage());
        }
    }

    void requestArchiveMenuItem_actionPerformed(ActionEvent actionEvent) {
        int n = this.archivesTable.getSelectedRow();
        if (n != -1) {
            MessageArchiveReceiver.instance().requestArchive(n);
        }
    }

    void archivesTable_mousePressed(MouseEvent mouseEvent) {
        if (SwingUtilities.isRightMouseButton(mouseEvent) && this.archivesTable.getSelectedRow() != -1) {
            this.archiveRequestsPopupMenu.show(this.archivesTable, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    void selectCurrentMessageInTreeView() {
        PostMessage postMessage = BetaGUI.instance().getCurrentlyDisplayedPostMessage();
        if (postMessage == null) {
            return;
        }
        NewsgroupPost newsgroupPost = NewsgroupDataModel.instance().getTreeNodeForMessage(postMessage);
        TreePath treePath = NewsgroupDataModel.instance().getPathToRoot(newsgroupPost);
        this.postsTree.setSelectionPath(treePath);
        this.postsTree.expandRow(this.postsTree.getRowForPath(treePath));
        this.postsTree.scrollPathToVisible(treePath);
    }

    void mainTabbedPane_stateChanged(ChangeEvent changeEvent) {
        CoreLogger.log("switched the tabbed pane: " + changeEvent, 2);
        if (this.mainTabbedPane.getSelectedComponent().equals(this.treeViewScrollPane)) {
            if (!this.treeViewSelected) {
                this.treeViewSelected = true;
                this.selectCurrentMessageInTreeView();
            }
        } else {
            this.treeViewSelected = false;
        }
    }
}

