/*
 * Decompiled with CFR 0.152.
 */
package freenetmessageboard.gui;

import freenetmessageboard.core.ContactInformation;
import freenetmessageboard.core.CoreLogger;
import freenetmessageboard.core.Message;
import freenetmessageboard.core.NewsgroupDataModel;
import freenetmessageboard.core.PersonalInfo;
import freenetmessageboard.core.PostMessage;
import freenetmessageboard.gui.ContactListPanel;
import freenetmessageboard.gui.FMBMainFrame;
import freenetmessageboard.gui.GUIInterface;
import freenetmessageboard.gui.MessageVerificationFrame;
import freenetmessageboard.gui.NewsgroupPostTreeCellRenderer;
import freenetmessageboard.gui.PersonalInfoDialog;
import freenetmessageboard.gui.PostMessagePanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.tree.TreeCellRenderer;

public class BetaGUI
implements GUIInterface {
    private static BetaGUI instance;
    private FMBMainFrame mainFrame = new FMBMainFrame();
    private TreeCellRenderer treeCellRenderer = new NewsgroupPostTreeCellRenderer();
    Dimension defaultFrameSize = new Dimension(650, 650);
    Point defaultFrameLocation;
    boolean isActive = false;
    private MessageVerificationFrame verificatonFrame = new MessageVerificationFrame();
    private PostMessage displayedMessage;

    private BetaGUI() {
        this.mainFrame.setSize(800, 600);
        this.mainFrame.setLocation(200, 200);
        this.defaultFrameLocation = new Point(this.mainFrame.getLocation().x + 15, this.mainFrame.getLocation().y + 15);
    }

    public void showPersonalInformationDialog(PersonalInfo personalInfo) {
        CoreLogger.log("creating personal info dialog", 1);
        PersonalInfoDialog personalInfoDialog = new PersonalInfoDialog(this.getMainFrame());
        personalInfoDialog.publicKeyTextField.setText(personalInfo.getPublicKey());
        personalInfoDialog.privateKeyTextField.setText(personalInfo.getPrivateKey());
        personalInfoDialog.nickTextField.setText(personalInfo.getNickname());
        personalInfoDialog.nameTextField.setText(personalInfo.getName());
        personalInfoDialog.freesiteUriTextField.setText(personalInfo.getFreesiteUri());
        personalInfoDialog.interestsTextField.setText(personalInfo.getInterests());
        personalInfoDialog.descriptionTextArea.setText(personalInfo.getDescription());
        personalInfoDialog.messageTextArea.setText(personalInfo.getMessage());
        CoreLogger.log("showing personal info dialog", 1);
        personalInfoDialog.show();
        if (personalInfoDialog.wasCancelled()) {
            CoreLogger.log("the personal info dialog was cancelled", 4);
        } else {
            CoreLogger.log("the personal info dialog was confirmed", 4);
            personalInfo.updateInfoFromDialog(personalInfoDialog);
        }
    }

    public void activateGUI() {
        this.mainFrame.setVisible(true);
        this.isActive = true;
    }

    public FMBMainFrame getMainFrame() {
        return this.mainFrame;
    }

    public void verifyMessage(Message message, Message message2) {
        this.verificatonFrame.verifyMessage(message, message2);
        if (!this.verificatonFrame.isVisible()) {
            this.verificatonFrame.setVisible(true);
        }
    }

    public void setVerifyingRating(Message message, String string) {
        this.verificatonFrame.showVerificationRating(message, string);
    }

    public void removeVerification(Message message) {
        this.verificatonFrame.removeMessage(message);
    }

    public void verifyMessage(Message message) {
        this.verificatonFrame.verifyMessage(message);
        if (!this.verificatonFrame.isVisible()) {
            this.verificatonFrame.setVisible(true);
        }
    }

    public void setInsertArchiveStatusString(String string, boolean bl) {
        if (bl) {
            this.mainFrame.boardContentPanel.insertArchiveButton.setEnabled(bl);
        }
        this.mainFrame.boardContentPanel.insertArchiveButton.setText(string);
    }

    public void showPanel(JPanel jPanel) {
        this.mainFrame.mainPanel.removeAll();
        this.mainFrame.mainPanel.add((Component)jPanel, "Center");
        this.mainFrame.validate();
        this.mainFrame.mainPanel.repaint();
    }

    PostMessage getCurrentlyDisplayedPostMessage() {
        return this.displayedMessage;
    }

    public void showPostMessage(PostMessage postMessage) {
        this.displayedMessage = postMessage;
        NewsgroupDataModel.instance().markAsRead(postMessage.getUniqueId());
        if (this.mainFrame.mainPanel.getComponentCount() > 0 && this.mainFrame.mainPanel.getComponent(0) instanceof PostMessagePanel) {
            ((PostMessagePanel)this.mainFrame.mainPanel.getComponent(0)).updateInformationFrom(postMessage);
            return;
        }
        this.mainFrame.mainPanel.removeAll();
        this.mainFrame.mainPanel.add(new PostMessagePanel(postMessage, false));
        this.mainFrame.jSplitPane1.validate();
        this.mainFrame.mainPanel.repaint();
    }

    public void updateBoardContentView() {
    }

    TreeCellRenderer getTreeCellRenderer() {
        return this.treeCellRenderer;
    }

    public void updateContactPanel(String string) {
        if (this.isActive) {
            this.mainFrame.contactListPanel.updateContactPanel(string);
        }
    }

    public void newFrame(String string, JPanel jPanel) {
        final JFrame jFrame = new JFrame(string);
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                BetaGUI.instance().defaultFrameSize = jFrame.getSize();
                BetaGUI.instance().defaultFrameLocation = jFrame.getLocation();
                jFrame.dispose();
            }
        });
        jFrame.getContentPane().add(jPanel);
        jFrame.setSize(this.defaultFrameSize);
        jFrame.setLocation(this.defaultFrameLocation);
        jFrame.show();
    }

    public boolean showConfirmDialog(String string, String string2) {
        int n = JOptionPane.showConfirmDialog(this.mainFrame, string, string2, 0, 2);
        return n == 0;
    }

    public void addContactPanel(ContactInformation contactInformation) {
        this.mainFrame.contactListPanel.addNewContactPanel(contactInformation);
    }

    public void setAnnouncementChannelStatusString(String string, String string2) {
        this.mainFrame.contactListPanel.setAnnouncementChannelStatusString(string, string2);
    }

    public ContactListPanel getContactListPanel() {
        return this.mainFrame.contactListPanel;
    }

    public static synchronized BetaGUI instance() {
        if (instance == null) {
            try {
                UIManager.setLookAndFeel(UIManager.getInstalledLookAndFeels()[0].getClassName());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            instance = new BetaGUI();
        }
        return instance;
    }
}

