/*
 * Decompiled with CFR 0.152.
 */
package freenetmessageboard.fcpinterface;

import freenetmessageboard.fcpinterface.BadMessageFormatException;
import freenetmessageboard.fcpinterface.FCPDataFoundMessage;
import freenetmessageboard.fcpinterface.FCPDataNotFoundMessage;
import freenetmessageboard.fcpinterface.FCPFailedMessage;
import freenetmessageboard.fcpinterface.FCPFormatErrorMessage;
import freenetmessageboard.fcpinterface.FCPKeyCollisionMessage;
import freenetmessageboard.fcpinterface.FCPLogger;
import freenetmessageboard.fcpinterface.FCPMessage;
import freenetmessageboard.fcpinterface.FCPNodeHelloMessage;
import freenetmessageboard.fcpinterface.FCPPendingMessage;
import freenetmessageboard.fcpinterface.FCPResponse;
import freenetmessageboard.fcpinterface.FCPRestartedMessage;
import freenetmessageboard.fcpinterface.FCPRouteNotFoundMessage;
import freenetmessageboard.fcpinterface.FCPSizeErrorMessage;
import freenetmessageboard.fcpinterface.FCPSuccessMessage;
import freenetmessageboard.fcpinterface.FCPUriErrorMessage;
import freenetmessageboard.fcpinterface.FieldNotFoundException;
import freenetmessageboard.fcpinterface.ResponseNotKnownException;
import freenetmessageboard.fcpinterface.ResponseNotReadableException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;

class FCPUtils {
    FCPUtils() {
    }

    static boolean checkUriSyntax(String string) {
        try {
            String string2 = string.toLowerCase();
            if (string2.startsWith("freenet:")) {
                string2 = string2.substring(string2.indexOf(":") + 1);
            }
            if (string.indexOf("@") >= 0) {
                if (string2.startsWith("msk@")) {
                    string2 = string2.substring(string2.indexOf(":") + 1);
                }
                if (string2.startsWith("ksk@")) {
                    return true;
                }
                if (string2.startsWith("chk@")) {
                    return true;
                }
                return string2.startsWith("ssk@");
            }
            return true;
        }
        catch (NullPointerException nullPointerException) {
            System.err.println("NullPointerException while parsing " + string);
            return false;
        }
    }

    static FCPResponse parseResponse(byte[] byArray) throws ResponseNotReadableException, ResponseNotKnownException, BadMessageFormatException {
        String string = FCPUtils.getMessageHeader(byArray);
        if (string.equals(FCPMessage.nodeHelloMessageHeader)) {
            return new FCPNodeHelloMessage(byArray);
        }
        if (string.equals(FCPMessage.successHeader)) {
            return new FCPSuccessMessage(byArray);
        }
        if (string.equals(FCPMessage.failedHeader)) {
            return new FCPFailedMessage(byArray);
        }
        if (string.equals(FCPMessage.pendingHeader)) {
            return new FCPPendingMessage(byArray);
        }
        if (string.equals(FCPMessage.formatErrorHeader)) {
            return new FCPFormatErrorMessage(byArray);
        }
        if (string.equals(FCPMessage.dataFoundHeader)) {
            return new FCPDataFoundMessage(byArray);
        }
        if (string.equals(FCPMessage.dataNotFoundHeader)) {
            return new FCPDataNotFoundMessage(byArray);
        }
        if (string.equals(FCPMessage.routeNotFoundHeader)) {
            return new FCPRouteNotFoundMessage(byArray);
        }
        if (string.equals(FCPMessage.uriErrorHeader)) {
            return new FCPUriErrorMessage(byArray);
        }
        if (string.equals(FCPMessage.restartedHeader)) {
            return new FCPRestartedMessage(byArray);
        }
        if (string.equals(FCPMessage.keyCollisionHeader)) {
            return new FCPKeyCollisionMessage(byArray);
        }
        if (string.equals(FCPMessage.sizeErrorHeader)) {
            return new FCPSizeErrorMessage(byArray);
        }
        FCPLogger.log(new FCPUtils(), "unknown response type: " + string, FCPLogger.ERROR);
        throw new ResponseNotKnownException();
    }

    static String findField(byte[] byArray, String string) throws FieldNotFoundException {
        FCPLogger.log(new FCPUtils(), " looking for " + string + " in " + new String(byArray), FCPLogger.DEBUG);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        InputStreamReader inputStreamReader = new InputStreamReader(byteArrayInputStream);
        LineNumberReader lineNumberReader = new LineNumberReader(inputStreamReader);
        try {
            String string2 = lineNumberReader.readLine();
            while (string2 != null) {
                if (string2.startsWith(string + "=")) {
                    return string2.substring(string2.indexOf("=") + 1);
                }
                string2 = lineNumberReader.readLine();
            }
        }
        catch (IOException iOException) {
            throw new FieldNotFoundException();
        }
        throw new FieldNotFoundException();
    }

    private static String getMessageHeader(byte[] byArray) throws ResponseNotReadableException {
        String string;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, 0, 40);
        InputStreamReader inputStreamReader = new InputStreamReader(byteArrayInputStream);
        LineNumberReader lineNumberReader = new LineNumberReader(inputStreamReader);
        try {
            string = lineNumberReader.readLine();
        }
        catch (IOException iOException) {
            throw new ResponseNotReadableException();
        }
        return string;
    }

    static String getClassNameOnly(Object object) {
        String string = object.getClass().getName();
        string = string.substring(string.lastIndexOf(".") + 1);
        return string;
    }
}

