/*
 * Decompiled with CFR 0.152.
 */
package freenetmessageboard.fcpinterface;

import freenetmessageboard.fcpinterface.FCPConfig;
import freenetmessageboard.fcpinterface.FCPMessage;
import freenetmessageboard.fcpinterface.FCPResponse;
import freenetmessageboard.fcpinterface.FieldNotFoundException;

class FCPSuccessMessage
extends FCPResponse {
    private String uri;
    private String privateKey;
    private String publicKey;

    FCPSuccessMessage(byte[] byArray) {
        super(FCPMessage.successHeader, byArray);
        try {
            this.uri = super.findValueString("URI");
        }
        catch (FieldNotFoundException fieldNotFoundException) {
            // empty catch block
        }
        try {
            this.privateKey = super.findValueString("PrivateKey");
        }
        catch (FieldNotFoundException fieldNotFoundException) {
            // empty catch block
        }
        try {
            this.publicKey = super.findValueString("PublicKey");
        }
        catch (FieldNotFoundException fieldNotFoundException) {
            // empty catch block
        }
    }

    String getPrivateKey() {
        return this.privateKey;
    }

    String getPublicKey() {
        if (FCPConfig.isFreenet0_4()) {
            return this.publicKey + "PAgM";
        }
        return this.publicKey + "QAgE";
    }

    String getUri() {
        return this.uri;
    }

    String getMessageInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.uri != null) {
            stringBuffer.append("uri: " + this.uri + " / ");
        }
        if (this.privateKey != null) {
            stringBuffer.append(" keys were generated. ");
        }
        return stringBuffer.toString();
    }
}

