/*
 * Decompiled with CFR 0.152.
 */
package freenetmessageboard.fcpinterface;

import freenetmessageboard.fcpinterface.ConnectionUnsuccesfullException;
import freenetmessageboard.fcpinterface.FCPClientPutConnection;
import freenetmessageboard.fcpinterface.FCPFacade;
import freenetmessageboard.fcpinterface.FCPKeyCollisionMessage;
import freenetmessageboard.fcpinterface.FCPLogger;
import freenetmessageboard.fcpinterface.FCPResponse;
import freenetmessageboard.fcpinterface.FCPSuccessMessage;

public class FCPRedirectClientPutConnection
extends FCPClientPutConnection {
    FCPClientPutConnection redirectClientPutConnection;
    private String redirectUri;
    private int htl;

    public FCPRedirectClientPutConnection(String string, int n, byte[] byArray, byte[] byArray2) {
        super("CHK@", n, byArray, byArray2);
        this.redirectUri = string;
        this.htl = n;
    }

    public boolean connect() throws ConnectionUnsuccesfullException {
        FCPLogger.log(this, "starting redirecting client put connection to " + this.redirectUri, FCPLogger.INTERFACE_NORMAL);
        FCPLogger.log(this, "inserting data to a CHK@...", FCPLogger.INTERFACE_NORMAL);
        boolean bl = super.connect();
        if (bl || this.lastResponse instanceof FCPKeyCollisionMessage) {
            String string;
            FCPResponse fCPResponse;
            if (this.lastResponse instanceof FCPSuccessMessage) {
                fCPResponse = (FCPSuccessMessage)this.lastResponse;
                string = ((FCPSuccessMessage)fCPResponse).getUri();
            } else {
                fCPResponse = (FCPKeyCollisionMessage)super.getLastResponse();
                string = ((FCPKeyCollisionMessage)fCPResponse).getUri();
            }
            FCPLogger.log(this, "inserting redirect: " + this.redirectUri + " > " + string, FCPLogger.INTERFACE_NORMAL);
            this.redirectClientPutConnection = new FCPClientPutConnection(this.redirectUri, this.htl, new byte[0], FCPFacade.instance().getRedirectMetaBytes(string, "application/zip"));
            boolean bl2 = this.redirectClientPutConnection.connect();
            if (bl2) {
                FCPLogger.log(this, "the insert to " + this.redirectUri + " was succesful.", FCPLogger.INTERFACE_NORMAL);
            } else {
                FCPLogger.log(this, "the insert to " + this.redirectUri + " failed: ", FCPLogger.INTERFACE_WARNING);
                FCPLogger.log(this, this.redirectClientPutConnection.lastResponse.getMessageInfo(), FCPLogger.INTERFACE_WARNING);
            }
            this.lastResponse = this.redirectClientPutConnection.lastResponse;
            return bl2;
        }
        return false;
    }
}

