/*
 * Decompiled with CFR 0.152.
 */
package freenetmessageboard.fcpinterface;

import freenetmessageboard.fcpinterface.ConnectionUnsuccesfullException;
import freenetmessageboard.fcpinterface.FCPClientGetConnection;
import freenetmessageboard.fcpinterface.FCPException;
import freenetmessageboard.fcpinterface.FCPLogger;
import freenetmessageboard.fcpinterface.FCPUtils;
import freenetmessageboard.fcpinterface.UnknownDatedBasedRedirectException;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;

class FCPRedirectClientGetConnection
extends FCPClientGetConnection {
    FCPRedirectClientGetConnection(String string, int n) {
        super(string, n);
    }

    private String getFixedLengthIntString(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(Integer.toString(n));
        int n3 = stringBuffer.length();
        while (n3 < n2) {
            stringBuffer.insert(0, "0");
            ++n3;
        }
        return stringBuffer.toString();
    }

    private String getDateBasedRedirectionURI(String string, long l, long l2) throws UnknownDatedBasedRedirectException {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        ((Calendar)gregorianCalendar).setTimeZone(TimeZone.getTimeZone("GMT"));
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string.substring(0, string.indexOf("/") + 1));
        FCPLogger.log(this, "beginning of key is " + stringBuffer.toString(), FCPLogger.DEBUG);
        stringBuffer.append(this.getFixedLengthIntString(gregorianCalendar.get(1), 4));
        stringBuffer.append(this.getFixedLengthIntString(gregorianCalendar.get(2) + 1, 2));
        stringBuffer.append(this.getFixedLengthIntString(gregorianCalendar.get(5), 2));
        FCPLogger.log(this, "...with date:" + stringBuffer.toString(), FCPLogger.DEBUG);
        if (l2 != 86400L) {
            throw new UnknownDatedBasedRedirectException();
        }
        stringBuffer.append("000000-");
        FCPLogger.log(this, "...with seconds:" + stringBuffer.toString(), FCPLogger.DEBUG);
        stringBuffer.append(string.substring(string.indexOf("/") + 1));
        FCPLogger.log(this, "complete:" + stringBuffer.toString(), FCPLogger.DEBUG);
        return stringBuffer.toString();
    }

    boolean connect() throws ConnectionUnsuccesfullException {
        try {
            boolean bl = false;
            block4: while (!bl) {
                String string;
                boolean bl2 = super.connect();
                if (!bl2) {
                    return false;
                }
                FCPLogger.log(this, "received: " + this.uri, FCPLogger.INFO);
                if (super.getMetaData() == null) {
                    return true;
                }
                LineNumberReader lineNumberReader = new LineNumberReader(new StringReader(new String(super.getMetaData())));
                bl = true;
                while ((string = lineNumberReader.readLine()) != null) {
                    FCPLogger.log(this, "metadata line: " + string, FCPLogger.INFO);
                    if (!string.startsWith("Redirect.Target=")) continue;
                    String string2 = string.substring(string.indexOf("=") + 1);
                    FCPLogger.log(this, "following redirect to " + string2, FCPLogger.NORMAL);
                    if (this.uri.equals(string2)) continue;
                    this.uri = string2;
                    bl = false;
                    continue block4;
                }
            }
            return true;
        }
        catch (ConnectionUnsuccesfullException connectionUnsuccesfullException) {
            throw connectionUnsuccesfullException;
        }
        catch (FCPException fCPException) {
            FCPLogger.log(this, FCPUtils.getClassNameOnly(fCPException) + " occured while checking redirects " + this.uri + ":" + fCPException.getMessage(), FCPLogger.WARNING);
            throw new ConnectionUnsuccesfullException(fCPException);
        }
        catch (IOException iOException) {
            FCPLogger.log(this, FCPUtils.getClassNameOnly(iOException) + " while checking for redirects: " + iOException.getMessage(), FCPLogger.ERROR);
            throw new ConnectionUnsuccesfullException(iOException);
        }
    }
}

