/*
 * Decompiled with CFR 0.152.
 */
package freenetmessageboard.fcpinterface;

import freenetmessageboard.fcpinterface.ConnectionUnsuccesfullException;
import freenetmessageboard.fcpinterface.FCPConnection;
import freenetmessageboard.fcpinterface.FCPException;
import freenetmessageboard.fcpinterface.FCPGenerateSVKPairMessage;
import freenetmessageboard.fcpinterface.FCPLogger;
import freenetmessageboard.fcpinterface.FCPSuccessMessage;
import freenetmessageboard.fcpinterface.FCPUtils;

class FCPGenerateSVKPairConnection
extends FCPConnection {
    private String privateKey;
    private String publicKey;

    FCPGenerateSVKPairConnection() {
    }

    boolean connect() throws ConnectionUnsuccesfullException {
        try {
            super.connect();
            FCPLogger.log(this, "asking fred to generate a new keypair for us", FCPLogger.NORMAL);
            this.sendToNode(new FCPGenerateSVKPairMessage());
            this.lastResponse = this.receiveFromNode();
            if (this.lastResponse instanceof FCPSuccessMessage) {
                this.privateKey = ((FCPSuccessMessage)this.lastResponse).getPrivateKey();
                this.publicKey = ((FCPSuccessMessage)this.lastResponse).getPublicKey();
                FCPLogger.log(this, "great. now we have a new generated public key: " + this.publicKey, FCPLogger.NORMAL);
                this.wasSuccesfull = true;
                return true;
            }
            this.wasSuccesfull = false;
            FCPLogger.log(this, "the key generation failed: " + this.lastResponse.getMessageInfo(), FCPLogger.ERROR);
            return false;
        }
        catch (ConnectionUnsuccesfullException connectionUnsuccesfullException) {
            throw connectionUnsuccesfullException;
        }
        catch (FCPException fCPException) {
            FCPLogger.log(this, "exception during key generation: " + FCPUtils.getClassNameOnly(fCPException) + ": " + fCPException.getMessage(), FCPLogger.WARNING);
            throw new ConnectionUnsuccesfullException(fCPException);
        }
        catch (InterruptedException interruptedException) {
            FCPLogger.log(this, "thread " + Thread.currentThread().getName() + " was interrupted!", FCPLogger.WARNING);
            throw new ConnectionUnsuccesfullException(interruptedException);
        }
    }

    String getPublicKey() {
        return this.publicKey;
    }

    String getPrivateKey() {
        return this.privateKey;
    }
}

