/*
 * Decompiled with CFR 0.152.
 */
package freenetmessageboard.fcpinterface;

import freenetmessageboard.fcpinterface.FCPClientGetConnection;
import freenetmessageboard.fcpinterface.FCPClientPutConnection;
import freenetmessageboard.fcpinterface.FCPConnectionThread;
import freenetmessageboard.fcpinterface.FCPDataNotFoundMessage;
import freenetmessageboard.fcpinterface.FCPGenerateSVKPairConnection;
import freenetmessageboard.fcpinterface.FCPInsertCallback;
import freenetmessageboard.fcpinterface.FCPKeyCollisionMessage;
import freenetmessageboard.fcpinterface.FCPLogger;
import freenetmessageboard.fcpinterface.FCPRedirectClientGetConnection;
import freenetmessageboard.fcpinterface.FCPRedirectClientPutConnection;
import freenetmessageboard.fcpinterface.FCPRequestCallback;
import freenetmessageboard.fcpinterface.FCPResponse;
import freenetmessageboard.fcpinterface.FCPRouteNotFoundMessage;
import freenetmessageboard.fcpinterface.FailedToConnectToNodeException;
import freenetmessageboard.fcpinterface.InsertInfo;
import freenetmessageboard.fcpinterface.KeyPair;
import freenetmessageboard.fcpinterface.RequestedData;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class FCPFacade
extends Thread {
    private static FCPFacade instance;
    private HashMap insertCallbacksMap = new HashMap();
    private HashMap insertOriginalUriMap = new HashMap();
    private HashMap requestCallbacksMap = new HashMap();
    private HashMap requestOriginalUriMap = new HashMap();
    private List queuedInsertThreads = new LinkedList();
    private List queuedRequestThreads = new LinkedList();
    private List activeInsertThreads = new LinkedList();
    private List activeRequestThreads = new LinkedList();
    private int maxSimultaneousInserts = 5;
    private int maxSimultaneousRequests = 5;

    private FCPFacade() {
        this.setName("FCPInterface");
    }

    public KeyPair generateKeyPair() throws FailedToConnectToNodeException {
        try {
            FCPLogger.log(this, "generating a new key pair...", FCPLogger.INTERFACE_NORMAL);
            FCPGenerateSVKPairConnection fCPGenerateSVKPairConnection = new FCPGenerateSVKPairConnection();
            FCPConnectionThread fCPConnectionThread = new FCPConnectionThread(fCPGenerateSVKPairConnection);
            fCPConnectionThread.start();
            while (!fCPConnectionThread.isFinished()) {
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (fCPGenerateSVKPairConnection.getPrivateKey() == null) {
                throw new FailedToConnectToNodeException(fCPConnectionThread.getException().originalException.getMessage());
            }
            return new KeyPair(fCPGenerateSVKPairConnection.getPublicKey(), fCPGenerateSVKPairConnection.getPrivateKey());
        }
        catch (Exception exception) {
            throw new FailedToConnectToNodeException("failed to generate key pair: " + exception.getMessage());
        }
    }

    public void startFreenetRequest(FCPRequestCallback fCPRequestCallback, String string, int n, boolean bl) {
        FCPLogger.log(this, "received freenet request for key " + string + " with " + n + " htl", FCPLogger.NORMAL);
        FCPClientGetConnection fCPClientGetConnection = bl ? new FCPRedirectClientGetConnection(string, n) : new FCPClientGetConnection(string, n);
        FCPConnectionThread fCPConnectionThread = new FCPConnectionThread(fCPClientGetConnection);
        this.requestCallbacksMap.put(fCPConnectionThread, fCPRequestCallback);
        this.requestOriginalUriMap.put(fCPConnectionThread, string);
        this.queueRequest(fCPConnectionThread);
    }

    private void queueRequest(FCPConnectionThread fCPConnectionThread) {
        List list = this.queuedRequestThreads;
        synchronized (list) {
            this.queuedRequestThreads.add(fCPConnectionThread);
        }
    }

    public byte[] getContentTypeMetaBytes(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Version\n");
        stringBuffer.append("Revision=1\n");
        stringBuffer.append("EndPart\n");
        stringBuffer.append("Document\n");
        stringBuffer.append("Info.Format=");
        stringBuffer.append(string);
        stringBuffer.append("\nInfo.Description=file\n");
        stringBuffer.append("End\n");
        return stringBuffer.toString().getBytes();
    }

    byte[] getRedirectMetaBytes(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Version\n");
        stringBuffer.append("Revision=1\n");
        stringBuffer.append("EndPart\n");
        stringBuffer.append("Document\n");
        stringBuffer.append("Redirect.Target=");
        stringBuffer.append(string);
        stringBuffer.append("\nEnd\n");
        stringBuffer.append("Info.Format=");
        stringBuffer.append(string2);
        stringBuffer.append("\nInfo.Description=file\n");
        stringBuffer.append("End\n");
        return stringBuffer.toString().getBytes();
    }

    private synchronized void startQueuedRequests() {
        FCPLogger.log(this, "starting queued requests...", FCPLogger.INFO);
        LinkedList<FCPConnectionThread> linkedList = new LinkedList<FCPConnectionThread>();
        List list = this.queuedRequestThreads;
        synchronized (list) {
            Collections.sort(this.queuedRequestThreads, FCPConnectionThread.getPriorityComparator());
            Iterator iterator = this.queuedRequestThreads.iterator();
            if (iterator.hasNext() && this.activeRequestThreads.size() < this.maxSimultaneousRequests) {
                FCPConnectionThread fCPConnectionThread = (FCPConnectionThread)iterator.next();
                FCPLogger.log(this, "starting thread " + fCPConnectionThread.getName() + " which was queued.", FCPLogger.NORMAL);
                fCPConnectionThread.start();
                FCPRequestCallback fCPRequestCallback = (FCPRequestCallback)this.requestCallbacksMap.get(fCPConnectionThread);
                fCPRequestCallback.requestStarted((String)this.requestOriginalUriMap.get(fCPConnectionThread));
                this.activeRequestThreads.add(fCPConnectionThread);
                linkedList.add(fCPConnectionThread);
            }
            iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                this.queuedRequestThreads.remove(iterator.next());
            }
        }
    }

    public void startFreenetInsert(FCPInsertCallback fCPInsertCallback, String string, byte[] byArray, byte[] byArray2, int n, boolean bl) {
        FCPLogger.log(this, "received freenet insert of key " + string + " with " + n + " htl", FCPLogger.NORMAL);
        FCPClientPutConnection fCPClientPutConnection = !bl ? new FCPClientPutConnection(string, n, byArray2, byArray) : new FCPRedirectClientPutConnection(string, n, byArray2, byArray);
        FCPConnectionThread fCPConnectionThread = new FCPConnectionThread(fCPClientPutConnection);
        this.insertCallbacksMap.put(fCPConnectionThread, fCPInsertCallback);
        this.insertOriginalUriMap.put(fCPConnectionThread, string);
        FCPLogger.log(this, "trying to queue insert to " + string, FCPLogger.INFO);
        this.queueInsert(fCPConnectionThread);
        FCPLogger.log(this, "returned from queueInsert", FCPLogger.INFO);
    }

    private void queueInsert(FCPConnectionThread fCPConnectionThread) {
        List list = this.queuedInsertThreads;
        synchronized (list) {
            this.queuedInsertThreads.add(fCPConnectionThread);
        }
    }

    private synchronized void startQueuedInserts() {
        FCPLogger.log(this, "starting queued inserts...", FCPLogger.INFO);
        LinkedList<FCPConnectionThread> linkedList = new LinkedList<FCPConnectionThread>();
        List list = this.queuedInsertThreads;
        synchronized (list) {
            Collections.sort(this.queuedInsertThreads, FCPConnectionThread.getPriorityComparator());
            Iterator iterator = this.queuedInsertThreads.iterator();
            if (iterator.hasNext() && this.activeInsertThreads.size() < this.maxSimultaneousInserts) {
                FCPConnectionThread fCPConnectionThread = (FCPConnectionThread)iterator.next();
                FCPLogger.log(this, "starting thread " + fCPConnectionThread.getName() + " which was queued. ", FCPLogger.NORMAL);
                fCPConnectionThread.start();
                this.activeInsertThreads.add(fCPConnectionThread);
                linkedList.add(fCPConnectionThread);
            }
            iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                this.queuedInsertThreads.remove(iterator.next());
            }
        }
        FCPLogger.log(this, this.activeInsertThreads.size() + " active inserts, " + this.queuedInsertThreads.size() + " inserts left in queue...", FCPLogger.INFO);
    }

    public static synchronized FCPFacade instance() {
        if (instance == null) {
            instance = new FCPFacade();
            instance.start();
        }
        return instance;
    }

    private synchronized void checkForFinishedRequests() {
        FCPConnectionThread fCPConnectionThread;
        FCPLogger.log(this, "ckecking for finished requests...", FCPLogger.INFO);
        Iterator iterator = this.activeRequestThreads.iterator();
        LinkedList<FCPConnectionThread> linkedList = new LinkedList<FCPConnectionThread>();
        while (iterator.hasNext()) {
            Object object;
            FCPClientGetConnection fCPClientGetConnection;
            fCPConnectionThread = (FCPConnectionThread)iterator.next();
            if (!fCPConnectionThread.isFinished()) continue;
            linkedList.add(fCPConnectionThread);
            FCPRequestCallback fCPRequestCallback = (FCPRequestCallback)this.requestCallbacksMap.get(fCPConnectionThread);
            String string = (String)this.requestOriginalUriMap.get(fCPConnectionThread);
            if (fCPConnectionThread.wasSuccesfull()) {
                if (!(fCPConnectionThread.getConnection() instanceof FCPClientGetConnection)) continue;
                fCPClientGetConnection = (FCPClientGetConnection)fCPConnectionThread.getConnection();
                FCPLogger.log(this, "the thread requesting " + string + " succeeded.", FCPLogger.NORMAL);
                object = new RequestedData(string, fCPClientGetConnection);
                fCPRequestCallback.requestSuccesfull(string, (RequestedData)object);
                continue;
            }
            if (!(fCPConnectionThread.getConnection() instanceof FCPClientGetConnection)) continue;
            fCPClientGetConnection = (FCPClientGetConnection)fCPConnectionThread.getConnection();
            if (fCPConnectionThread.getException() != null) {
                FCPLogger.log(this, "the thread requesting " + string + " caught an Exception: ", FCPLogger.INTERFACE_WARNING);
                fCPRequestCallback.requestFailedBadly(string, fCPConnectionThread.getException().originalException.getClass().getName());
                continue;
            }
            object = fCPClientGetConnection.getLastResponse();
            if (object instanceof FCPDataNotFoundMessage) {
                FCPLogger.log(this, "the thread requesting " + string + " failed with htl " + fCPClientGetConnection.getHtl() + ": " + ((FCPResponse)object).getMessageInfo(), FCPLogger.INTERFACE_NORMAL);
                fCPRequestCallback.requestFailedWithDataNotFound(string);
                continue;
            }
            if (object instanceof FCPRouteNotFoundMessage) {
                FCPLogger.log(this, "the thread requesting " + string + " failed with htl " + fCPClientGetConnection.getHtl() + ": " + ((FCPResponse)object).getMessageInfo(), FCPLogger.INTERFACE_WARNING);
                fCPRequestCallback.requestFailedWithRouteNotFound(string);
                continue;
            }
            FCPLogger.log(this, "the thread requesting " + string + " failed with htl " + fCPClientGetConnection.getHtl() + ": " + ((FCPResponse)object).getMessageInfo(), FCPLogger.ERROR);
            fCPRequestCallback.requestFailedBadly(string, ((FCPResponse)object).getMessageInfo());
        }
        iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            fCPConnectionThread = (FCPConnectionThread)iterator.next();
            this.activeRequestThreads.remove(fCPConnectionThread);
            this.requestCallbacksMap.remove(fCPConnectionThread);
            this.requestOriginalUriMap.remove(fCPConnectionThread);
        }
    }

    private synchronized void checkForFinishedInserts() {
        FCPConnectionThread fCPConnectionThread;
        FCPLogger.log(this, "ckecking for finished inserts...", FCPLogger.INFO);
        Iterator iterator = this.activeInsertThreads.iterator();
        LinkedList<FCPConnectionThread> linkedList = new LinkedList<FCPConnectionThread>();
        while (iterator.hasNext()) {
            Object object;
            FCPClientPutConnection fCPClientPutConnection;
            fCPConnectionThread = (FCPConnectionThread)iterator.next();
            if (!fCPConnectionThread.isFinished()) continue;
            linkedList.add(fCPConnectionThread);
            FCPInsertCallback fCPInsertCallback = (FCPInsertCallback)this.insertCallbacksMap.get(fCPConnectionThread);
            String string = (String)this.insertOriginalUriMap.get(fCPConnectionThread);
            if (fCPConnectionThread.wasSuccesfull()) {
                if (!(fCPConnectionThread.getConnection() instanceof FCPClientPutConnection)) continue;
                fCPClientPutConnection = (FCPClientPutConnection)fCPConnectionThread.getConnection();
                FCPLogger.log(this, "the thread inserting " + string + " succeeded.", FCPLogger.NORMAL);
                object = new InsertInfo(string, fCPClientPutConnection, 1);
                fCPInsertCallback.insertSuccesfull(string, (InsertInfo)object);
                continue;
            }
            if (!(fCPConnectionThread.getConnection() instanceof FCPClientPutConnection)) continue;
            fCPClientPutConnection = (FCPClientPutConnection)fCPConnectionThread.getConnection();
            if (fCPConnectionThread.getException() != null) {
                FCPLogger.log(this, "the thread inserting " + string + " caught an Exception: ", FCPLogger.INTERFACE_WARNING);
                fCPInsertCallback.insertFailedBadly(string, fCPConnectionThread.getException().originalException.getClass().getName());
                continue;
            }
            object = fCPClientPutConnection.getLastResponse();
            if (object instanceof FCPKeyCollisionMessage) {
                FCPLogger.log(this, "the thread inserting " + string + " had a key collision: " + ((FCPResponse)object).getMessageInfo(), FCPLogger.INTERFACE_NORMAL);
                FCPLogger.log(this, "trying to call the callback method...", FCPLogger.INFO);
                fCPInsertCallback.insertFailedWithKeyCollision(string);
                FCPLogger.log(this, "returned from callback method.", FCPLogger.INFO);
                continue;
            }
            FCPLogger.log(this, "the thread inserting " + string + " failed: " + ((FCPResponse)object).getMessageInfo(), FCPLogger.INTERFACE_WARNING);
            if (object instanceof FCPRouteNotFoundMessage) {
                fCPInsertCallback.insertFailedWithRouteNotFound(string);
                continue;
            }
            fCPInsertCallback.insertFailedBadly(string, ((FCPResponse)object).getMessageInfo());
        }
        iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            fCPConnectionThread = (FCPConnectionThread)iterator.next();
            this.activeInsertThreads.remove(fCPConnectionThread);
            this.insertCallbacksMap.remove(fCPConnectionThread);
            this.insertOriginalUriMap.remove(fCPConnectionThread);
        }
    }

    public void run() {
        FCPLogger.log(this, "the FCPFacade is starting up...", FCPLogger.NORMAL);
        while (true) {
            this.checkForFinishedRequests();
            this.startQueuedRequests();
            this.checkForFinishedInserts();
            this.startQueuedInserts();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }
}

