/*
 * Decompiled with CFR 0.152.
 */
package freenetmessageboard.fcpinterface;

import freenetmessageboard.fcpinterface.FCPMessage;
import freenetmessageboard.fcpinterface.FCPResponse;
import freenetmessageboard.fcpinterface.FieldNotFoundException;

class FCPDataFoundMessage
extends FCPResponse {
    private int dataLength;
    private int metaDataLength = 0;

    FCPDataFoundMessage(byte[] byArray) {
        super(FCPMessage.dataFoundHeader, byArray);
        try {
            this.dataLength = super.findValueHex("DataLength");
            this.metaDataLength = super.findValueHex("MetadataLength");
            this.dataLength -= this.metaDataLength;
        }
        catch (FieldNotFoundException fieldNotFoundException) {
            // empty catch block
        }
    }

    String getMessageInfo() {
        if (this.metaDataLength == 0) {
            return "the requested key has " + this.dataLength + " bytes of data";
        }
        return "the requested key has " + this.dataLength + " bytes of data and " + this.metaDataLength + " bytes of metadata";
    }

    int getDataLength() {
        return this.dataLength;
    }

    int getMetaDataLength() {
        return this.metaDataLength;
    }
}

