/*
 * Decompiled with CFR 0.152.
 */
package freenetmessageboard.fcpinterface;

import freenetmessageboard.fcpinterface.ConnectionUnsuccesfullException;
import freenetmessageboard.fcpinterface.FCPConnection;
import freenetmessageboard.fcpinterface.FCPException;
import freenetmessageboard.fcpinterface.FCPLogger;
import freenetmessageboard.fcpinterface.FCPResponse;
import freenetmessageboard.fcpinterface.FCPUtils;
import java.util.Comparator;

class FCPConnectionThread
extends Thread {
    private FCPConnection connection;
    private boolean running;
    private boolean wasSuccesfull;
    private boolean finished;
    private ConnectionUnsuccesfullException exception;
    private FCPResponse lastResponse;
    private long startTime;
    private long endTime;
    private int priority = 3;
    static final int PRIORITY_VERY_HIGH = 5;
    static final int PRIORITY_HIGH = 4;
    static final int PRIORITY_NORMAL = 3;
    static final int PRIORITY_LOW = 2;
    static final int PRIORITY_VERY_LOW = 1;

    FCPConnectionThread(FCPConnection fCPConnection) {
        FCPLogger.log(this, "Thread created for " + FCPUtils.getClassNameOnly(fCPConnection), FCPLogger.INFO);
        this.connection = fCPConnection;
        this.setName("FCP-Connection-" + this.getName());
    }

    void setPriorityHigh() {
        this.priority = 4;
    }

    void setPriorityLow() {
        this.priority = 2;
    }

    static Comparator getPriorityComparator() {
        return new Comparator(){

            public int compare(Object object, Object object2) {
                FCPConnectionThread fCPConnectionThread = (FCPConnectionThread)object;
                FCPConnectionThread fCPConnectionThread2 = (FCPConnectionThread)object2;
                return new Integer(fCPConnectionThread.priority).compareTo(new Integer(fCPConnectionThread2.priority));
            }
        };
    }

    void setPriorityVeryHigh() {
        this.priority = 5;
    }

    void setPriorityVeryLow() {
        this.priority = 1;
    }

    synchronized boolean isFinished() {
        return this.finished;
    }

    synchronized boolean isRunning() {
        return this.running;
    }

    private synchronized void setFinished() {
        this.finished = true;
    }

    synchronized boolean wasSuccesfull() {
        return this.wasSuccesfull;
    }

    private synchronized void onSuccess() {
        FCPLogger.log(this, "Thread was finished succesfully: " + this.lastResponse.getMessageInfo(), FCPLogger.INFO);
        this.wasSuccesfull = true;
        this.setFinished();
    }

    private synchronized void onFailed() {
        FCPLogger.log(this, "Thread was finished without success: " + this.lastResponse.getMessageInfo(), FCPLogger.WARNING);
        this.setFinished();
    }

    private synchronized void onException() {
        if (this.exception.originalException instanceof FCPException) {
            FCPLogger.log(this, "Thread failed because of an " + FCPUtils.getClassNameOnly(this.exception.originalException) + ": " + this.exception.originalException.getMessage(), FCPLogger.WARNING);
            this.exception.originalException.printStackTrace();
        } else {
            FCPLogger.log(this, "Thread crashed because of an unexpected " + FCPUtils.getClassNameOnly(this.exception.originalException) + ": " + this.exception.originalException.getMessage(), FCPLogger.ERROR);
            this.exception.originalException.printStackTrace();
        }
        this.setFinished();
    }

    FCPConnection getConnection() {
        return this.connection;
    }

    ConnectionUnsuccesfullException getException() {
        return this.exception;
    }

    public void interrupt() {
        FCPLogger.log(this, "Thread was interrupted, closing socket...", FCPLogger.WARNING);
        super.interrupt();
        this.connection.closeSocket();
    }

    int getConnectionTime() {
        return (int)(this.endTime - this.startTime);
    }

    public void run() {
        this.running = true;
        this.startTime = System.currentTimeMillis();
        FCPLogger.log(this, "Thread was started for a " + FCPUtils.getClassNameOnly(this.connection), FCPLogger.INFO);
        try {
            boolean bl = this.connection.connect();
            this.lastResponse = this.connection.getLastResponse();
            this.endTime = System.currentTimeMillis();
            if (bl) {
                this.onSuccess();
            } else {
                this.onFailed();
            }
            this.connection.closeSocket();
        }
        catch (ConnectionUnsuccesfullException connectionUnsuccesfullException) {
            this.endTime = System.currentTimeMillis();
            this.connection.closeSocket();
            this.exception = connectionUnsuccesfullException;
            this.onException();
        }
        catch (Exception exception) {
            this.endTime = System.currentTimeMillis();
            this.connection.closeSocket();
            this.exception = new ConnectionUnsuccesfullException(exception);
            this.onException();
        }
        this.running = false;
    }
}

