/*
 * Decompiled with CFR 0.152.
 */
package freenetmessageboard.fcpinterface;

import freenetmessageboard.fcpinterface.BadMessageFormatException;
import freenetmessageboard.fcpinterface.CannotCreateSocketException;
import freenetmessageboard.fcpinterface.ConnectionUnsuccesfullException;
import freenetmessageboard.fcpinterface.FCPByteKeywordWatcher;
import freenetmessageboard.fcpinterface.FCPConfig;
import freenetmessageboard.fcpinterface.FCPDataChunkMessage;
import freenetmessageboard.fcpinterface.FCPLogger;
import freenetmessageboard.fcpinterface.FCPMessage;
import freenetmessageboard.fcpinterface.FCPRequest;
import freenetmessageboard.fcpinterface.FCPResponse;
import freenetmessageboard.fcpinterface.FCPUtils;
import freenetmessageboard.fcpinterface.FieldNotFoundException;
import freenetmessageboard.fcpinterface.ResponseNotKnownException;
import freenetmessageboard.fcpinterface.ResponseNotReadableException;
import freenetmessageboard.fcpinterface.SocketClosedDownException;
import freenetmessageboard.fcpinterface.TransferRestartedException;
import freenetmessageboard.fcpinterface.WrongDataLengthException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;

class FCPConnection {
    private static byte[] sessionIdentifier = new byte[]{0, 0};
    private static byte[] presentationIdentifier = new byte[]{0, 2};
    private static int receiveBufferSize = 1;
    private String hostName = FCPConfig.getHostname();
    private int port = FCPConfig.getPort();
    private Socket socket;
    protected FCPResponse lastResponse;
    protected boolean wasSuccesfull = false;

    FCPConnection() {
    }

    boolean wasSuccesfull() {
        return this.wasSuccesfull;
    }

    FCPResponse getLastResponse() {
        return this.lastResponse;
    }

    private void sendToNode(byte[] byArray) throws SocketClosedDownException {
        try {
            FCPLogger.log(this, "sending " + byArray.length + " raw bytes to the node", FCPLogger.DEBUG);
            this.socket.getOutputStream().write(byArray);
        }
        catch (IOException iOException) {
            FCPLogger.log(this, "socked was closed down: " + iOException.getMessage(), FCPLogger.ERROR);
            throw new SocketClosedDownException();
        }
    }

    void sendToNode(FCPRequest fCPRequest) throws SocketClosedDownException {
        try {
            FCPLogger.log(this, "sending " + FCPUtils.getClassNameOnly(fCPRequest) + " to the node: " + fCPRequest.getMessageInfo(), FCPLogger.INFO);
            this.socket.getOutputStream().write(fCPRequest.getMessageBytes());
        }
        catch (IOException iOException) {
            FCPLogger.log(this, "socked was closed down: " + iOException.getMessage(), FCPLogger.ERROR);
            throw new SocketClosedDownException();
        }
    }

    FCPDataChunkMessage receiveData() throws SocketClosedDownException, WrongDataLengthException, InterruptedException, TransferRestartedException {
        FCPLogger.log(this, "waiting for a chunk of data..", FCPLogger.INFO);
        try {
            byte[] byArray;
            int n;
            InputStream inputStream = this.socket.getInputStream();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            FCPByteKeywordWatcher fCPByteKeywordWatcher = new FCPByteKeywordWatcher();
            fCPByteKeywordWatcher.addKeyword(FCPMessage.dataChunkHeader);
            fCPByteKeywordWatcher.addKeyword("Data");
            fCPByteKeywordWatcher.addKeyword("Restarted");
            fCPByteKeywordWatcher.addKeyword("EndMessage");
            do {
                int n2;
                if ((n2 = inputStream.read()) == -1) {
                    FCPLogger.log(this, "no data coming in, waiting...", FCPLogger.DEBUG);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        throw new InterruptedException();
                    }
                } else {
                    n = n2;
                    FCPLogger.log(this, " raw byte received: " + (char)n, FCPLogger.DEBUG);
                    byteArrayOutputStream.write(n);
                    fCPByteKeywordWatcher.lookForKeywords((byte)n);
                    if (!fCPByteKeywordWatcher.wasFound("Restarted") || !fCPByteKeywordWatcher.wasFound("EndMessage")) continue;
                    throw new TransferRestartedException();
                }
            } while (!fCPByteKeywordWatcher.wasFound("Data") || !fCPByteKeywordWatcher.wasFound("DataChunk"));
            byteArrayOutputStream.flush();
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            n = Integer.parseInt(FCPUtils.findField(byArray2, "Length"), 16);
            FCPLogger.log(this, " receiving a chunk of " + n + " bytes", FCPLogger.INFO);
            int n3 = 0;
            ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream(n);
            while (n3 < n) {
                byArray = new byte[n - n3];
                int n4 = inputStream.read(byArray);
                if (n4 == -1) {
                    FCPLogger.log(this, " connection is stuck. i wait a second until everything goes smooth again.", FCPLogger.WARNING);
                    Thread.sleep(1000L);
                    continue;
                }
                n3 += n4;
                if (n4 != byArray.length) {
                    FCPLogger.log(this, " only received " + n4 + " bytes instead of " + byArray.length + " but i keep trying...", FCPLogger.INFO);
                    byteArrayOutputStream2.write(byArray, 0, n4);
                    continue;
                }
                byteArrayOutputStream2.write(byArray);
            }
            byteArrayOutputStream2.flush();
            byArray = byteArrayOutputStream2.toByteArray();
            FCPLogger.log(this, " received " + n3 + " bytes of pure data", FCPLogger.INFO);
            return new FCPDataChunkMessage(byArray2, byArray);
        }
        catch (IOException iOException) {
            throw new SocketClosedDownException();
        }
        catch (FieldNotFoundException fieldNotFoundException) {
            throw new WrongDataLengthException();
        }
    }

    FCPResponse receiveFromNode() throws SocketClosedDownException, ResponseNotReadableException, ResponseNotKnownException, BadMessageFormatException, InterruptedException {
        try {
            FCPLogger.log(this, "waiting for the response from the node...", FCPLogger.INFO);
            InputStream inputStream = this.socket.getInputStream();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[receiveBufferSize];
            FCPByteKeywordWatcher fCPByteKeywordWatcher = new FCPByteKeywordWatcher();
            fCPByteKeywordWatcher.addKeyword(FCPMessage.endMessageString);
            do {
                int n;
                if ((n = inputStream.read()) == -1) {
                    FCPLogger.log(this, "no data coming in, waiting...", FCPLogger.DEBUG);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        throw new InterruptedException();
                    }
                } else {
                    byte by = (byte)n;
                    FCPLogger.log(this, "1 raw byte received: " + (char)by, FCPLogger.DEBUG);
                    byteArrayOutputStream.write(by);
                    fCPByteKeywordWatcher.lookForKeywords(by);
                }
            } while (!fCPByteKeywordWatcher.wasFound(FCPMessage.endMessageString));
            byteArrayOutputStream.flush();
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            FCPLogger.log(this, byArray2.length + " bytes received.", FCPLogger.DEBUG);
            FCPResponse fCPResponse = FCPUtils.parseResponse(byArray2);
            FCPLogger.log(this, FCPUtils.getClassNameOnly(fCPResponse) + " received from node: " + fCPResponse.getMessageInfo(), FCPLogger.INFO);
            return fCPResponse;
        }
        catch (IOException iOException) {
            FCPLogger.log(this, "socked was closed down: " + iOException.getMessage(), FCPLogger.ERROR);
            throw new SocketClosedDownException();
        }
    }

    void closeSocket() {
        if (this.socket == null) {
            return;
        }
        FCPLogger.log(this, "trying to close socket...", FCPLogger.INFO);
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            FCPLogger.log(this, "cannot close socket! " + iOException.getMessage(), FCPLogger.ERROR);
        }
        FCPLogger.log(this, "...socket closed", FCPLogger.INFO);
    }

    boolean connect() throws ConnectionUnsuccesfullException {
        try {
            boolean bl = false;
            int n = 0;
            while (!bl && n < 3) {
                FCPLogger.log(this, "creating fcp connection to " + this.hostName + ":" + this.port, FCPLogger.INFO);
                try {
                    this.socket = new Socket(this.hostName, this.port);
                    bl = true;
                }
                catch (IOException iOException) {
                    ++n;
                    int n2 = (int)(Math.random() * 400.0) + 200;
                    FCPLogger.log(this, "can't create socket, waiting " + n2 + " ms before next retry", FCPLogger.WARNING);
                    try {
                        Thread.sleep(n2);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (!bl) {
                throw new IOException("cannot create socket to " + this.hostName + ":" + this.port);
            }
            FCPLogger.log(this, "sending session & presentation identifierts", FCPLogger.INFO);
            this.sendToNode(sessionIdentifier);
            this.sendToNode(presentationIdentifier);
            return true;
        }
        catch (IOException iOException) {
            FCPLogger.log(this, "cannot connect to freenet node at " + this.hostName + ":" + this.port + ": " + iOException.getMessage(), FCPLogger.WARNING);
            throw new ConnectionUnsuccesfullException(new CannotCreateSocketException());
        }
        catch (SocketClosedDownException socketClosedDownException) {
            FCPLogger.log(this, "socked was closed down: " + socketClosedDownException.getMessage(), FCPLogger.ERROR);
            throw new ConnectionUnsuccesfullException(socketClosedDownException);
        }
    }
}

