/*
 * Decompiled with CFR 0.152.
 */
package freenetmessageboard.fcpinterface;

import freenetmessageboard.fcpinterface.FCPLogger;
import freenetmessageboard.fcpinterface.FCPMessage;
import freenetmessageboard.fcpinterface.FCPRequest;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

class FCPClientPutMessage
extends FCPRequest {
    private String uri;
    private int htl;
    private byte[] metaBytes;
    private byte[] dataBytes;

    FCPClientPutMessage(String string, int n, byte[] byArray, byte[] byArray2) {
        super(FCPMessage.clientPutHeader);
        this.uri = string;
        this.htl = n;
        this.metaBytes = byArray;
        this.dataBytes = byArray2;
        this.endMessage = "Data";
        super.addFieldValuePair("HopsToLive", Integer.toString(this.htl));
        super.addFieldValuePair("URI", this.uri);
        if (this.metaBytes != null) {
            super.addFieldValuePair("DataLength", Integer.toString(this.dataBytes.length + this.metaBytes.length, 16));
            super.addFieldValuePair("MetadataLength", Integer.toString(this.metaBytes.length, 16));
        } else {
            super.addFieldValuePair("DataLength", Integer.toString(this.dataBytes.length, 16));
        }
    }

    byte[] getMessageBytes() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = super.getMessageBytes();
        try {
            byteArrayOutputStream.write(byArray);
            FCPLogger.log(this, "header-length " + byArray.length, FCPLogger.DEBUG);
            byteArrayOutputStream.write(this.metaBytes);
            FCPLogger.log(this, "meta-length " + this.metaBytes.length, FCPLogger.DEBUG);
            byteArrayOutputStream.write(this.dataBytes);
            FCPLogger.log(this, "data-length " + this.dataBytes.length, FCPLogger.DEBUG);
            byteArrayOutputStream.flush();
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            FCPLogger.log(this, "total length  " + byArray2.length, FCPLogger.DEBUG);
            FCPLogger.log(this, new String(byArray2), FCPLogger.DEBUG);
            return byArray2;
        }
        catch (IOException iOException) {
            FCPLogger.log(this, "IOException while creating the bytearray for the put message. sorry this error is critical! ", FCPLogger.ERROR);
            return new byte[7];
        }
    }

    String getMessageInfo() {
        return "trying to insert key " + this.uri + " with htl " + this.htl;
    }
}

