/*
 * Decompiled with CFR 0.152.
 */
package freenetmessageboard.fcpinterface;

import freenetmessageboard.fcpinterface.ConnectionUnsuccesfullException;
import freenetmessageboard.fcpinterface.FCPClientPutMessage;
import freenetmessageboard.fcpinterface.FCPConnection;
import freenetmessageboard.fcpinterface.FCPFormatErrorMessage;
import freenetmessageboard.fcpinterface.FCPKeyCollisionMessage;
import freenetmessageboard.fcpinterface.FCPLogger;
import freenetmessageboard.fcpinterface.FCPPendingMessage;
import freenetmessageboard.fcpinterface.FCPRestartedMessage;
import freenetmessageboard.fcpinterface.FCPRouteNotFoundMessage;
import freenetmessageboard.fcpinterface.FCPSizeErrorMessage;
import freenetmessageboard.fcpinterface.FCPSuccessMessage;
import freenetmessageboard.fcpinterface.FCPUriErrorMessage;
import freenetmessageboard.fcpinterface.FCPUtils;
import freenetmessageboard.fcpinterface.ResponseNotKnownException;
import freenetmessageboard.fcpinterface.UriFormatErrorException;

class FCPClientPutConnection
extends FCPConnection {
    protected String uri;
    protected int htl;
    protected byte[] dataBytes;
    protected byte[] metaBytes;

    FCPClientPutConnection(String string, int n, byte[] byArray, byte[] byArray2) {
        this.htl = n;
        this.uri = string;
        this.dataBytes = byArray;
        this.metaBytes = byArray2;
    }

    String getUri() {
        return this.uri;
    }

    int getHtl() {
        return this.htl;
    }

    boolean connect() throws ConnectionUnsuccesfullException {
        try {
            FCPLogger.log(this, "trying to insert " + this.uri + " with htl " + this.htl, FCPLogger.NORMAL);
            if (!FCPUtils.checkUriSyntax(this.uri)) {
                throw new ConnectionUnsuccesfullException(new UriFormatErrorException());
            }
            super.connect();
            super.sendToNode(new FCPClientPutMessage(this.uri, this.htl, this.metaBytes, this.dataBytes));
            boolean bl = false;
            while (!bl) {
                this.lastResponse = super.receiveFromNode();
                if (this.lastResponse instanceof FCPSuccessMessage) {
                    FCPSuccessMessage fCPSuccessMessage = (FCPSuccessMessage)this.lastResponse;
                    if (fCPSuccessMessage.getUri() != null) {
                        this.uri = fCPSuccessMessage.getUri();
                    }
                    FCPLogger.log(this, "the key " + this.uri + " was inserted succesfully " + this.htl, FCPLogger.NORMAL);
                    return true;
                }
                if (this.lastResponse instanceof FCPRestartedMessage) {
                    FCPLogger.log(this, "the insert of " + this.uri + " had to be restarted! please be patient.", FCPLogger.ERROR);
                    continue;
                }
                if (this.lastResponse instanceof FCPPendingMessage) {
                    FCPLogger.log(this, "pending message received for key " + this.uri + " insert seemes to go well...", FCPLogger.INFO);
                    continue;
                }
                if (this.lastResponse instanceof FCPUriErrorMessage) {
                    FCPLogger.log(this, "FCPUriErrorMessage the URI " + this.uri + " has a wrong format. ", FCPLogger.WARNING);
                    return false;
                }
                if (this.lastResponse instanceof FCPFormatErrorMessage) {
                    FCPLogger.log(this, "FCPFormatErrorMessage: " + this.lastResponse.getMessageString(), FCPLogger.WARNING);
                    System.err.println(this.lastResponse.getMessageString());
                    return false;
                }
                if (this.lastResponse instanceof FCPRouteNotFoundMessage) {
                    FCPLogger.log(this, "route to key " + this.uri + " was not found.", FCPLogger.WARNING);
                    return false;
                }
                if (this.lastResponse instanceof FCPSizeErrorMessage) {
                    FCPLogger.log(this, "the node report a wrong size for " + this.uri, FCPLogger.WARNING);
                    return false;
                }
                if (this.lastResponse instanceof FCPKeyCollisionMessage) {
                    this.uri = ((FCPKeyCollisionMessage)this.lastResponse).getUri();
                    FCPLogger.log(this, "the key " + this.uri + " cannot be inserted because it is already there", FCPLogger.WARNING);
                    return false;
                }
                throw new ConnectionUnsuccesfullException(new ResponseNotKnownException());
            }
            return false;
        }
        catch (ConnectionUnsuccesfullException connectionUnsuccesfullException) {
            throw connectionUnsuccesfullException;
        }
        catch (Exception exception) {
            throw new ConnectionUnsuccesfullException(exception);
        }
    }
}

