/*
 * Decompiled with CFR 0.152.
 */
package freenetmessageboard.fcpinterface;

import freenetmessageboard.fcpinterface.ConnectionUnsuccesfullException;
import freenetmessageboard.fcpinterface.FCPClientGetMessage;
import freenetmessageboard.fcpinterface.FCPConnection;
import freenetmessageboard.fcpinterface.FCPDataChunkMessage;
import freenetmessageboard.fcpinterface.FCPDataFoundMessage;
import freenetmessageboard.fcpinterface.FCPDataNotFoundMessage;
import freenetmessageboard.fcpinterface.FCPException;
import freenetmessageboard.fcpinterface.FCPFormatErrorMessage;
import freenetmessageboard.fcpinterface.FCPLogger;
import freenetmessageboard.fcpinterface.FCPRestartedMessage;
import freenetmessageboard.fcpinterface.FCPRouteNotFoundMessage;
import freenetmessageboard.fcpinterface.FCPUriErrorMessage;
import freenetmessageboard.fcpinterface.FCPUtils;
import freenetmessageboard.fcpinterface.TransferRestartedException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class FCPClientGetConnection
extends FCPConnection {
    protected String uri;
    protected int htl;
    private byte[] metaBytes;
    private byte[] dataBytes;

    FCPClientGetConnection(String string, int n) {
        this.uri = string;
        this.htl = n;
    }

    byte[] getMetaData() {
        return this.metaBytes;
    }

    byte[] getData() {
        return this.dataBytes;
    }

    int getHtl() {
        return this.htl;
    }

    String getUri() {
        return this.uri;
    }

    boolean connect() throws ConnectionUnsuccesfullException {
        try {
            FCPLogger.log(this, "trying to get " + this.uri + " with htl " + this.htl, FCPLogger.NORMAL);
            super.connect();
            this.sendToNode(new FCPClientGetMessage(this.uri, this.htl));
            boolean bl = false;
            while (!bl) {
                Object object;
                Object object2;
                int n;
                FCPDataFoundMessage fCPDataFoundMessage;
                block21: {
                    this.lastResponse = this.receiveFromNode();
                    if (this.lastResponse instanceof FCPDataNotFoundMessage) {
                        FCPLogger.log(this, "the key " + this.uri + " could not be found with htl " + this.htl, FCPLogger.WARNING);
                        return false;
                    }
                    if (this.lastResponse instanceof FCPRouteNotFoundMessage) {
                        FCPLogger.log(this, "no route found. probably a network problem", FCPLogger.WARNING);
                        return false;
                    }
                    if (this.lastResponse instanceof FCPFormatErrorMessage) {
                        FCPLogger.log(this, "there was an format error in the message i sent to the node: " + this.lastResponse.getMessageInfo(), FCPLogger.ERROR);
                        return false;
                    }
                    if (this.lastResponse instanceof FCPUriErrorMessage) {
                        FCPLogger.log(this, "uri error with " + this.uri + ": " + this.lastResponse.getMessageInfo(), FCPLogger.WARNING);
                        return false;
                    }
                    if (this.lastResponse instanceof FCPRestartedMessage) {
                        FCPLogger.log(this, "the request " + this.uri + " was restarted. please wait some more time...", FCPLogger.NORMAL);
                        bl = false;
                        continue;
                    }
                    if (!(this.lastResponse instanceof FCPDataFoundMessage)) {
                        FCPLogger.log(this, "there was an unexpected response: " + this.lastResponse.getMessageInfo(), FCPLogger.ERROR);
                        return false;
                    }
                    FCPLogger.log(this, "the requested data at " + this.uri + " seemes to be available. starting transfer...", FCPLogger.NORMAL);
                    fCPDataFoundMessage = (FCPDataFoundMessage)this.lastResponse;
                    n = 0;
                    if (fCPDataFoundMessage.getMetaDataLength() > 0) {
                        FCPLogger.log(this, "receiving metadata...", FCPLogger.INFO);
                        try {
                            object2 = this.receiveData();
                            this.metaBytes = ((FCPDataChunkMessage)object2).getBytes();
                            FCPLogger.log(this, this.metaBytes.length + " bytes of metadata received", FCPLogger.INFO);
                            if (this.metaBytes.length > fCPDataFoundMessage.getMetaDataLength()) {
                                FCPLogger.log(this, "metabytes and bytes were received together!", FCPLogger.NORMAL);
                                object = this.metaBytes;
                                this.metaBytes = new byte[fCPDataFoundMessage.getMetaDataLength()];
                                this.dataBytes = new byte[fCPDataFoundMessage.getDataLength()];
                                int n2 = 0;
                                while (n2 < fCPDataFoundMessage.getMetaDataLength()) {
                                    this.metaBytes[n2] = (byte)object[n2];
                                    ++n2;
                                }
                                int n3 = 0;
                                while (n3 < fCPDataFoundMessage.getDataLength()) {
                                    this.dataBytes[n3] = (byte)object[n3 + this.metaBytes.length];
                                    ++n3;
                                }
                                bl = true;
                                break;
                            }
                            break block21;
                        }
                        catch (TransferRestartedException transferRestartedException) {
                            FCPLogger.log(this, "the transfer of " + this.uri + "has to be restarted! ", FCPLogger.WARNING);
                            continue;
                        }
                    }
                    this.metaBytes = null;
                }
                FCPLogger.log(this, "receiving data...", FCPLogger.INFO);
                object2 = new ByteArrayOutputStream(fCPDataFoundMessage.getDataLength());
                while (n < fCPDataFoundMessage.getDataLength()) {
                    try {
                        object = this.receiveData();
                        FCPLogger.log(this, "received " + (n += ((FCPDataChunkMessage)object).getChunkLength()) + " of " + fCPDataFoundMessage.getDataLength() + " bytes.", FCPLogger.INFO);
                        ((OutputStream)object2).write(((FCPDataChunkMessage)object).getBytes());
                    }
                    catch (TransferRestartedException transferRestartedException) {
                        FCPLogger.log(this, "the transfer of " + this.uri + "has to be restarted! ", FCPLogger.WARNING);
                    }
                }
                ((OutputStream)object2).flush();
                this.dataBytes = ((ByteArrayOutputStream)object2).toByteArray();
                FCPLogger.log(this, "completely received " + (fCPDataFoundMessage.getDataLength() + fCPDataFoundMessage.getMetaDataLength()) + " bytes from " + this.uri + " with htl " + this.htl, FCPLogger.NORMAL);
                bl = true;
            }
            return true;
        }
        catch (ConnectionUnsuccesfullException connectionUnsuccesfullException) {
            throw connectionUnsuccesfullException;
        }
        catch (FCPException fCPException) {
            FCPLogger.log(this, FCPUtils.getClassNameOnly(fCPException) + " occured while transferring " + this.uri + ":" + fCPException.getMessage(), FCPLogger.WARNING);
            throw new ConnectionUnsuccesfullException(fCPException);
        }
        catch (InterruptedException interruptedException) {
            FCPLogger.log(this, "thread " + Thread.currentThread().getName() + " was interrupted!", FCPLogger.WARNING);
            throw new ConnectionUnsuccesfullException(interruptedException);
        }
        catch (IOException iOException) {
            FCPLogger.log(this, "unexpected " + FCPUtils.getClassNameOnly(iOException) + " while transferring " + this.uri + ":" + iOException.getMessage(), FCPLogger.ERROR);
            iOException.printStackTrace();
            throw new ConnectionUnsuccesfullException(iOException);
        }
    }
}

