/*
 * Decompiled with CFR 0.152.
 */
package freenetmessageboard.core;

import freenetmessageboard.core.ContactList;
import freenetmessageboard.core.Message;
import freenetmessageboard.core.MessageFormatException;
import freenetmessageboard.core.NoSuchFieldException;

public class PostMessage
extends Message {
    private String subject;
    private String replyToUniqueId;
    private String keywords;
    private String message;

    public PostMessage(String string, String string2, String string3, String string4) {
        super(2);
        this.subject = string;
        this.replyToUniqueId = string2;
        this.keywords = string3;
        this.message = string4;
        this.updateFields();
    }

    public String toShortString() {
        return "PostMessage: '" + this.subject + "'";
    }

    public String toString() {
        return this.subject + " [" + ContactList.instance().getNicknameOfPublicKey(this.getOriginalPublicKey()) + "]";
    }

    PostMessage(String string) throws MessageFormatException {
        super(string);
        try {
            this.subject = super.getField("subject");
            this.replyToUniqueId = super.getField("replyTo");
            this.keywords = super.getField("keywords");
            this.message = super.getField("text");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new MessageFormatException(noSuchFieldException.getMessage());
        }
    }

    public String getSubject() {
        return this.subject;
    }

    public String getReplyToUniqueId() {
        return this.replyToUniqueId;
    }

    public String getKeywords() {
        return this.keywords;
    }

    public String getMessage() {
        return this.message;
    }

    private void updateFields() {
        super.setField("subject", this.subject);
        super.setField("replyTo", this.replyToUniqueId);
        super.setField("keywords", this.keywords);
        super.setField("text", this.message);
    }
}

