/*
 * Decompiled with CFR 0.152.
 */
package freenetmessageboard.core;

import freenetmessageboard.core.CoreLogger;
import freenetmessageboard.core.Message;
import freenetmessageboard.core.MessageFormatException;
import freenetmessageboard.core.UserMessage;
import freenetmessageboard.fcpinterface.FCPFacade;
import freenetmessageboard.fcpinterface.FailedToConnectToNodeException;
import freenetmessageboard.fcpinterface.KeyPair;
import freenetmessageboard.gui.PersonalInfoDialog;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.HashMap;

public class PersonalInfo {
    private String publicKey;
    private String privateKey;
    private String nickName = "Anon";
    private String name = "Anonymous Coward";
    private String interests = "none of your business";
    private String freesiteUri = "none of your business";
    private String description = "none of your business";
    private String iconFileName = "none of your business";
    private String helloMessage = "I'm new to fmb, please start listening on my channel";
    private static String personalInfoFileName = "personalInfo";
    private static String demonNick;
    private static boolean demonInfo;
    private static boolean isDefault;
    private static PersonalInfo instance;

    public void saveToDisk() throws IOException {
        try {
            FileWriter fileWriter = new FileWriter(personalInfoFileName);
            fileWriter.write(this.getString());
            fileWriter.close();
        }
        catch (IOException iOException) {
            throw new IOException("couldn't save to " + personalInfoFileName + ": " + iOException.getMessage());
        }
    }

    String publicToPrivateUri(String string) {
        return "SSK@" + this.privateKey + string.substring(string.indexOf(47));
    }

    String privateToPublicUri(String string) {
        return "SSK@" + this.publicKey + string.substring(string.indexOf(47));
    }

    public String getString() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("publicKey", this.publicKey);
        hashMap.put("privateKey", this.privateKey);
        hashMap.put("nickName", this.nickName);
        hashMap.put("description", this.description);
        hashMap.put("name", this.name);
        hashMap.put("interests", this.interests);
        hashMap.put("freesiteUri", this.freesiteUri);
        hashMap.put("iconFileName", this.iconFileName);
        hashMap.put("helloMessage", this.helloMessage);
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("<personalInfo>\n");
        stringBuffer.append(Message.constructFieldTags(hashMap));
        stringBuffer.append("</personalInfo>\n");
        return stringBuffer.toString();
    }

    static PersonalInfo getForwarderInfo(String string) {
        PersonalInfo personalInfo = new PersonalInfo();
        personalInfo.nickName = string;
        personalInfo.name = "automatic message forwarder";
        personalInfo.interests = "forwarding messages";
        personalInfo.description = "I automatically collect messages and forward them on my channel.";
        personalInfo.helloMessage = "listen to this channel for fast collecting of messages";
        return personalInfo;
    }

    private static PersonalInfo readFromDisk(String string) throws IOException, MessageFormatException {
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer(200);
        try {
            String string2;
            object2 = new FileReader(personalInfoFileName);
            object = new LineNumberReader((Reader)object2);
            while ((string2 = ((LineNumberReader)object).readLine()) != null) {
                stringBuffer.append(string2);
            }
            ((BufferedReader)object).close();
            ((InputStreamReader)object2).close();
        }
        catch (IOException iOException) {
            CoreLogger.log("can't read from file " + personalInfoFileName + ": " + iOException.getClass().getName() + ": " + iOException.getMessage(), 1);
            throw new IOException("failed to read from " + personalInfoFileName + ": " + iOException.getMessage());
        }
        object2 = Message.getFields(stringBuffer.toString(), "personalInfo");
        object = new PersonalInfo();
        ((PersonalInfo)object).description = (String)object2.get("description");
        ((PersonalInfo)object).freesiteUri = (String)object2.get("freesiteUri");
        ((PersonalInfo)object).helloMessage = (String)object2.get("helloMessage");
        ((PersonalInfo)object).iconFileName = (String)object2.get("iconFileName");
        ((PersonalInfo)object).interests = (String)object2.get("interests");
        ((PersonalInfo)object).name = (String)object2.get("name");
        ((PersonalInfo)object).nickName = (String)object2.get("nickName");
        ((PersonalInfo)object).privateKey = (String)object2.get("privateKey");
        ((PersonalInfo)object).publicKey = (String)object2.get("publicKey");
        return object;
    }

    private PersonalInfo() {
        try {
            KeyPair keyPair = FCPFacade.instance().generateKeyPair();
            this.publicKey = keyPair.getPublicKey();
            this.privateKey = keyPair.getPrivateKey();
            CoreLogger.log("generated keypair with public key " + this.publicKey, 2);
        }
        catch (FailedToConnectToNodeException failedToConnectToNodeException) {
            CoreLogger.log("couldn't generate keypair: " + failedToConnectToNodeException.getMessage(), 0);
            System.exit(-1);
        }
    }

    public void updateInfoFromDialog(PersonalInfoDialog personalInfoDialog) {
        this.publicKey = personalInfoDialog.publicKeyTextField.getText();
        this.privateKey = personalInfoDialog.privateKeyTextField.getText();
        this.nickName = personalInfoDialog.nickTextField.getText();
        this.name = personalInfoDialog.nameTextField.getText();
        this.freesiteUri = personalInfoDialog.freesiteUriTextField.getText();
        this.interests = personalInfoDialog.interestsTextField.getText();
        this.description = personalInfoDialog.descriptionTextArea.getText();
        this.helloMessage = personalInfoDialog.messageTextArea.getText();
    }

    public void updateInfoFromUserMessage(UserMessage userMessage) {
        this.nickName = userMessage.getNickName();
        this.name = userMessage.getName();
        this.freesiteUri = userMessage.getFreesiteUri();
        this.interests = userMessage.getInterests();
        this.description = userMessage.getDescription();
        this.helloMessage = userMessage.getMessage();
        try {
            this.saveToDisk();
        }
        catch (IOException iOException) {
            CoreLogger.log("failed to save the updated personal info to disk: " + iOException.getMessage(), 0);
        }
    }

    public UserMessage createUserMessage() {
        return new UserMessage(this.publicKey, this.nickName, this.name, this.interests, this.description, this.freesiteUri, this.iconFileName, this.helloMessage);
    }

    public static void setDemonMode(String string) {
        personalInfoFileName = "demonInfo";
        demonNick = string;
    }

    public boolean isDefault() {
        return isDefault;
    }

    public static synchronized PersonalInfo instance() {
        if (instance == null) {
            try {
                instance = PersonalInfo.readFromDisk(personalInfoFileName);
            }
            catch (Exception exception) {
                CoreLogger.log("failed to read personal information from local disk, creating new identity...", 1);
                if (demonInfo) {
                    instance = PersonalInfo.getForwarderInfo(demonNick);
                }
                instance = new PersonalInfo();
                isDefault = true;
            }
            try {
                instance.saveToDisk();
            }
            catch (Exception exception) {
                CoreLogger.log("failed to save the personal information to local disk", 1);
            }
        }
        return instance;
    }

    public String getName() {
        return this.name;
    }

    public String getInterests() {
        return this.interests;
    }

    public String getFreesiteUri() {
        return this.freesiteUri;
    }

    public String getMessage() {
        return this.helloMessage;
    }

    public String getDescription() {
        return this.description;
    }

    public String getIconFileName() {
        return this.iconFileName;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public String getNickname() {
        return this.nickName;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    static {
        demonInfo = false;
        isDefault = false;
    }
}

