/*
 * Decompiled with CFR 0.152.
 */
package freenetmessageboard.core;

import freenetmessageboard.core.ContactList;
import freenetmessageboard.core.NewsgroupDataModel;
import freenetmessageboard.core.PostMessage;
import freenetmessageboard.gui.ColorsAndIcons;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class NewsgroupPost
implements MutableTreeNode {
    private List repliesList = new LinkedList();
    private PostMessage postMessage;
    private String title;
    private boolean hasReverseSorting = false;
    private NewsgroupPost parentPost;
    private boolean isUnread = true;
    private int unreadChildCount = 0;
    private boolean hasTemporaryPosition = false;

    public NewsgroupPost(PostMessage postMessage, boolean bl) {
        this.isUnread = bl;
        this.postMessage = postMessage;
    }

    public Icon getIcon() {
        if (!this.isUnread) {
            if (this.getChildCount() == 0) {
                return ColorsAndIcons.msgIcon;
            }
            if (this.getUnreadChildCount() == 0) {
                return ColorsAndIcons.msgRepliesIcon;
            }
            return ColorsAndIcons.msgUnreadRepliesIcon;
        }
        if (this.getChildCount() == 0) {
            return ColorsAndIcons.msgUnreadIcon;
        }
        return ColorsAndIcons.msgRepliesUnreadIcon;
    }

    public NewsgroupPost(String string, boolean bl) {
        this.isUnread = bl;
        this.title = string;
        this.hasReverseSorting = true;
    }

    void setHasTemporaryPosition(boolean bl) {
        this.hasTemporaryPosition = bl;
    }

    void decreaseUnreadChildCount(int n) {
        this.unreadChildCount -= n;
        if (this.getParent() != null) {
            ((NewsgroupPost)this.getParent()).decreaseUnreadChildCount(n);
        }
        NewsgroupDataModel.instance().fireTreeNodeChanged(this);
    }

    public boolean isUnread() {
        return this.isUnread;
    }

    public int getUnreadChildCount() {
        return this.unreadChildCount;
    }

    void increaseUnreadChildCount(int n) {
        this.unreadChildCount += n;
        if (this.getParent() != null) {
            ((NewsgroupPost)this.getParent()).increaseUnreadChildCount(n);
        }
        NewsgroupDataModel.instance().fireTreeNodeChanged(this);
    }

    void markAsRead() {
        if (this.isUnread) {
            this.isUnread = false;
            ((NewsgroupPost)this.getParent()).decreaseUnreadChildCount(1);
        }
    }

    boolean hasTemporaryPosition() {
        return this.hasTemporaryPosition;
    }

    public PostMessage getPostMessage() {
        return this.postMessage;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.postMessage != null) {
            stringBuffer.append(this.postMessage.getSubject());
            stringBuffer.append(" [");
            stringBuffer.append(ContactList.instance().getNicknameOfPublicKey(this.postMessage.getOriginalPublicKey()));
            stringBuffer.append(" ] ");
        } else {
            stringBuffer.append(this.title);
        }
        return stringBuffer.toString();
    }

    public Enumeration children() {
        return Collections.enumeration(this.repliesList);
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public TreeNode getChildAt(int n) {
        TreeNode treeNode = (TreeNode)this.repliesList.get(n);
        return treeNode;
    }

    public int getChildCount() {
        return this.repliesList.size();
    }

    public int getIndex(TreeNode treeNode) {
        int n = this.repliesList.indexOf(treeNode);
        return n;
    }

    public TreeNode getParent() {
        return this.parentPost;
    }

    public boolean isLeaf() {
        return this.repliesList.size() == 0;
    }

    void insertNewsgroupPost(NewsgroupPost newsgroupPost) {
        this.insert(newsgroupPost, 0);
    }

    public void insert(MutableTreeNode mutableTreeNode, int n) {
        this.repliesList.add(n, mutableTreeNode);
        mutableTreeNode.setParent(this);
        Comparator comparator = this.hasReverseSorting ? NewsgroupPost.getReverseDateComparator() : NewsgroupPost.getDateComparator();
        Collections.sort(this.repliesList, comparator);
        int n2 = 0;
        if (((NewsgroupPost)mutableTreeNode).isUnread) {
            ++n2;
        }
        this.increaseUnreadChildCount(n2 += ((NewsgroupPost)mutableTreeNode).getUnreadChildCount());
    }

    public void remove(int n) {
        NewsgroupPost newsgroupPost = (NewsgroupPost)this.repliesList.get(n);
        this.repliesList.remove(newsgroupPost);
    }

    public void remove(MutableTreeNode mutableTreeNode) {
        int n = 0;
        if (((NewsgroupPost)mutableTreeNode).isUnread) {
            ++n;
        }
        this.decreaseUnreadChildCount(n += ((NewsgroupPost)mutableTreeNode).getUnreadChildCount());
        this.repliesList.remove(mutableTreeNode);
    }

    public void removeFromParent() {
        this.parentPost.remove(this);
        this.parentPost = null;
    }

    public void setParent(MutableTreeNode mutableTreeNode) {
        this.parentPost = (NewsgroupPost)mutableTreeNode;
    }

    public void setUserObject(Object object) {
        if (object instanceof PostMessage) {
            this.updatePostMessage((PostMessage)object);
        } else {
            this.title = object.toString();
        }
    }

    void updatePostMessage(PostMessage postMessage) {
        this.postMessage = postMessage;
    }

    static Comparator getDateComparator() {
        return new Comparator(){

            public int compare(Object object, Object object2) {
                NewsgroupPost newsgroupPost = (NewsgroupPost)object;
                NewsgroupPost newsgroupPost2 = (NewsgroupPost)object2;
                if (newsgroupPost.postMessage == null && newsgroupPost2.postMessage == null) {
                    return 0;
                }
                if (newsgroupPost.postMessage == null) {
                    return -1;
                }
                if (newsgroupPost2.postMessage == null) {
                    return 1;
                }
                return newsgroupPost.postMessage.getDate().compareTo(newsgroupPost2.postMessage.getDate());
            }
        };
    }

    static Comparator getReverseDateComparator() {
        return new Comparator(){

            public int compare(Object object, Object object2) {
                NewsgroupPost newsgroupPost = (NewsgroupPost)object;
                NewsgroupPost newsgroupPost2 = (NewsgroupPost)object2;
                if (newsgroupPost.postMessage == null && newsgroupPost2.postMessage == null) {
                    return 0;
                }
                if (newsgroupPost.postMessage == null) {
                    return 1;
                }
                if (newsgroupPost2.postMessage == null) {
                    return -1;
                }
                return -newsgroupPost.postMessage.getDate().compareTo(newsgroupPost2.postMessage.getDate());
            }
        };
    }
}

