/*
 * Decompiled with CFR 0.152.
 */
package freenetmessageboard.core;

import freenetmessageboard.core.ContactList;
import freenetmessageboard.core.CoreLogger;
import freenetmessageboard.core.Message;
import freenetmessageboard.core.MessageArrivedListener;
import freenetmessageboard.core.MessageFilter;
import freenetmessageboard.core.MessagePool;
import freenetmessageboard.core.NewsgroupPost;
import freenetmessageboard.core.PostMessage;
import freenetmessageboard.gui.ColorsAndIcons;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.TableModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class NewsgroupDataModel
implements MessageArrivedListener,
TableModel,
TreeModel {
    private static NewsgroupDataModel instance;
    private List tableModelListenerList = new LinkedList();
    private String[] tableColumnTitles = new String[]{"new", "from", "subject", "date", "reply to"};
    private Class[] tableColumnClasses = new Class[]{ColorsAndIcons.msgIcon.getClass(), new String().getClass(), new String().getClass(), new String().getClass(), new String().getClass()};
    private NewsgroupPost rootNode;
    private NewsgroupPost unlinkedRepliesNode;
    private List treeModelListenerList = new LinkedList();
    private Map newsgroupPostsMap = new HashMap();
    private Set missingUniqueIdSet = new HashSet();
    private List allPostMessagesList = new ArrayList();
    private String newsgroupName;
    private boolean markNewsMessagesAsUnread = true;

    private NewsgroupDataModel(String string) {
        MessagePool.instance().addMessageArrivedListener(this, MessageFilter.getAllPostsMessageFilter());
        this.rootNode = new NewsgroupPost(string, false);
        this.newsgroupName = string;
    }

    public static NewsgroupDataModel instance() {
        if (instance == null) {
            instance = new NewsgroupDataModel("all newsgroups");
        }
        return instance;
    }

    private void fireRowsInserted(int n) {
        Iterator iterator = this.tableModelListenerList.iterator();
        TableModelEvent tableModelEvent = new TableModelEvent(this, n);
        while (iterator.hasNext()) {
            TableModelListener tableModelListener = (TableModelListener)iterator.next();
            tableModelListener.tableChanged(tableModelEvent);
        }
    }

    public PostMessage getPostMessageInRow(int n) {
        PostMessage postMessage = (PostMessage)this.allPostMessagesList.get(n);
        return postMessage;
    }

    public NewsgroupPost getTreeNodeForMessage(PostMessage postMessage) {
        return (NewsgroupPost)this.newsgroupPostsMap.get(postMessage.getUniqueId());
    }

    public void messageArrived(Message message) {
        CoreLogger.log("new message arrived in newsgroup: " + message.toShortString(), 4);
        PostMessage postMessage = (PostMessage)message;
        NewsgroupPost newsgroupPost = (NewsgroupPost)this.newsgroupPostsMap.get(((PostMessage)message).getUniqueId());
        NewsgroupPost newsgroupPost2 = this.rootNode;
        synchronized (newsgroupPost2) {
            if (newsgroupPost != null) {
                CoreLogger.log("it does exist in the tree, only needs to be updated...", 4);
                int n = this.allPostMessagesList.indexOf(newsgroupPost.getPostMessage());
                this.allPostMessagesList.remove(n);
                newsgroupPost.updatePostMessage(postMessage);
                this.allPostMessagesList.add(n, postMessage);
            } else {
                CoreLogger.log("it does not exist in the tree yet, creating a node and finding out where to put it...", 4);
                newsgroupPost = new NewsgroupPost(postMessage, this.markNewsMessagesAsUnread);
                this.newsgroupPostsMap.put(message.getUniqueId(), newsgroupPost);
                this.allPostMessagesList.add(message);
                this.fireRowsInserted(this.allPostMessagesList.size() - 1);
                if (postMessage.getReplyToUniqueId().length() == 0) {
                    CoreLogger.log("it is not a reply, so it goes to the root...", 4);
                    this.rootNode.insertNewsgroupPost(newsgroupPost);
                    TreePath treePath = this.getPathToRoot((NewsgroupPost)newsgroupPost.getParent());
                    this.fireTreeNodeInserted(treePath, new int[]{this.rootNode.getIndex(newsgroupPost)}, new Object[]{newsgroupPost});
                } else {
                    NewsgroupPost newsgroupPost3 = (NewsgroupPost)this.newsgroupPostsMap.get(postMessage.getReplyToUniqueId());
                    if (newsgroupPost3 == null) {
                        CoreLogger.log("it is a reply to a message that has not yet been received...", 4);
                        this.addPostToUnlinkedRepliesNode(newsgroupPost);
                    } else {
                        CoreLogger.log("it is a reply to " + newsgroupPost3.getPostMessage().toShortString() + ", adding it to that node...", 4);
                        newsgroupPost3.insertNewsgroupPost(newsgroupPost);
                        TreePath treePath = this.getPathToRoot(newsgroupPost3);
                        this.fireTreeNodeInserted(treePath, new int[]{newsgroupPost3.getIndex(newsgroupPost)}, new Object[]{newsgroupPost});
                    }
                }
                if (!this.markNewsMessagesAsUnread) {
                    newsgroupPost.markAsRead();
                }
            }
            CoreLogger.log("looking if there are replies to " + postMessage.toShortString() + " in the temp thread...", 4);
            if (this.missingUniqueIdSet.contains(postMessage.getUniqueId())) {
                CoreLogger.log("there are replies to " + postMessage.toShortString() + " in the temp thread, moving them to the new node...", 4);
                this.movePostsFromUnlinkedRepliesNode(newsgroupPost);
            }
        }
    }

    public void markAsRead(String string) {
        NewsgroupPost newsgroupPost = (NewsgroupPost)this.newsgroupPostsMap.get(string);
        if (newsgroupPost == null) {
            return;
        }
        newsgroupPost.markAsRead();
    }

    public void setMarkNewMessagesAsUnread(boolean bl) {
        this.markNewsMessagesAsUnread = bl;
    }

    void fireTreeNodeChanged(NewsgroupPost newsgroupPost) {
        TreePath treePath = this.getPathToRoot(newsgroupPost);
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath);
        Iterator iterator = this.treeModelListenerList.iterator();
        while (iterator.hasNext()) {
            TreeModelListener treeModelListener = (TreeModelListener)iterator.next();
            treeModelListener.treeNodesInserted(treeModelEvent);
        }
    }

    private void fireTreeNodeInserted(TreePath treePath, int[] nArray, Object[] objectArray) {
        CoreLogger.log("inserting nodes to this path: ", 4);
        Object[] objectArray2 = treePath.getPath();
        int n = 0;
        while (n < objectArray2.length) {
            CoreLogger.log("- " + objectArray2[n].toString(), 4);
            ++n;
        }
        CoreLogger.log("inesrting these objects: ", 4);
        int n2 = 0;
        while (n2 < nArray.length) {
            CoreLogger.log("- " + nArray[n2] + ": " + objectArray[n2].toString(), 4);
            ++n2;
        }
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath, nArray, objectArray);
        Iterator iterator = this.treeModelListenerList.iterator();
        while (iterator.hasNext()) {
            TreeModelListener treeModelListener = (TreeModelListener)iterator.next();
            treeModelListener.treeNodesInserted(treeModelEvent);
        }
    }

    private void fireTreeNodeRemoved(TreePath treePath, int[] nArray, Object[] objectArray) {
        CoreLogger.log("removing nodes from this path: ", 4);
        Object[] objectArray2 = treePath.getPath();
        int n = 0;
        while (n < objectArray2.length) {
            CoreLogger.log("- " + objectArray2[n].toString(), 4);
            ++n;
        }
        CoreLogger.log("removing these objects: ", 4);
        int n2 = 0;
        while (n2 < nArray.length) {
            CoreLogger.log("- " + nArray[n2] + ": " + objectArray[n2].toString(), 4);
            ++n2;
        }
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath, nArray, objectArray);
        Iterator iterator = this.treeModelListenerList.iterator();
        while (iterator.hasNext()) {
            TreeModelListener treeModelListener = (TreeModelListener)iterator.next();
            treeModelListener.treeNodesRemoved(treeModelEvent);
        }
    }

    private void fireTreeStructureChanged(NewsgroupPost newsgroupPost) {
        TreePath treePath = this.getPathToRoot(newsgroupPost);
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath);
        Iterator iterator = this.treeModelListenerList.iterator();
        while (iterator.hasNext()) {
            TreeModelListener treeModelListener = (TreeModelListener)iterator.next();
            treeModelListener.treeStructureChanged(treeModelEvent);
        }
    }

    public TreePath getPathToRoot(NewsgroupPost newsgroupPost) {
        LinkedList<NewsgroupPost> linkedList = new LinkedList<NewsgroupPost>();
        NewsgroupPost newsgroupPost2 = newsgroupPost;
        while (newsgroupPost2 != null) {
            linkedList.add(0, newsgroupPost2);
            newsgroupPost2 = (NewsgroupPost)newsgroupPost2.getParent();
        }
        if (newsgroupPost.getPostMessage() != null) {
            // empty if block
        }
        return new TreePath(linkedList.toArray(new NewsgroupPost[linkedList.size()]));
    }

    private void movePostsFromUnlinkedRepliesNode(NewsgroupPost newsgroupPost) {
        Object object;
        CoreLogger.log("moving all replies to " + newsgroupPost.getPostMessage().toShortString() + " from temporary thread...", 4);
        int n = 0;
        int[] nArray = new int[this.unlinkedRepliesNode.getChildCount()];
        int n2 = 0;
        LinkedList<Object> linkedList = new LinkedList<Object>();
        while (n < this.unlinkedRepliesNode.getChildCount()) {
            object = (NewsgroupPost)this.unlinkedRepliesNode.getChildAt(n);
            if (((NewsgroupPost)object).getPostMessage().getReplyToUniqueId().equals(newsgroupPost.getPostMessage().getUniqueId())) {
                CoreLogger.log("the msg " + ((NewsgroupPost)object).getPostMessage().toShortString() + " from pos " + n + " is added to the new node.", 4);
                ((NewsgroupPost)object).removeFromParent();
                newsgroupPost.insertNewsgroupPost((NewsgroupPost)object);
                linkedList.add(object);
                nArray[n2] = n;
                ++n2;
                continue;
            }
            ++n;
        }
        if (n2 != 0) {
            object = new int[n2];
            System.arraycopy(nArray, 0, object, 0, n2);
            Object[] objectArray = linkedList.toArray(new NewsgroupPost[linkedList.size()]);
            CoreLogger.log("indices have length " + ((Object)object).length + ", nodes have length " + objectArray.length, 4);
            int n3 = 0;
            while (n3 < ((Object)object).length) {
                CoreLogger.log("removed indices: ", 4);
                CoreLogger.log((int)object[n3] + ": " + ((NewsgroupPost)objectArray[n3]).toString(), 4);
                ++n3;
            }
            this.fireTreeNodeRemoved(this.getPathToRoot(this.unlinkedRepliesNode), (int[])object, objectArray);
            int[] nArray2 = new int[((Object)object).length];
            int n4 = 0;
            while (n4 < nArray2.length) {
                nArray2[n4] = n4;
                ++n4;
            }
            this.fireTreeNodeInserted(this.getPathToRoot(newsgroupPost), nArray2, objectArray);
        }
        if (this.unlinkedRepliesNode.getChildCount() == 0) {
            CoreLogger.log("removing the temporary thread because it has no more children", 4);
            int n5 = this.rootNode.getIndex(this.unlinkedRepliesNode);
            int n6 = this.rootNode.getIndex(this.unlinkedRepliesNode);
            this.unlinkedRepliesNode.removeFromParent();
            this.fireTreeNodeRemoved(this.getPathToRoot(this.rootNode), new int[]{n6}, new Object[]{this.unlinkedRepliesNode});
            this.unlinkedRepliesNode = null;
        }
        this.missingUniqueIdSet.remove(newsgroupPost.getPostMessage().getUniqueId());
        CoreLogger.log("finished moving.", 4);
    }

    private void addPostToUnlinkedRepliesNode(NewsgroupPost newsgroupPost) {
        TreePath treePath;
        this.missingUniqueIdSet.add(newsgroupPost.getPostMessage().getReplyToUniqueId());
        if (this.unlinkedRepliesNode == null) {
            CoreLogger.log("adding the temporary thread because it wasn't there yet", 4);
            this.unlinkedRepliesNode = new NewsgroupPost("replies to unreceived messages...", false);
            this.rootNode.insertNewsgroupPost(this.unlinkedRepliesNode);
            treePath = this.getPathToRoot(this.rootNode);
            this.fireTreeNodeInserted(treePath, new int[]{this.rootNode.getIndex(this.unlinkedRepliesNode)}, new Object[]{this.unlinkedRepliesNode});
        }
        this.unlinkedRepliesNode.insertNewsgroupPost(newsgroupPost);
        treePath = this.getPathToRoot(this.unlinkedRepliesNode);
        this.fireTreeNodeInserted(treePath, new int[]{this.unlinkedRepliesNode.getIndex(newsgroupPost)}, new Object[]{newsgroupPost});
        CoreLogger.log("added " + newsgroupPost.getPostMessage().toShortString() + " to the temporary thread", 2);
    }

    public Object getChild(Object object, int n) {
        return ((NewsgroupPost)object).getChildAt(n);
    }

    public int getChildCount(Object object) {
        return ((NewsgroupPost)object).getChildCount();
    }

    public int getIndexOfChild(Object object, Object object2) {
        return ((NewsgroupPost)object).getIndex((NewsgroupPost)object2);
    }

    public Object getRoot() {
        return this.rootNode;
    }

    public boolean isLeaf(Object object) {
        return ((NewsgroupPost)object).isLeaf();
    }

    public void addTreeModelListener(TreeModelListener treeModelListener) {
        CoreLogger.log("tree model listener added: " + treeModelListener.toString(), 4);
        this.treeModelListenerList.add(treeModelListener);
    }

    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.treeModelListenerList.remove(treeModelListener);
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    public int getColumnCount() {
        return this.tableColumnTitles.length;
    }

    public int getRowCount() {
        return this.newsgroupPostsMap.size();
    }

    public void setValueAt(Object object, int n, int n2) {
    }

    public Object getValueAt(int n, int n2) {
        try {
            PostMessage postMessage = (PostMessage)this.allPostMessagesList.get(n);
            NewsgroupPost newsgroupPost = (NewsgroupPost)this.newsgroupPostsMap.get(postMessage.getUniqueId());
            switch (n2) {
                case 0: {
                    return newsgroupPost.getIcon();
                }
                case 1: {
                    if (postMessage.getOriginalPublicKey().equals(postMessage.getSourceKey())) {
                        return ContactList.instance().getNicknameOfPublicKey(postMessage.getOriginalPublicKey());
                    }
                    return ContactList.instance().getNicknameOfPublicKey(postMessage.getOriginalPublicKey()) + " (unverified)";
                }
                case 2: {
                    return postMessage.getSubject();
                }
                case 3: {
                    return postMessage.getDate();
                }
                case 4: {
                    if (newsgroupPost.getParent().equals(this.rootNode)) {
                        return null;
                    }
                    if (newsgroupPost.getParent().equals(this.unlinkedRepliesNode)) {
                        return "?";
                    }
                    return ContactList.instance().getNicknameOfPublicKey(((NewsgroupPost)newsgroupPost.getParent()).getPostMessage().getOriginalPublicKey());
                }
            }
            return "no value";
        }
        catch (Throwable throwable) {
            CoreLogger.log("failed to get data from table model: row " + n + ", col " + n2, 0);
            throwable.printStackTrace();
            CoreLogger.log("don't worry about the stacktrace, the program should keep working fine...", 0);
            return "no value";
        }
    }

    public Class getColumnClass(int n) {
        return this.tableColumnClasses[n];
    }

    public String getColumnName(int n) {
        return this.tableColumnTitles[n];
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public void removeTableModelListener(TableModelListener tableModelListener) {
        this.tableModelListenerList.remove(tableModelListener);
    }

    public void addTableModelListener(TableModelListener tableModelListener) {
        this.tableModelListenerList.add(tableModelListener);
    }
}

