/*
 * Decompiled with CFR 0.152.
 */
package freenetmessageboard.core;

import freenetmessageboard.Main;
import freenetmessageboard.core.ArchiveMessage;
import freenetmessageboard.core.ChannelInfo;
import freenetmessageboard.core.ChessMessage;
import freenetmessageboard.core.ContactList;
import freenetmessageboard.core.CoreLogger;
import freenetmessageboard.core.FMBSettings;
import freenetmessageboard.core.Message;
import freenetmessageboard.core.MessageArchive;
import freenetmessageboard.core.MessageArrivedListener;
import freenetmessageboard.core.MessageFilter;
import freenetmessageboard.core.MessageGateway;
import freenetmessageboard.core.MessageNotReceivedException;
import freenetmessageboard.core.NoSuchContactException;
import freenetmessageboard.core.PersonalInfo;
import freenetmessageboard.core.PostMessage;
import freenetmessageboard.core.UserCommentMessage;
import freenetmessageboard.core.UserMessage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class MessagePool
extends Thread {
    private static MessagePool instance;
    private Map allMessages = new HashMap();
    private Map newMessages = new HashMap();
    private Map lastMessageFromUser = new HashMap();
    private Map messageArrivedListener = new HashMap();
    private Set messagesToBeIgnored = new TreeSet();
    private MessageFilter incomingMessageFilter = MessageFilter.getAcceptAllMessageFilter();
    private static String messagePoolFileName;
    private static String ignoredMessagesFileName;
    static /* synthetic */ Class class$freenetmessageboard$core$UserMessage;
    static /* synthetic */ Class class$freenetmessageboard$core$UserCommentMessage;
    static /* synthetic */ Class class$freenetmessageboard$core$PostMessage;
    static /* synthetic */ Class class$freenetmessageboard$core$ArchiveMessage;
    static /* synthetic */ Class class$freenetmessageboard$core$ChessMessage;

    private MessagePool() {
        this.setName("MessagePool");
    }

    public static MessagePool readMessagePoolFromDisk() throws IOException {
        CoreLogger.log("reading the message pool from disk...", 2);
        MessagePool messagePool = new MessagePool();
        messagePool.incomingMessageFilter = MessageFilter.ignoreByUniqueIDFilter(messagePool.messagesToBeIgnored);
        try {
            String string;
            FileReader fileReader = new FileReader(messagePoolFileName);
            LineNumberReader lineNumberReader = new LineNumberReader(fileReader);
            StringBuffer stringBuffer = new StringBuffer(400);
            while ((string = lineNumberReader.readLine()) != null) {
                stringBuffer.append(string);
                stringBuffer.append('\n');
                if (!string.equals("</message>")) continue;
                Message message = Message.parseString(stringBuffer.toString());
                messagePool.addMessage(message.getSourceUri(), message);
                stringBuffer = new StringBuffer(400);
            }
            CoreLogger.log("read the message pool from disk.", 2);
            return messagePool;
        }
        catch (Exception exception) {
            CoreLogger.log("error reading the message pool from disk: " + exception.getClass().getName() + ": " + exception.getMessage(), 0);
            throw new IOException(exception.getMessage());
        }
    }

    public synchronized MessageArchive createArchive(MessageFilter messageFilter) throws IOException {
        MessageArchive messageArchive;
        CoreLogger.log("creating a message pool archive...", 2);
        Map map = this.allMessages;
        synchronized (map) {
            Message[] messageArray;
            LinkedList<Message[]> linkedList = new LinkedList<Message[]>();
            Iterator iterator = this.allMessages.values().iterator();
            while (iterator.hasNext()) {
                messageArray = (Message[])iterator.next();
                if (!messageFilter.acceptMessage((Message)messageArray)) continue;
                linkedList.add(messageArray);
            }
            Collections.sort(linkedList, Message.getReverseDateComparator());
            messageArray = linkedList.toArray(new Message[linkedList.size()]);
            messageArchive = new MessageArchive(messageArray, "complete archive from " + PersonalInfo.instance().getNickname() + "'s messagepool ");
        }
        return messageArchive;
    }

    private List getCertainMessages(MessageFilter messageFilter, boolean bl) {
        ArrayList<Message> arrayList = new ArrayList<Message>(100);
        Map map = this.allMessages;
        synchronized (map) {
            Iterator iterator = this.allMessages.values().iterator();
            while (iterator.hasNext()) {
                Message message = (Message)iterator.next();
                if (!messageFilter.acceptMessage(message)) continue;
                arrayList.add(message);
            }
        }
        if (bl) {
            Collections.sort(arrayList, Message.getReverseDateComparator());
        } else {
            Collections.sort(arrayList, Message.getDateComparator());
        }
        return arrayList;
    }

    public synchronized void saveToDisk() throws IOException {
        CoreLogger.log("saving the message pool to disk...", 1);
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            File file = new File(messagePoolFileName);
            file.renameTo(new File(messagePoolFileName + ".backup"));
            FileOutputStream fileOutputStream = new FileOutputStream(messagePoolFileName);
            this.processNewMessages();
            List list = this.getCertainMessages(MessageFilter.getMessageTypeFilter(class$freenetmessageboard$core$UserMessage == null ? (class$freenetmessageboard$core$UserMessage = MessagePool.class$("freenetmessageboard.core.UserMessage")) : class$freenetmessageboard$core$UserMessage), false);
            CoreLogger.log("saving user messages...", 2);
            HashSet<String> hashSet = new HashSet<String>();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                object4 = (UserMessage)iterator.next();
                hashSet.add(((UserMessage)object4).getPublicKey());
                fileOutputStream.write(Message.getBytesFromString(((Message)object4).getString()));
                fileOutputStream.write(10);
            }
            hashSet.clear();
            CoreLogger.log("saving user comment messages...", 2);
            object4 = this.getCertainMessages(MessageFilter.getMessageTypeFilter(class$freenetmessageboard$core$UserCommentMessage == null ? (class$freenetmessageboard$core$UserCommentMessage = MessagePool.class$("freenetmessageboard.core.UserCommentMessage")) : class$freenetmessageboard$core$UserCommentMessage), false);
            iterator = object4.iterator();
            while (iterator.hasNext()) {
                object3 = (UserCommentMessage)iterator.next();
                object2 = ((Message)object3).getOriginalPublicKey() + ((UserCommentMessage)object3).getUserPublicKey();
                hashSet.add((String)object2);
                fileOutputStream.write(Message.getBytesFromString(((Message)object3).getString()));
                fileOutputStream.write(10);
            }
            hashSet.clear();
            CoreLogger.log("saving post messages...", 2);
            object3 = this.getCertainMessages(MessageFilter.getMessageTypeFilter(class$freenetmessageboard$core$PostMessage == null ? (class$freenetmessageboard$core$PostMessage = MessagePool.class$("freenetmessageboard.core.PostMessage")) : class$freenetmessageboard$core$PostMessage), false);
            iterator = object3.iterator();
            while (iterator.hasNext()) {
                object2 = (PostMessage)iterator.next();
                fileOutputStream.write(Message.getBytesFromString(((Message)object2).getString()));
                fileOutputStream.write(10);
            }
            hashSet.clear();
            CoreLogger.log("saving archive messages...", 2);
            object2 = this.getCertainMessages(MessageFilter.getMessageTypeFilter(class$freenetmessageboard$core$ArchiveMessage == null ? (class$freenetmessageboard$core$ArchiveMessage = MessagePool.class$("freenetmessageboard.core.ArchiveMessage")) : class$freenetmessageboard$core$ArchiveMessage), true);
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                object = (ArchiveMessage)iterator.next();
                fileOutputStream.write(Message.getBytesFromString(((Message)object).getString()));
                fileOutputStream.write(10);
            }
            hashSet.clear();
            CoreLogger.log("saving chess messages...", 2);
            object = this.getCertainMessages(MessageFilter.getMessageTypeFilter(class$freenetmessageboard$core$ChessMessage == null ? (class$freenetmessageboard$core$ChessMessage = MessagePool.class$("freenetmessageboard.core.ChessMessage")) : class$freenetmessageboard$core$ChessMessage), true);
            iterator = object.iterator();
            while (iterator.hasNext()) {
                ChessMessage chessMessage = (ChessMessage)iterator.next();
                hashSet.add(chessMessage.getGameId());
                fileOutputStream.write(Message.getBytesFromString(chessMessage.getString()));
                fileOutputStream.write(10);
            }
            fileOutputStream.close();
            CoreLogger.log("sucesfully wrote all messages to disk.", 2);
            new File(messagePoolFileName + ".backup").delete();
        }
        catch (Exception exception) {
            CoreLogger.log("failed to write message pool to disk:" + exception.getClass().getName() + ": " + exception.getMessage(), 0);
            exception.printStackTrace();
            throw new IOException(exception.getMessage());
        }
    }

    public synchronized void saveToDiskAlt() throws IOException {
        CoreLogger.log("saving the message pool to disk...", 2);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(messagePoolFileName);
            this.processNewMessages();
            Map map = this.allMessages;
            synchronized (map) {
                LinkedList linkedList = new LinkedList(this.allMessages.values());
                Collections.sort(linkedList, Message.getDateComparator());
                Iterator iterator = linkedList.iterator();
                while (iterator.hasNext()) {
                    Message message = (Message)iterator.next();
                    fileOutputStream.write(Message.getBytesFromString(message.getString()));
                    fileOutputStream.write(10);
                }
            }
            fileOutputStream.close();
            CoreLogger.log("sucesfully wrote all messages to disk.", 2);
        }
        catch (Exception exception) {
            CoreLogger.log("failed to write message pool to disk:" + exception.getClass().getName() + ": " + exception.getMessage(), 0);
            throw new IOException(exception.getMessage());
        }
    }

    boolean shouldMessageBeIgnored(String string) {
        return this.messagesToBeIgnored.contains(string);
    }

    boolean containsMessage(String string) {
        return this.allMessages.containsKey(string);
    }

    public synchronized PostMessage getPostMessage(String string) throws MessageNotReceivedException {
        Message message = (Message)this.allMessages.get(string);
        if (message == null) {
            throw new MessageNotReceivedException();
        }
        if (!(message instanceof PostMessage)) {
            throw new MessageNotReceivedException();
        }
        return (PostMessage)message;
    }

    public synchronized void replaceMessage(Message message, String string) {
        CoreLogger.log("forced insert of the original message " + message + " from " + string, 1);
        Map map = this.newMessages;
        synchronized (map) {
            this.newMessages.put(message.getUniqueId(), message);
        }
    }

    public synchronized void addMessage(String string, Message message) {
        if (!this.incomingMessageFilter.acceptMessage(message)) {
            CoreLogger.log("message " + message.getUniqueId() + " from " + string + " was dropped by the incoming message filter.", 2);
            return;
        }
        Map map = this.newMessages;
        synchronized (map) {
            Map map2 = this.allMessages;
            synchronized (map2) {
                if (!this.allMessages.containsKey(message.getUniqueId())) {
                    if (message.getOriginalUri().equals(string)) {
                        CoreLogger.log("received the original of the new msg " + message.toShortString() + " from " + message.getSourceUri(), 2);
                        if (FMBSettings.instance().autoForward) {
                            this.forwardMessage(message);
                        }
                    } else {
                        CoreLogger.log("received a copy of the new " + message.toShortString() + " from " + message.getSourceUri(), 2);
                    }
                } else {
                    CoreLogger.log("received another copy of " + message.toShortString() + " from " + message.getSourceUri(), 2);
                    Message message2 = (Message)this.allMessages.get(message.getUniqueId());
                    String string2 = message2.getSourceUri();
                    if (!message2.equals(message)) {
                        String string3;
                        CoreLogger.log("the copy from " + string + " is not equal to the copy from " + string2, 2);
                        if (!message2.contentEquals(message)) {
                            CoreLogger.log("one of the messages has a faked content! ", 0);
                            Main.getGUI().verifyMessage(message2, message);
                            return;
                        }
                        if (message2.getSourceUri().equals(message2.getOriginalUri()) && message.getSourceUri().equals(message.getOriginalUri())) {
                            CoreLogger.log("this seems to be only a key collision problem, both message come from the original source and its content is equal", 2);
                            return;
                        }
                        String string4 = message2.getOriginalUri().substring(0, message2.getOriginalUri().lastIndexOf(47) + 1);
                        if (string4.equals(string3 = message.getOriginalUri().substring(0, message.getOriginalUri().lastIndexOf(47) + 1))) {
                            CoreLogger.log("this seems to be only a key collision problem, the content is equal and the original source is on the same channel", 2);
                            return;
                        }
                        Main.getGUI().verifyMessage(message2, message);
                        return;
                    }
                    if (message.getSourceUri().equals(message2.getSourceUri())) {
                        CoreLogger.log("i already have the version from " + message.getSourceUri() + ", keeping it...", 2);
                        return;
                    }
                    if (!message.getOriginalUri().equals(string)) {
                        CoreLogger.log("don't need the copy from " + message.getSourceUri() + ", keep the one from " + message2.getSourceUri(), 2);
                        return;
                    }
                    if (FMBSettings.instance().autoForward) {
                        this.forwardMessage(message);
                    }
                    CoreLogger.log("the new message is from the original source (" + message.getSourceUri() + "), the existing only from " + message2.getSourceUri(), 2);
                }
                CoreLogger.log("thread is adding a new message...", 4);
                this.newMessages.put(message.getUniqueId(), message);
            }
        }
    }

    private void forwardMessage(final Message message) {
        if (message.getOriginalPublicKey().equals(PersonalInfo.instance().getPublicKey())) {
            return;
        }
        Thread thread = new Thread("forwarding thread"){

            public void run() {
                CoreLogger.log("autoforwarding the message " + message.getUniqueId(), 1);
                MessageGateway.instance().sendMessageOnPersonalChannel(message);
            }
        };
        thread.start();
    }

    public Message getLatestMessageFromUser(String string) {
        return (Message)this.lastMessageFromUser.get(string);
    }

    public synchronized void processNewMessages() {
        if (this.newMessages.size() > 0) {
            CoreLogger.log(this.newMessages.size() + " messages are new in the message pool", 2);
        }
        CoreLogger.log("thread wants to enter the monitor...", 4);
        Map map = this.newMessages;
        synchronized (map) {
            CoreLogger.log("thread is processing the new messages", 4);
            Iterator iterator = this.newMessages.keySet().iterator();
            while (iterator.hasNext()) {
                Object object;
                Object object2;
                Object object3;
                String string = (String)iterator.next();
                Message message = (Message)this.newMessages.get(string);
                Map map2 = this.allMessages;
                synchronized (map2) {
                    this.allMessages.put(string, message);
                }
                if (this.lastMessageFromUser.containsKey(message.getOriginalPublicKey())) {
                    object3 = (Message)this.lastMessageFromUser.get(message.getOriginalPublicKey());
                    if (message.getDate().compareTo(((Message)object3).getDate()) > 0) {
                        this.lastMessageFromUser.put(message.getOriginalPublicKey(), message);
                    }
                } else {
                    this.lastMessageFromUser.put(message.getOriginalPublicKey(), message);
                }
                object3 = this.messageArrivedListener.keySet().iterator();
                while (object3.hasNext()) {
                    object2 = (MessageArrivedListener)object3.next();
                    object = (MessageFilter)this.messageArrivedListener.get(object2);
                    if (!((MessageFilter)object).acceptMessage(message)) continue;
                    CoreLogger.log("telling " + object2.getClass().getName() + " that there is a new message " + message.toShortString(), 4);
                    object2.messageArrived(message);
                }
                try {
                    ContactList.instance().getContactInformationOfPublicKey(message.getOriginalPublicKey()).setTimeOfLastActivity(message.getDate());
                }
                catch (NoSuchContactException noSuchContactException) {
                    CoreLogger.log("failed to update activityy time:here is no contact with key " + message.getOriginalPublicKey() + " in the contact list!", 2);
                }
                object2 = message.getOriginalUri().substring(0, message.getOriginalUri().lastIndexOf(47) + 1);
                if (!ChannelInfo.instanceExists((String)object2)) continue;
                object = ChannelInfo.getInstance((String)object2);
                MessageGateway.instance();
                ((ChannelInfo)object).heardOfIndex(MessageGateway.getIndexFromUri(message.getOriginalUri()));
            }
            this.newMessages.clear();
        }
        CoreLogger.log("thread left the monitor", 4);
        CoreLogger.log("the message pool contains " + this.allMessages.size() + " unique messages", 4);
    }

    public Message[] getUsefulMessages() {
        CoreLogger.log("choosing important messages from the message pool...", 2);
        Message[] messageArray = new Message[50];
        Map map = this.allMessages;
        synchronized (map) {
            if (this.allMessages.size() < 50) {
                messageArray = new Message[this.allMessages.size()];
            }
            TreeSet treeSet = new TreeSet(Message.getUsefulorBroadcoastingComparator());
            treeSet.addAll(this.allMessages.values());
            Iterator iterator = treeSet.iterator();
            int n = 0;
            while (iterator.hasNext() && n < messageArray.length) {
                messageArray[n] = (Message)iterator.next();
                ++n;
            }
        }
        CoreLogger.log("returning " + messageArray.length + " useful messages", 2);
        return messageArray;
    }

    public void run() {
        CoreLogger.log("the message pool is beginning to process messages.", 2);
        while (true) {
            this.processNewMessages();
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    void addMessageArrivedListener(MessageArrivedListener messageArrivedListener, MessageFilter messageFilter) {
        Map map = this.messageArrivedListener;
        synchronized (map) {
            this.messageArrivedListener.put(messageArrivedListener, messageFilter);
        }
    }

    public static synchronized MessagePool instance() {
        if (instance == null) {
            try {
                instance = MessagePool.readMessagePoolFromDisk();
            }
            catch (IOException iOException) {
                CoreLogger.log("creating empty message pool...", 1);
                instance = new MessagePool();
            }
        }
        return instance;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        messagePoolFileName = "messages";
        ignoredMessagesFileName = "ignoredMessages";
    }
}

