/*
 * Decompiled with CFR 0.152.
 */
package freenetmessageboard.core;

import freenetmessageboard.Main;
import freenetmessageboard.core.ChannelInfo;
import freenetmessageboard.core.ContactList;
import freenetmessageboard.core.CoreLogger;
import freenetmessageboard.core.FMBSettings;
import freenetmessageboard.core.FreenetNetworkSettings;
import freenetmessageboard.core.Message;
import freenetmessageboard.core.MessageFilter;
import freenetmessageboard.core.MessagePool;
import freenetmessageboard.core.PersonalInfo;
import freenetmessageboard.core.UserCommentMessage;
import freenetmessageboard.core.UserMessage;
import freenetmessageboard.fcpinterface.FCPFacade;
import freenetmessageboard.fcpinterface.FCPInsertCallback;
import freenetmessageboard.fcpinterface.FCPRequestCallback;
import freenetmessageboard.fcpinterface.InsertInfo;
import freenetmessageboard.fcpinterface.RequestedData;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class MessageGateway
extends Thread
implements FCPRequestCallback,
FCPInsertCallback {
    private static MessageGateway instance;
    static final int maxInsertSize = 32000;
    private static long flushTime;
    private static Date currentListeningDate;
    public static DateFormat uriDateFormat;
    private long timeOfLastInsert = new Date().getTime();
    private static final String publicChannelBaseKSKprefix = "KSK@fmb/announcements";
    private static Map currentSlotForInsertsMap;
    private List queuedMessages = new LinkedList();
    private List insertRetryQueueUris = new LinkedList();
    private List insertNextSlotUris = new LinkedList();
    private Map activeInsertMessagesListMap = new HashMap();
    private Map activeInsertsBytes = new HashMap();
    private Map succesfullyInserted = new HashMap();
    private List keyCollisionInserts = new LinkedList();
    private byte[] personalChannelInsertBuffer = new byte[32000];
    private int insertBufferIndex;
    private Map activeRequestInfos = new HashMap();
    private List requestRetryQueueUris = new LinkedList();
    private HashMap activeChannelInfos = new HashMap();
    private List channelsToBeContinued = new ArrayList();
    private List channelToBeStopped = new ArrayList();
    private List spammedUris = new LinkedList();
    private boolean haveAnnouncedToday = false;

    private MessageGateway() {
        this.setName("MessageGateway");
    }

    synchronized void sendMessageOnPublicAnnouncementChannel(Message message) {
        Message[] messageArray = new Message[]{message};
        this.sendMessagesOnPublicAnnouncementChannel(messageArray);
    }

    synchronized void sendMessagesOnPublicAnnouncementChannel(Message[] messageArray) {
        String string = MessageGateway.constructNextPublicAnnouncementChannelUriForInsert(MessageGateway.getCurrentDate());
        MessageGateway.increaseSlotIndexForInsert(string);
        StringBuffer stringBuffer = new StringBuffer(1000);
        LinkedList<Message> linkedList = new LinkedList<Message>();
        int n = 0;
        while (n < messageArray.length) {
            if (messageArray[n] instanceof UserMessage) {
                CoreLogger.log("a " + messageArray[n].getClass().getName() + " is being inserted to " + string, 4);
                if (messageArray[n].getOriginalUri().equals("n/a")) {
                    messageArray[n].setOriginalUri(string);
                }
                stringBuffer.append(messageArray[n].getString());
                stringBuffer.append('\n');
                linkedList.add(messageArray[n]);
            }
            ++n;
        }
        byte[] byArray = Message.getBytesFromString(stringBuffer.toString());
        String string2 = stringBuffer.toString();
        FCPFacade.instance().startFreenetInsert(this, string, new byte[0], byArray, FreenetNetworkSettings.instance().regularInsertHTL, false);
        this.activeInsertMessagesListMap.put(string, linkedList);
        this.activeInsertsBytes.put(string, byArray);
        ChannelInfo channelInfo = ChannelInfo.getInstance(MessageGateway.constructPublicAnnouncementChannelBaseName(MessageGateway.getCurrentDate()));
        channelInfo.setStatusString("inserting announcement...");
    }

    public static Date getCurrentDate() {
        return currentListeningDate;
    }

    synchronized void listenOnChannel(String string) {
        CoreLogger.log("listening on channel " + string + "...", 2);
        ChannelInfo channelInfo = ChannelInfo.getInstance(string);
        String string2 = channelInfo.getNextUri();
        channelInfo.setStatusString("channel queued for listening...");
        this.activeChannelInfos.put(string2, channelInfo);
        int n = channelInfo.getHTLForCurrentRequest();
        this.requestMessagesFromUri(string2, n);
    }

    public synchronized void startListeningOnPublicAnnouncementChannel() {
        String string = MessageGateway.constructNextPublicAnnouncementChannelUriForInsert(MessageGateway.getCurrentDate());
        this.listenOnChannel(string.substring(0, string.lastIndexOf(47) + 1));
    }

    public synchronized void startListeningOnPersonalChannel(String string) {
        String string2 = MessageGateway.constructPersonalChannelBaseName(string, MessageGateway.getCurrentDate());
        if (this.isListeningOnPersonalChannel(string)) {
            CoreLogger.log("you are already listening on the channel " + string2, 1);
            return;
        }
        this.listenOnChannel(string2);
    }

    boolean isListeningOnPersonalChannel(String string) {
        String string2 = MessageGateway.constructPersonalChannelBaseName(string, MessageGateway.getCurrentDate());
        ChannelInfo channelInfo = ChannelInfo.getInstance(string2);
        return this.activeChannelInfos.containsValue(channelInfo);
    }

    public synchronized void stopListeningOnPublicAnnouncementChannel() {
        String string = MessageGateway.constructPublicAnnouncementChannelBaseName(MessageGateway.getCurrentDate());
        CoreLogger.log("listening on the public announcement channel will be stopped soon", 2);
        this.stopListeningOnChannel(string);
    }

    public synchronized void stopListeningOnPersonalChannel(String string) {
        String string2 = MessageGateway.constructPersonalChannelBaseName(string, MessageGateway.getCurrentDate());
        CoreLogger.log("listening on " + string2 + " will be stopped soon", 2);
        this.stopListeningOnChannel(string2);
    }

    private void stopListeningOnChannel(String string) {
        List list = this.channelToBeStopped;
        synchronized (list) {
            this.channelToBeStopped.add(string);
        }
        ChannelInfo channelInfo = ChannelInfo.getInstance(string);
        channelInfo.setStatusString("listening is going to be stopped...");
    }

    private synchronized void requestMessagesFromUri(String string, int n) {
        CoreLogger.log("starting request of " + string + " with htl " + n + "...", 4);
        RequestInfo requestInfo = new RequestInfo(n);
        this.activeRequestInfos.put(string, requestInfo);
        FCPFacade.instance().startFreenetRequest(this, string, n, false);
    }

    synchronized void requestMessagesFromUri(String string) {
        this.requestMessagesFromUri(string, FreenetNetworkSettings.instance().regularRequestHTL);
    }

    public synchronized void sendMessagesOnPersonalChannel(Message[] messageArray) {
        int n = 0;
        while (n < messageArray.length) {
            this.sendMessageOnPersonalChannel(messageArray[n]);
            ++n;
        }
    }

    public synchronized void sendMessageOnPersonalChannel(Message message) {
        byte[] byArray;
        if (FMBSettings.instance().autoForward) {
            flushTime = 300L;
        }
        if (!this.haveAnnouncedToday) {
            CoreLogger.log("the first message is being sent, send announcements first...", 2);
            this.haveAnnouncedToday = true;
            MessageGateway.instance().sendMessagesOnPersonalChannel(ContactList.instance().getUserMessagesToBeAnnounced());
        }
        message.increaseSentCounter();
        CoreLogger.log("a " + message.getClass().getName() + " was queued for insert", 5);
        String string = message.getString();
        if (this.insertBufferIndex == 0) {
            this.timeOfLastInsert = new Date().getTime();
        }
        if (this.insertBufferIndex + (byArray = Message.getBytesFromString(string + "\n")).length > 32000) {
            this.flushPersonalChannelMessageBuffer();
        }
        if (message.getOriginalUri().equals("n/a")) {
            String string2 = MessageGateway.constructNextPersonalChannelURIForInsert(PersonalInfo.instance().getPrivateKey(), MessageGateway.getCurrentDate(), true);
            message.setOriginalUri(string2);
            string = message.getString();
            byArray = Message.getBytesFromString(string + "\n");
        }
        if (message instanceof UserMessage || message instanceof UserCommentMessage) {
            MessagePool.instance().addMessage("not succesfully inserted yet", message);
        }
        CoreLogger.log("adding " + byArray.length + " to the insert buffer at pos " + this.insertBufferIndex + ", total length is " + this.personalChannelInsertBuffer.length, 2);
        System.arraycopy(byArray, 0, this.personalChannelInsertBuffer, this.insertBufferIndex, byArray.length);
        this.insertBufferIndex += byArray.length;
        this.queuedMessages.add(message);
        Main.getGUI().updateContactPanel(PersonalInfo.instance().getPublicKey());
    }

    public synchronized String getSlotInfoStringForMyPersonalChannel() {
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer(30);
        char[] cArray = new char[MessageGateway.getNextIndexForInsert(MessageGateway.constructPersonalChannelBaseName(PersonalInfo.instance().getPrivateKey(), MessageGateway.getCurrentDate()))];
        int n = 0;
        while (n < cArray.length) {
            cArray[n] = 32;
            ++n;
        }
        CoreLogger.log("creating slotinfo string for personal channel (max. " + cArray.length + " chars)", 4);
        int n2 = -1;
        Map map = this.activeInsertMessagesListMap;
        synchronized (map) {
            object2 = this.activeInsertMessagesListMap.keySet().iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                CoreLogger.log("checking active insert " + (String)object, 4);
                if (!Message.isUriFromKey((String)object, PersonalInfo.instance().getPrivateKey())) continue;
                int n3 = MessageGateway.getIndexFromUri((String)object);
                CoreLogger.log("currently inserting on index " + n3, 4);
                cArray[n3] = 73;
                n2 = n3;
            }
        }
        object2 = this.succesfullyInserted;
        synchronized (object2) {
            object = this.succesfullyInserted.keySet().iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                CoreLogger.log("checking inserted " + string, 4);
                if (!Message.isUriFromKey(string, PersonalInfo.instance().getPublicKey())) continue;
                int n4 = MessageGateway.getIndexFromUri(string);
                CoreLogger.log("succesfully inserted on index " + n4, 4);
                cArray[n4] = 88;
                if (n4 <= n2) continue;
                n2 = n4;
            }
        }
        object = this.keyCollisionInserts;
        synchronized (object) {
            Iterator iterator = this.keyCollisionInserts.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                CoreLogger.log("checking key collision " + string, 4);
                if (!Message.isUriFromKey(string, PersonalInfo.instance().getPrivateKey())) continue;
                int n5 = MessageGateway.getIndexFromUri(string);
                CoreLogger.log("key collision on insert of " + n5, 4);
                cArray[n5] = 75;
                if (n5 <= n2) continue;
                n2 = n5;
            }
        }
        int n6 = 0;
        while (n6 <= n2) {
            if (n6 > cArray.length) {
                CoreLogger.log("no space for char " + n6, 4);
            } else {
                stringBuffer.append(cArray[n6]);
            }
            ++n6;
        }
        CoreLogger.log("resulting slot info string: " + stringBuffer.toString(), 4);
        String string = stringBuffer.toString();
        if (string.length() > 30) {
            return "..." + string.substring(string.length() - 30);
        }
        return string;
    }

    public byte[] getUsefulBytesToStuffInsert(int n) {
        CoreLogger.log("trying to find " + n + " useful bytes to stuff the insert...", 2);
        Message[] messageArray = MessagePool.instance().getUsefulMessages();
        byte[] byArray = new byte[n];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < messageArray.length) {
            byte[] byArray2;
            if (MessageFilter.originalMessagesOnlyFilter().acceptMessage(messageArray[n4]) && (byArray2 = Message.getBytesFromString(messageArray[n4].getString() + "\n")).length <= byArray.length - n2) {
                CoreLogger.log("including " + messageArray[n4].toShortString() + ": " + messageArray[n4].getSentCounter() + " sends, " + messageArray[n4].getRetrievedCounter() + " retrieved " + messageArray[n4].getDate(), 2);
                messageArray[n4].increaseSentCounter();
                System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
                n2 += byArray2.length;
                ++n3;
            }
            ++n4;
        }
        CoreLogger.log("filled up " + n + " bytes with " + n3 + " usefull messages!", 2);
        return byArray;
    }

    public boolean areThereActiveInserts() {
        if (this.insertBufferIndex != 0) {
            return true;
        }
        return this.activeInsertMessagesListMap.size() > 0;
    }

    public synchronized void flushPersonalChannelMessageBuffer() {
        if (this.insertBufferIndex == 0) {
            return;
        }
        String string = MessageGateway.constructNextPersonalChannelURIForInsert(PersonalInfo.instance().getPrivateKey(), MessageGateway.getCurrentDate(), false);
        MessageGateway.increaseSlotIndexForInsert(string);
        CoreLogger.log("inserting message buffer to " + string, 2);
        byte[] byArray = new byte[]{};
        byte[] byArray2 = this.getUsefulBytesToStuffInsert(this.personalChannelInsertBuffer.length - this.insertBufferIndex);
        CoreLogger.log("adding " + byArray2.length + " to the insert buffer at pos " + this.insertBufferIndex + ", total length is " + this.personalChannelInsertBuffer.length, 2);
        System.arraycopy(byArray2, 0, this.personalChannelInsertBuffer, this.insertBufferIndex, byArray2.length);
        FCPFacade.instance().startFreenetInsert(this, string, new byte[0], this.personalChannelInsertBuffer, FreenetNetworkSettings.instance().regularInsertHTL, false);
        this.activeInsertMessagesListMap.put(string, this.queuedMessages);
        CoreLogger.log("remembering " + byArray2.length + " of stuffdata for uri " + string, 2);
        this.activeInsertsBytes.put(string, byArray2);
        this.personalChannelInsertBuffer = new byte[32000];
        this.insertBufferIndex = 0;
        Main.getGUI().updateContactPanel(PersonalInfo.instance().getPublicKey());
        this.queuedMessages = new LinkedList();
        this.timeOfLastInsert = new Date().getTime();
    }

    private void startRetries() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        List list = this.insertRetryQueueUris;
        synchronized (list) {
            object4 = this.insertRetryQueueUris.iterator();
            while (object4.hasNext()) {
                this.retryInsert((String)object4.next(), false);
            }
            this.insertRetryQueueUris.clear();
        }
        CoreLogger.log("starting retries on next slots...", 5);
        object4 = this.insertNextSlotUris;
        synchronized (object4) {
            object3 = this.insertNextSlotUris.iterator();
            while (object3.hasNext()) {
                object2 = (String)object3.next();
                if (((String)object2).startsWith(MessageGateway.constructPublicAnnouncementChannelBaseName(MessageGateway.getCurrentDate()))) {
                    object = ChannelInfo.getInstance(((String)object2).substring(0, ((String)object2).lastIndexOf(47) + 1));
                    ((ChannelInfo)object).setStatusString("sending announcement on slot " + MessageGateway.getIndexFromUri((String)object2));
                }
                CoreLogger.log("trying to retry " + (String)object2, 4);
                this.retryInsert((String)object2, true);
                CoreLogger.log("returned from retryInsert", 5);
            }
            this.insertNextSlotUris.clear();
        }
        CoreLogger.log("finished starting retries on next slots", 5);
        object3 = this.requestRetryQueueUris;
        synchronized (object3) {
            object2 = this.requestRetryQueueUris.iterator();
            while (object2.hasNext()) {
                RequestInfo requestInfo;
                object = (String)object2.next();
                Map map = this.activeRequestInfos;
                synchronized (map) {
                    requestInfo = (RequestInfo)this.activeRequestInfos.get(object);
                }
                CoreLogger.log("starting to retry requesting of " + (String)object + " with htl " + requestInfo.htl, 4);
                FCPFacade.instance().startFreenetRequest(this, (String)object, requestInfo.htl, false);
            }
            this.requestRetryQueueUris.clear();
        }
    }

    private void startContinuedChannelRequests() {
        CoreLogger.log("Continuing channel requests...", 4);
        List list = this.channelsToBeContinued;
        synchronized (list) {
            List list2 = this.channelToBeStopped;
            synchronized (list2) {
                Object object;
                CoreLogger.log("Are there channels to be stopped?", 4);
                Iterator iterator = this.channelToBeStopped.iterator();
                while (iterator.hasNext()) {
                    CoreLogger.log("...the channel " + iterator.next() + " should be stopped!", 4);
                }
                if (this.channelToBeStopped.size() == 0) {
                    CoreLogger.log("...no there aren't", 4);
                }
                Iterator iterator2 = this.channelsToBeContinued.iterator();
                ArrayList<String> arrayList = new ArrayList<String>();
                while (iterator2.hasNext()) {
                    object = (ChannelInfo)iterator2.next();
                    CoreLogger.log("checking if channel " + ((ChannelInfo)object).baseName + " should be stopped..", 4);
                    if (this.channelToBeStopped.contains(((ChannelInfo)object).baseName)) {
                        CoreLogger.log("yes it should be stopped", 4);
                        arrayList.add(((ChannelInfo)object).baseName);
                        ((ChannelInfo)object).setStatusString("listening was stopped");
                        continue;
                    }
                    CoreLogger.log("no, you can continue...", 4);
                    this.listenOnChannel(((ChannelInfo)object).baseName);
                }
                object = arrayList.iterator();
                while (object.hasNext()) {
                    this.channelToBeStopped.remove(object.next());
                }
            }
            this.channelsToBeContinued.clear();
        }
    }

    public void run() {
        CoreLogger.log("the message gateway was started", 2);
        while (true) {
            this.startRetries();
            this.startContinuedChannelRequests();
            Date date = new Date();
            long l = date.getTime() - this.timeOfLastInsert;
            if (l > flushTime * 1000L && this.insertBufferIndex > 0) {
                CoreLogger.log("flushing message buffer because it was idle for " + flushTime + " seconds", 2);
                this.flushPersonalChannelMessageBuffer();
            }
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public static synchronized MessageGateway instance() {
        if (instance == null) {
            instance = new MessageGateway();
            instance.start();
        }
        return instance;
    }

    private static synchronized int getNextIndexForInsert(String string) {
        Integer n = (Integer)currentSlotForInsertsMap.get(string);
        int n2 = n == null ? 0 : n;
        currentSlotForInsertsMap.put(string, new Integer(n2));
        return n2;
    }

    private static String constructNextPublicAnnouncementChannelUriForInsert(Date date) {
        StringBuffer stringBuffer = new StringBuffer(40);
        stringBuffer.append(MessageGateway.constructPublicAnnouncementChannelBaseName(date));
        stringBuffer.append(MessageGateway.getNextIndexForInsert(stringBuffer.toString()));
        return stringBuffer.toString();
    }

    public static String constructPersonalChannelBaseName(String string, Date date) {
        StringBuffer stringBuffer = new StringBuffer(80);
        stringBuffer.append("SSK@");
        stringBuffer.append(string);
        stringBuffer.append("/fmb/");
        stringBuffer.append(uriDateFormat.format(date));
        stringBuffer.append("/");
        return stringBuffer.toString();
    }

    static String constructPublicAnnouncementChannelBaseName(Date date) {
        StringBuffer stringBuffer = new StringBuffer(20);
        stringBuffer.append(publicChannelBaseKSKprefix);
        stringBuffer.append("/");
        stringBuffer.append(uriDateFormat.format(date));
        stringBuffer.append("/");
        return stringBuffer.toString();
    }

    void addSpammedUri(String string) {
        CoreLogger.log("the data from " + string + " is no valid fmb data, it is propably being spammed!", 1);
        List list = this.spammedUris;
        synchronized (list) {
            if (!this.spammedUris.contains(string)) {
                this.spammedUris.add(string);
            }
        }
    }

    boolean isUriSpammed(String string) {
        List list = this.spammedUris;
        synchronized (list) {
            boolean bl = this.spammedUris.contains(string);
            return bl;
        }
    }

    private static String constructNextPersonalChannelURIForInsert(String string, Date date, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(80);
        String string2 = MessageGateway.constructPersonalChannelBaseName(string, date);
        int n = MessageGateway.getNextIndexForInsert(string2);
        if (bl) {
            string2 = MessageGateway.constructPersonalChannelBaseName(PersonalInfo.instance().getPublicKey(), date);
        }
        return string2 + n;
    }

    public void insertSuccesfull(String string, InsertInfo insertInfo) {
        Object object;
        List list = (List)this.activeInsertMessagesListMap.remove(string);
        this.activeInsertsBytes.remove(string);
        CoreLogger.log("sucesfully inserted " + list.size() + " messages to " + insertInfo.getFinalUri(), 2);
        Iterator iterator = list.iterator();
        boolean bl = Message.isUriFromKey(string, PersonalInfo.instance().getPrivateKey());
        if (bl) {
            string = PersonalInfo.instance().privateToPublicUri(string);
        }
        this.succesfullyInserted.put(string, insertInfo);
        while (iterator.hasNext()) {
            object = (Message)iterator.next();
            if (object instanceof UserMessage && bl && ((Message)object).getOriginalPublicKey().equals(PersonalInfo.instance().getPublicKey())) {
                CoreLogger.log("succesfull inserted my announcement to my personal channel, inserting a copy on the public announcement channel", 2);
                this.sendMessagesOnPublicAnnouncementChannel(list.toArray(new Message[list.size()]));
            }
            if (!bl || !((Message)object).getOriginalPublicKey().equals(PersonalInfo.instance().getPublicKey())) continue;
            ((Message)object).setSource(string);
            MessagePool.instance().addMessage(string, (Message)object);
        }
        object = MessageGateway.constructPublicAnnouncementChannelBaseName(MessageGateway.getCurrentDate());
        if (string.startsWith((String)object)) {
            Main.getGUI().setAnnouncementChannelStatusString("announcement succesfull", ChannelInfo.getInstance((String)object).getSlotInfoString());
            Main.getGUI().updateContactPanel(PersonalInfo.instance().getPublicKey());
        } else {
            Main.getGUI().updateContactPanel(PersonalInfo.instance().getPublicKey());
        }
    }

    private void retryInsert(String string, boolean bl) {
        byte[] byArray;
        String string2;
        Object object;
        CoreLogger.log("retrying insert of " + string, 2);
        String string3 = string;
        List list = (List)this.activeInsertMessagesListMap.remove(string);
        CoreLogger.log("looking for stuffdata of uri " + string, 2);
        byte[] byArray2 = (byte[])this.activeInsertsBytes.remove(string);
        if (byArray2 == null) {
            CoreLogger.log("no stuffdata found for uri " + string, 2);
        } else {
            CoreLogger.log("found " + byArray2.length + " of stuffdata for uri " + string, 2);
        }
        StringBuffer stringBuffer = new StringBuffer(32000);
        Iterator iterator = list.iterator();
        if (bl) {
            CoreLogger.log("increasing index of uri " + string, 4);
            string = MessageGateway.getCurrentSlotUriForInsert(string3);
            MessageGateway.increaseSlotIndexForInsert(string3);
            CoreLogger.log("increased index of " + string3 + " to " + string, 2);
        }
        CoreLogger.log("updating the original uri of " + list.size() + " messages...", 4);
        while (iterator.hasNext()) {
            object = (Message)iterator.next();
            if (bl) {
                string2 = object.getOriginalUri();
                if (string2.equals(string3)) {
                    object.setOriginalUri(string);
                }
                if (object.getOriginalPublicKey().equals(PersonalInfo.instance().getPublicKey()) && string2.equals(PersonalInfo.instance().privateToPublicUri(string3))) {
                    object.setOriginalUri(PersonalInfo.instance().privateToPublicUri(string));
                }
                CoreLogger.log("the original uri of the " + object.getMessageType() + " message was set to " + object.getOriginalUri(), 4);
            }
            stringBuffer.append(object.getString());
            stringBuffer.append('\n');
        }
        object = new byte[]{};
        string2 = stringBuffer.toString();
        byte[] byArray3 = Message.getBytesFromString(string2);
        if (string.startsWith("SSK@" + PersonalInfo.instance().getPrivateKey())) {
            byArray = new byte[byArray3.length + byArray2.length];
            System.arraycopy(byArray3, 0, byArray, 0, byArray3.length);
            System.arraycopy(byArray2, 0, byArray, byArray3.length, byArray2.length);
        } else {
            byArray = byArray3;
        }
        CoreLogger.log("restarting insert to " + string, 1);
        FCPFacade.instance().startFreenetInsert(this, string, new byte[0], byArray, FreenetNetworkSettings.instance().regularInsertHTL, false);
        CoreLogger.log("returned from FCPFacade.", 4);
        this.activeInsertMessagesListMap.put(string, list);
        if (byArray2 != null) {
            this.activeInsertsBytes.put(string, byArray2);
        }
        Main.getGUI().updateContactPanel(PersonalInfo.instance().getPublicKey());
        CoreLogger.log("returning from retryInsert", 4);
    }

    private void addToInsertNextSlotQueue(String string) {
        CoreLogger.log("inserting " + string + " to next slot queue...", 4);
        List list = this.insertNextSlotUris;
        synchronized (list) {
            this.keyCollisionInserts.add(string);
            this.insertNextSlotUris.add(string);
            CoreLogger.log("Queuing " + string + " done.", 4);
        }
    }

    private void addToInsertRetryQueue(String string) {
        List list = this.insertRetryQueueUris;
        synchronized (list) {
            this.insertRetryQueueUris.add(string);
        }
    }

    static int getIndexFromUri(String string) {
        String string2 = string.substring(string.lastIndexOf(47) + 1);
        return Integer.parseInt(string2);
    }

    private static void increaseSlotIndexForInsert(String string) {
        String string2 = string.substring(0, string.lastIndexOf(47) + 1);
        Integer n = (Integer)currentSlotForInsertsMap.get(string2);
        int n2 = n == null ? 0 : n;
        currentSlotForInsertsMap.put(string2, new Integer(++n2));
    }

    int getCurrentPublicAnnouncementInsertIndex() {
        Map map = this.activeInsertMessagesListMap;
        synchronized (map) {
            Iterator iterator = this.activeInsertMessagesListMap.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (!string.startsWith(MessageGateway.constructPublicAnnouncementChannelBaseName(MessageGateway.getCurrentDate()))) continue;
                int n = MessageGateway.getIndexFromUri(string);
                return n;
            }
        }
        return -1;
    }

    private static String getCurrentSlotUriForInsert(String string) {
        String string2 = string.substring(0, string.lastIndexOf(47) + 1);
        int n = MessageGateway.getNextIndexForInsert(string2);
        return string2 + n;
    }

    public void insertFailedWithKeyCollision(String string) {
        CoreLogger.log("the insert of " + string + " failed with Key Collision, retrying with increased index...", 2);
        this.addToInsertNextSlotQueue(string);
        if (Message.isUriFromKey(string, PersonalInfo.instance().getPrivateKey())) {
            CoreLogger.log("key collision on the personal channel, start requesting " + PersonalInfo.instance().privateToPublicUri(string), 2);
            this.requestMessagesFromUri(PersonalInfo.instance().privateToPublicUri(string), 0);
        }
        Main.getGUI().updateContactPanel(PersonalInfo.instance().getPublicKey());
    }

    public void insertFailedWithRouteNotFound(String string) {
        CoreLogger.log("the insert of " + string + " failed with Route not Found", 1);
        this.addToInsertRetryQueue(string);
        Main.getGUI().updateContactPanel(PersonalInfo.instance().getPublicKey());
    }

    public void insertFailedBadly(String string, String string2) {
        CoreLogger.log("the insert of " + string + " failed badly: " + string2, 0);
        this.addToInsertRetryQueue(string);
        Main.getGUI().updateContactPanel(PersonalInfo.instance().getPublicKey());
    }

    public void requestSuccesfull(String string, RequestedData requestedData) {
        int n;
        Object object;
        CoreLogger.log("request of " + string + " was succesfull", 2);
        this.activeRequestInfos.remove(string);
        if (this.activeChannelInfos.containsKey(string)) {
            CoreLogger.log("the request of " + string + " was a channel request...", 4);
            object = (ChannelInfo)this.activeChannelInfos.get(string);
            ((ChannelInfo)object).receivedIndex(MessageGateway.getIndexFromUri(string));
            n = 1;
            List list = this.channelToBeStopped;
            synchronized (list) {
                if (this.channelToBeStopped.contains(((ChannelInfo)object).baseName)) {
                    CoreLogger.log("requests on channel " + ((ChannelInfo)object).baseName + " are stopped.", 2);
                    ((ChannelInfo)object).setStatusString("stopped listening");
                    n = 0;
                }
            }
            if (n != 0) {
                CoreLogger.log("requests on channel " + ((ChannelInfo)object).baseName + " will be continued.", 4);
                List list2 = this.channelsToBeContinued;
                synchronized (list2) {
                    this.channelsToBeContinued.add(object);
                }
            }
            this.activeChannelInfos.remove(string);
        }
        if (((Message[])(object = Message.parseMultipleMessageString(Message.getStringFromBytes(requestedData.getDataBytes())))).length == 0) {
            this.addSpammedUri(string);
        }
        n = 0;
        while (n < ((Message[])object).length) {
            object[n].setSource(string);
            ((Message)object[n]).increaseRetrievedCounter();
            MessagePool.instance().addMessage(string, (Message)object[n]);
            ++n;
        }
    }

    private void addToRequestRetryQueue(String string) {
        CoreLogger.log("queuing the request " + string + " for retrying...", 4);
        List list = this.requestRetryQueueUris;
        synchronized (list) {
            this.requestRetryQueueUris.add(string);
        }
    }

    public void requestFailedWithRouteNotFound(String string) {
        CoreLogger.log("request of " + string + " failed with route not found", 1);
        RequestInfo requestInfo = (RequestInfo)this.activeRequestInfos.get(string);
        ++requestInfo.retries;
        ++requestInfo.routeNotFound;
        if (requestInfo.retries <= FreenetNetworkSettings.instance().regularRequestRetries) {
            this.addToRequestRetryQueue(string);
        } else {
            CoreLogger.log("the request failed " + requestInfo.retries + " times. stopped retrying.", 0);
        }
    }

    public void requestFailedWithDataNotFound(String string) {
        CoreLogger.log("request of " + string + " failed with data not found", 4);
        if (this.activeChannelInfos.containsKey(string)) {
            CoreLogger.log("the request of " + string + " was a channel request...", 4);
            ChannelInfo channelInfo = (ChannelInfo)this.activeChannelInfos.get(string);
            channelInfo.failedToReceiveIndex(MessageGateway.getIndexFromUri(string));
            CoreLogger.log("requests on channel " + channelInfo.baseName + " will possibly be continued.", 4);
            List list = this.channelsToBeContinued;
            synchronized (list) {
                this.channelsToBeContinued.add(channelInfo);
            }
            this.activeChannelInfos.remove(string);
            return;
        }
        RequestInfo requestInfo = (RequestInfo)this.activeRequestInfos.get(string);
        ++requestInfo.retries;
        requestInfo.htl += FreenetNetworkSettings.instance().regularRequestHTLIncrease;
        ++requestInfo.dataNotFound;
        if (requestInfo.retries <= FreenetNetworkSettings.instance().regularRequestRetries) {
            this.addToRequestRetryQueue(string);
        } else {
            CoreLogger.log("the request failed " + requestInfo.retries + " times. stopped retrying.", 0);
        }
    }

    public void requestStarted(String string) {
        CoreLogger.log("request for " + string + " was started... ", 2);
        if (this.activeChannelInfos.containsKey(string)) {
            ChannelInfo channelInfo = ChannelInfo.getInstance(string.substring(0, string.lastIndexOf(47) + 1));
            if (channelInfo == null) {
                CoreLogger.log("failed to find the channel " + string.substring(0, string.lastIndexOf(47) + 1), 0);
                return;
            }
            channelInfo.setStatusString("looking for slot " + channelInfo.getCurrentSlot() + " with " + channelInfo.getHTLForCurrentRequest() + " htl");
        }
    }

    public void requestFailedBadly(String string, String string2) {
        CoreLogger.log("request of " + string + " failed way bad: " + string2, 0);
        RequestInfo requestInfo = (RequestInfo)this.activeRequestInfos.get(string);
        ++requestInfo.retries;
        ++requestInfo.dataNotFound;
        if (requestInfo.retries <= FreenetNetworkSettings.instance().regularRequestRetries) {
            this.addToRequestRetryQueue(string);
        } else {
            CoreLogger.log("the request failed " + requestInfo.retries + " times. stopped retrying.", 0);
        }
    }

    public int getActiveInsertCount() {
        return this.activeInsertMessagesListMap.size();
    }

    public int getSendBufferSize() {
        return this.insertBufferIndex;
    }

    static {
        flushTime = 1800L;
        currentListeningDate = new Date();
        currentSlotForInsertsMap = new HashMap();
        uriDateFormat = new SimpleDateFormat("yyyy.MM.dd");
        uriDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    private class RequestInfo {
        int retries = 0;
        int routeNotFound = 0;
        int dataNotFound = 0;
        int htl;

        RequestInfo(int n) {
            this.htl = n;
        }
    }
}

